/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.event;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManager.class);
    private static final EventBus eventBus = new EventBus();
    private static final int ASYNC_QUEUE_SIZE = 100000;
    private static volatile EventBus eventBoundedAsyncEventBus;
    private static final Object LOCK;

    public static EventBus getEventBus() {
        return eventBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventBus getEventBoundedAsyncEventBus() {
        if (eventBoundedAsyncEventBus == null) {
            Object object = LOCK;
            synchronized (object) {
                if (eventBoundedAsyncEventBus == null) {
                    ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 20, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100000), (ThreadFactory)new DefaultThreadFactory("event", true), (r, e) -> LOGGER.warn("Event discarded"));
                    eventBoundedAsyncEventBus = new AsyncEventBus("async", (Executor)executor);
                }
            }
        }
        return eventBoundedAsyncEventBus;
    }

    public static void post(Object event) {
        eventBus.post(event);
    }

    public static void register(Object subscriber) {
        eventBus.register(subscriber);
    }

    static {
        LOCK = new Object();
    }
}

