/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.context;

import com.huaweicloud.common.context.InvocationStage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class InvocationContext {
    public static final String CONTEXT_MICROSERVICE_NAME = "x-microservice-name";
    public static final String CONTEXT_INSTANCE_ID = "x-instance-id";
    public static final String CONTEXT_TRACE_ID = "x-trace-id";
    public static final String CONTEXT_OPERATION_ID = "x-operation-id";
    protected Map<String, String> context = new HashMap<String, String>();
    protected Map<String, Object> localContext = new HashMap<String, Object>();
    protected InvocationStage invocationStage = new InvocationStage(this);

    public InvocationContext putContext(String key, String value) {
        this.context.put(key, value);
        return this;
    }

    public InvocationContext putContext(Map<String, String> data) {
        this.context.putAll(data);
        return this;
    }

    public String getContext(String key) {
        return this.context.get(key);
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public InvocationStage getInvocationStage() {
        return this.invocationStage;
    }

    public InvocationContext putLocalContext(String key, Object value) {
        this.localContext.put(key, value);
        return this;
    }

    public <T> T getLocalContext(String key) {
        return (T)this.localContext.get(key);
    }

    public static String generateTraceId() {
        long epochSeconds = System.currentTimeMillis() / 1000L;
        int random = ThreadLocalRandom.current().nextInt();
        return Long.toHexString((epochSeconds & 0xFFFFFFFFL) << 32 | (long)random & 0xFFFFFFFFL);
    }
}

