/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webmvc;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.context.InvocationContextHolder;
import com.huaweicloud.common.context.InvocationStage;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvocationContextFilter
implements Filter {
    private final ContextProperties contextProperties;

    public InvocationContextFilter(ContextProperties contextProperties) {
        this.contextProperties = contextProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        InvocationContext context = InvocationContextHolder.deserializeAndCreate(httpServletRequest.getHeader("x-invocation-context"));
        this.contextProperties.getHeaderContextMapper().forEach((k, v) -> context.putContext((String)v, httpServletRequest.getHeader(k)));
        this.contextProperties.getQueryContextMapper().forEach((k, v) -> context.putContext((String)v, httpServletRequest.getParameter(k)));
        if (context.getContext("x-trace-id") == null) {
            context.putContext("x-trace-id", InvocationContext.generateTraceId());
        }
        InvocationStage stage = context.getInvocationStage();
        stage.begin(this.buildId((HttpServletRequest)request, context));
        try {
            chain.doFilter(request, response);
        }
        finally {
            stage.finish(((HttpServletResponse)response).getStatus());
        }
    }

    private String buildId(HttpServletRequest request, InvocationContext context) {
        if (this.contextProperties.isUseContextOperationForMetrics()) {
            if (context.getContext("x-operation-id") != null) {
                return context.getContext("x-operation-id");
            }
            String id = this.buildOperation(request);
            context.putContext("x-operation-id", id);
            return id;
        }
        return this.buildOperation(request);
    }

    private String buildOperation(HttpServletRequest request) {
        return request.getMethod() + " " + request.getRequestURI();
    }
}

