/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webmvc;

import com.huaweicloud.common.adapters.webmvc.PostHandlerInterceptor;
import com.huaweicloud.common.adapters.webmvc.PreHandlerInterceptor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class DecorateHandlerInterceptor
implements HandlerInterceptor,
Ordered {
    private final List<PreHandlerInterceptor> preHandlerInterceptors;
    private final List<PostHandlerInterceptor> postHandlerInterceptors;

    public DecorateHandlerInterceptor(List<PreHandlerInterceptor> preHandlerInterceptors, List<PostHandlerInterceptor> postHandlerInterceptors) {
        this.preHandlerInterceptors = preHandlerInterceptors;
        this.postHandlerInterceptors = postHandlerInterceptors;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.preHandlerInterceptors == null) {
            return true;
        }
        for (PreHandlerInterceptor preHandler : this.preHandlerInterceptors) {
            if (preHandler.handle(request, response, handler)) continue;
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        if (this.postHandlerInterceptors == null) {
            return;
        }
        for (PostHandlerInterceptor postHandlerInterceptor : this.postHandlerInterceptors) {
            postHandlerInterceptor.handle(request, response, handler, modelAndView);
        }
    }

    public int getOrder() {
        return 0;
    }
}

