/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.webclient;

import com.huaweicloud.common.context.InvocationContext;
import org.springframework.core.Ordered;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class WebClientMetricsExchangeFilterFunction
implements ExchangeFilterFunction,
Ordered {
    public int getOrder() {
        return 10;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        InvocationContext context = request.attribute("x-invocation-context").isPresent() ? (InvocationContext)request.attribute("x-invocation-context").get() : new InvocationContext();
        String stageName = context.getInvocationStage().recordStageBegin(this.stageId(request));
        return next.exchange(request).doOnSuccess(response -> context.getInvocationStage().recordStageEnd(stageName)).doOnError(error -> context.getInvocationStage().recordStageEnd(stageName));
    }

    private String stageId(ClientRequest request) {
        return "webClient " + request.method().name() + " " + request.url().getPath();
    }
}

