/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.adapters.web;

import com.huaweicloud.common.context.InvocationContext;
import com.huaweicloud.common.context.InvocationContextHolder;
import java.io.IOException;
import org.springframework.core.Ordered;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class MetricsClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor,
Ordered {
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        InvocationContext context = InvocationContextHolder.getOrCreateInvocationContext();
        String stageName = context.getInvocationStage().recordStageBegin(this.stageId(request));
        try {
            ClientHttpResponse response = execution.execute(request, body);
            context.getInvocationStage().recordStageEnd(stageName);
            return response;
        }
        catch (Throwable error) {
            context.getInvocationStage().recordStageEnd(stageName);
            throw error;
        }
    }

    private String stageId(HttpRequest request) {
        return "restTemplate " + request.getMethod().name() + " " + request.getURI().getPath();
    }

    public int getOrder() {
        return -2147483646;
    }
}

