/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.access;

import com.huaweicloud.common.configration.dynamic.ContextProperties;
import com.huaweicloud.common.context.InvocationContext;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"access_logger");
    private final ContextProperties contextProperties;
    private final String format;

    public AccessLogLogger(ContextProperties contextProperties) {
        this.contextProperties = contextProperties;
        this.format = this.initializeFormat(contextProperties);
    }

    private String initializeFormat(ContextProperties contextProperties) {
        StringBuilder result = new StringBuilder();
        result.append("|");
        if (contextProperties.getTraceContexts() != null) {
            for (int i = 0; i < contextProperties.getTraceContexts().size(); ++i) {
                result.append("{}|");
            }
        }
        result.append("{}|{}|{}|{}|");
        String format = result.toString();
        return format;
    }

    public void log(InvocationContext context, String request, int status, long time) {
        if (!this.contextProperties.isEnableTraceInfo()) {
            return;
        }
        if (this.contextProperties.getTraceLevel() == null) {
            LOGGER.info(this.format, this.buildArguments(context, request, status, time));
            return;
        }
        if ("WARN".equals(this.contextProperties.getTraceLevel())) {
            LOGGER.warn(this.format, this.buildArguments(context, request, status, time));
            return;
        }
        if ("ERROR".equals(this.contextProperties.getTraceLevel())) {
            LOGGER.error(this.format, this.buildArguments(context, request, status, time));
            return;
        }
        if ("DEBUG".equals(this.contextProperties.getTraceLevel())) {
            LOGGER.debug(this.format, this.buildArguments(context, request, status, time));
            return;
        }
        LOGGER.info(this.format, this.buildArguments(context, request, status, time));
    }

    private Object[] buildArguments(InvocationContext context, String request, int status, long time) {
        ArrayList<Object> result = new ArrayList<Object>(10);
        if (this.contextProperties.getTraceContexts() != null) {
            for (String item : this.contextProperties.getTraceContexts()) {
                result.add(context.getContext(item) == null ? "" : context.getContext(item));
            }
        }
        result.add(context.getContext("x-trace-id"));
        result.add(status);
        result.add(time);
        result.add(request);
        return result.toArray(new Object[0]);
    }
}

