/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.as.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.as.v1.model.Links;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VersionInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private IdEnum id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="links")
    private List<Links> links = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="min_version")
    private String minVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="update")
    private OffsetDateTime update;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="version")
    private String version;

    public VersionInfo withId(IdEnum id) {
        this.id = id;
        return this;
    }

    public IdEnum getId() {
        return this.id;
    }

    public void setId(IdEnum id) {
        this.id = id;
    }

    public VersionInfo withLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public VersionInfo addLinksItem(Links linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Links>();
        }
        this.links.add(linksItem);
        return this;
    }

    public VersionInfo withLinks(Consumer<List<Links>> linksSetter) {
        if (this.links == null) {
            this.links = new ArrayList<Links>();
        }
        linksSetter.accept(this.links);
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public void setLinks(List<Links> links) {
        this.links = links;
    }

    public VersionInfo withMinVersion(String minVersion) {
        this.minVersion = minVersion;
        return this;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public VersionInfo withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public VersionInfo withUpdate(OffsetDateTime update) {
        this.update = update;
        return this;
    }

    public OffsetDateTime getUpdate() {
        return this.update;
    }

    public void setUpdate(OffsetDateTime update) {
        this.update = update;
    }

    public VersionInfo withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo versionInfo = (VersionInfo)o;
        return Objects.equals(this.id, versionInfo.id) && Objects.equals(this.links, versionInfo.links) && Objects.equals(this.minVersion, versionInfo.minVersion) && Objects.equals(this.status, versionInfo.status) && Objects.equals(this.update, versionInfo.update) && Objects.equals(this.version, versionInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.links, this.minVersion, this.status, this.update, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    minVersion: ").append(this.toIndentedString(this.minVersion)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    update: ").append(this.toIndentedString(this.update)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum CURRENT = new StatusEnum("CURRENT");
        public static final StatusEnum SUPPORT = new StatusEnum("SUPPORT");
        public static final StatusEnum DEPRECATED = new StatusEnum("DEPRECATED");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("CURRENT", CURRENT);
            map.put("SUPPORT", SUPPORT);
            map.put("DEPRECATED", DEPRECATED);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            StatusEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new StatusEnum(value);
            }
            return result;
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            StatusEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class IdEnum {
        public static final IdEnum V1 = new IdEnum("v1");
        public static final IdEnum V2 = new IdEnum("v2");
        private static final Map<String, IdEnum> STATIC_FIELDS = IdEnum.createStaticFields();
        private String value;

        private static Map<String, IdEnum> createStaticFields() {
            HashMap<String, IdEnum> map = new HashMap<String, IdEnum>();
            map.put("v1", V1);
            map.put("v2", V2);
            return Collections.unmodifiableMap(map);
        }

        IdEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IdEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            IdEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new IdEnum(value);
            }
            return result;
        }

        public static IdEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            IdEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof IdEnum) {
                return this.value.equals(((IdEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

