/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.as.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ScheduledPolicy {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="launch_time")
    private String launchTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="recurrence_type")
    private RecurrenceTypeEnum recurrenceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="recurrence_value")
    private String recurrenceValue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="start_time")
    private String startTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="end_time")
    private String endTime;

    public ScheduledPolicy withLaunchTime(String launchTime) {
        this.launchTime = launchTime;
        return this;
    }

    public String getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(String launchTime) {
        this.launchTime = launchTime;
    }

    public ScheduledPolicy withRecurrenceType(RecurrenceTypeEnum recurrenceType) {
        this.recurrenceType = recurrenceType;
        return this;
    }

    public RecurrenceTypeEnum getRecurrenceType() {
        return this.recurrenceType;
    }

    public void setRecurrenceType(RecurrenceTypeEnum recurrenceType) {
        this.recurrenceType = recurrenceType;
    }

    public ScheduledPolicy withRecurrenceValue(String recurrenceValue) {
        this.recurrenceValue = recurrenceValue;
        return this;
    }

    public String getRecurrenceValue() {
        return this.recurrenceValue;
    }

    public void setRecurrenceValue(String recurrenceValue) {
        this.recurrenceValue = recurrenceValue;
    }

    public ScheduledPolicy withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ScheduledPolicy withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledPolicy scheduledPolicy = (ScheduledPolicy)o;
        return Objects.equals(this.launchTime, scheduledPolicy.launchTime) && Objects.equals(this.recurrenceType, scheduledPolicy.recurrenceType) && Objects.equals(this.recurrenceValue, scheduledPolicy.recurrenceValue) && Objects.equals(this.startTime, scheduledPolicy.startTime) && Objects.equals(this.endTime, scheduledPolicy.endTime);
    }

    public int hashCode() {
        return Objects.hash(this.launchTime, this.recurrenceType, this.recurrenceValue, this.startTime, this.endTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduledPolicy {\n");
        sb.append("    launchTime: ").append(this.toIndentedString(this.launchTime)).append("\n");
        sb.append("    recurrenceType: ").append(this.toIndentedString(this.recurrenceType)).append("\n");
        sb.append("    recurrenceValue: ").append(this.toIndentedString(this.recurrenceValue)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class RecurrenceTypeEnum {
        public static final RecurrenceTypeEnum DAILY = new RecurrenceTypeEnum("Daily");
        public static final RecurrenceTypeEnum WEEKLY = new RecurrenceTypeEnum("Weekly");
        public static final RecurrenceTypeEnum MONTHLY = new RecurrenceTypeEnum("Monthly");
        private static final Map<String, RecurrenceTypeEnum> STATIC_FIELDS = RecurrenceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, RecurrenceTypeEnum> createStaticFields() {
            HashMap<String, RecurrenceTypeEnum> map = new HashMap<String, RecurrenceTypeEnum>();
            map.put("Daily", DAILY);
            map.put("Weekly", WEEKLY);
            map.put("Monthly", MONTHLY);
            return Collections.unmodifiableMap(map);
        }

        RecurrenceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurrenceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            RecurrenceTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new RecurrenceTypeEnum(value);
            }
            return result;
        }

        public static RecurrenceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            RecurrenceTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecurrenceTypeEnum) {
                return this.value.equals(((RecurrenceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

