/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.as.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.as.v1.model.BandwidthResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EipResult {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ip_type")
    private IpTypeEnum ipType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="bandwidth")
    private BandwidthResult bandwidth;

    public EipResult withIpType(IpTypeEnum ipType) {
        this.ipType = ipType;
        return this;
    }

    public IpTypeEnum getIpType() {
        return this.ipType;
    }

    public void setIpType(IpTypeEnum ipType) {
        this.ipType = ipType;
    }

    public EipResult withBandwidth(BandwidthResult bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public EipResult withBandwidth(Consumer<BandwidthResult> bandwidthSetter) {
        if (this.bandwidth == null) {
            this.bandwidth = new BandwidthResult();
            bandwidthSetter.accept(this.bandwidth);
        }
        return this;
    }

    public BandwidthResult getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(BandwidthResult bandwidth) {
        this.bandwidth = bandwidth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EipResult eipResult = (EipResult)o;
        return Objects.equals(this.ipType, eipResult.ipType) && Objects.equals(this.bandwidth, eipResult.bandwidth);
    }

    public int hashCode() {
        return Objects.hash(this.ipType, this.bandwidth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EipResult {\n");
        sb.append("    ipType: ").append(this.toIndentedString(this.ipType)).append("\n");
        sb.append("    bandwidth: ").append(this.toIndentedString(this.bandwidth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class IpTypeEnum {
        public static final IpTypeEnum _5_BGP = new IpTypeEnum("5_bgp");
        public static final IpTypeEnum _5_SBGP = new IpTypeEnum("5_sbgp");
        public static final IpTypeEnum _5_TELCOM = new IpTypeEnum("5_telcom");
        public static final IpTypeEnum _5_UNION = new IpTypeEnum("5_union");
        private static final Map<String, IpTypeEnum> STATIC_FIELDS = IpTypeEnum.createStaticFields();
        private String value;

        private static Map<String, IpTypeEnum> createStaticFields() {
            HashMap<String, IpTypeEnum> map = new HashMap<String, IpTypeEnum>();
            map.put("5_bgp", _5_BGP);
            map.put("5_sbgp", _5_SBGP);
            map.put("5_telcom", _5_TELCOM);
            map.put("5_union", _5_UNION);
            return Collections.unmodifiableMap(map);
        }

        IpTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IpTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            IpTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new IpTypeEnum(value);
            }
            return result;
        }

        public static IpTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            IpTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof IpTypeEnum) {
                return this.value.equals(((IpTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

