/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.as.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.as.v1.model.MetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DiskInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="size")
    private Integer size;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="volume_type")
    private VolumeTypeEnum volumeType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="disk_type")
    private DiskTypeEnum diskType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="dedicated_storage_id")
    private String dedicatedStorageId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="data_disk_image_id")
    private String dataDiskImageId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="snapshot_id")
    private String snapshotId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="metadata")
    private MetaData metadata;

    public DiskInfo withSize(Integer size) {
        this.size = size;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public DiskInfo withVolumeType(VolumeTypeEnum volumeType) {
        this.volumeType = volumeType;
        return this;
    }

    public VolumeTypeEnum getVolumeType() {
        return this.volumeType;
    }

    public void setVolumeType(VolumeTypeEnum volumeType) {
        this.volumeType = volumeType;
    }

    public DiskInfo withDiskType(DiskTypeEnum diskType) {
        this.diskType = diskType;
        return this;
    }

    public DiskTypeEnum getDiskType() {
        return this.diskType;
    }

    public void setDiskType(DiskTypeEnum diskType) {
        this.diskType = diskType;
    }

    public DiskInfo withDedicatedStorageId(String dedicatedStorageId) {
        this.dedicatedStorageId = dedicatedStorageId;
        return this;
    }

    public String getDedicatedStorageId() {
        return this.dedicatedStorageId;
    }

    public void setDedicatedStorageId(String dedicatedStorageId) {
        this.dedicatedStorageId = dedicatedStorageId;
    }

    public DiskInfo withDataDiskImageId(String dataDiskImageId) {
        this.dataDiskImageId = dataDiskImageId;
        return this;
    }

    public String getDataDiskImageId() {
        return this.dataDiskImageId;
    }

    public void setDataDiskImageId(String dataDiskImageId) {
        this.dataDiskImageId = dataDiskImageId;
    }

    public DiskInfo withSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public DiskInfo withMetadata(MetaData metadata) {
        this.metadata = metadata;
        return this;
    }

    public DiskInfo withMetadata(Consumer<MetaData> metadataSetter) {
        if (this.metadata == null) {
            this.metadata = new MetaData();
            metadataSetter.accept(this.metadata);
        }
        return this;
    }

    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetaData metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskInfo diskInfo = (DiskInfo)o;
        return Objects.equals(this.size, diskInfo.size) && Objects.equals(this.volumeType, diskInfo.volumeType) && Objects.equals(this.diskType, diskInfo.diskType) && Objects.equals(this.dedicatedStorageId, diskInfo.dedicatedStorageId) && Objects.equals(this.dataDiskImageId, diskInfo.dataDiskImageId) && Objects.equals(this.snapshotId, diskInfo.snapshotId) && Objects.equals(this.metadata, diskInfo.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.volumeType, this.diskType, this.dedicatedStorageId, this.dataDiskImageId, this.snapshotId, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DiskInfo {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    volumeType: ").append(this.toIndentedString(this.volumeType)).append("\n");
        sb.append("    diskType: ").append(this.toIndentedString(this.diskType)).append("\n");
        sb.append("    dedicatedStorageId: ").append(this.toIndentedString(this.dedicatedStorageId)).append("\n");
        sb.append("    dataDiskImageId: ").append(this.toIndentedString(this.dataDiskImageId)).append("\n");
        sb.append("    snapshotId: ").append(this.toIndentedString(this.snapshotId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class DiskTypeEnum {
        public static final DiskTypeEnum SYS = new DiskTypeEnum("SYS");
        public static final DiskTypeEnum DATA = new DiskTypeEnum("DATA");
        private static final Map<String, DiskTypeEnum> STATIC_FIELDS = DiskTypeEnum.createStaticFields();
        private String value;

        private static Map<String, DiskTypeEnum> createStaticFields() {
            HashMap<String, DiskTypeEnum> map = new HashMap<String, DiskTypeEnum>();
            map.put("SYS", SYS);
            map.put("DATA", DATA);
            return Collections.unmodifiableMap(map);
        }

        DiskTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DiskTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            DiskTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new DiskTypeEnum(value);
            }
            return result;
        }

        public static DiskTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            DiskTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof DiskTypeEnum) {
                return this.value.equals(((DiskTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class VolumeTypeEnum {
        public static final VolumeTypeEnum SATA = new VolumeTypeEnum("SATA");
        public static final VolumeTypeEnum SAS = new VolumeTypeEnum("SAS");
        public static final VolumeTypeEnum SSD = new VolumeTypeEnum("SSD");
        public static final VolumeTypeEnum CO_PL = new VolumeTypeEnum("co-pl");
        public static final VolumeTypeEnum UH_11 = new VolumeTypeEnum("uh-11");
        public static final VolumeTypeEnum GPSSD = new VolumeTypeEnum("GPSSD");
        private static final Map<String, VolumeTypeEnum> STATIC_FIELDS = VolumeTypeEnum.createStaticFields();
        private String value;

        private static Map<String, VolumeTypeEnum> createStaticFields() {
            HashMap<String, VolumeTypeEnum> map = new HashMap<String, VolumeTypeEnum>();
            map.put("SATA", SATA);
            map.put("SAS", SAS);
            map.put("SSD", SSD);
            map.put("co-pl", CO_PL);
            map.put("uh-11", UH_11);
            map.put("GPSSD", GPSSD);
            return Collections.unmodifiableMap(map);
        }

        VolumeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VolumeTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            VolumeTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new VolumeTypeEnum(value);
            }
            return result;
        }

        public static VolumeTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            VolumeTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof VolumeTypeEnum) {
                return this.value.equals(((VolumeTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

