/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.as.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.as.v1.model.CreateTagsOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CreateScalingTagInfoRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_type")
    private ResourceTypeEnum resourceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_id")
    private String resourceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private CreateTagsOption body;

    public CreateScalingTagInfoRequest withResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public CreateScalingTagInfoRequest withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public CreateScalingTagInfoRequest withBody(CreateTagsOption body) {
        this.body = body;
        return this;
    }

    public CreateScalingTagInfoRequest withBody(Consumer<CreateTagsOption> bodySetter) {
        if (this.body == null) {
            this.body = new CreateTagsOption();
            bodySetter.accept(this.body);
        }
        return this;
    }

    public CreateTagsOption getBody() {
        return this.body;
    }

    public void setBody(CreateTagsOption body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateScalingTagInfoRequest createScalingTagInfoRequest = (CreateScalingTagInfoRequest)o;
        return Objects.equals(this.resourceType, createScalingTagInfoRequest.resourceType) && Objects.equals(this.resourceId, createScalingTagInfoRequest.resourceId) && Objects.equals(this.body, createScalingTagInfoRequest.body);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.resourceId, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateScalingTagInfoRequest {\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ResourceTypeEnum {
        public static final ResourceTypeEnum SCALING_GROUP_TAG = new ResourceTypeEnum("scaling_group_tag");
        private static final Map<String, ResourceTypeEnum> STATIC_FIELDS = ResourceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ResourceTypeEnum> createStaticFields() {
            HashMap<String, ResourceTypeEnum> map = new HashMap<String, ResourceTypeEnum>();
            map.put("scaling_group_tag", SCALING_GROUP_TAG);
            return Collections.unmodifiableMap(map);
        }

        ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            ResourceTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new ResourceTypeEnum(value);
            }
            return result;
        }

        public static ResourceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            ResourceTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceTypeEnum) {
                return this.value.equals(((ResourceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

