/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.BasicObsCredentialsProvider;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.model.AuthTypeEnum;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProviderCredentials {
    protected static final ILogger log = LoggerBuilder.getLogger(ProviderCredentials.class);
    protected AuthTypeEnum authType;
    private LinkedHashMap<String, AuthTypeEnum> localAuthType;
    private IObsCredentialsProvider obsCredentialsProvider;
    private boolean isAuthTypeNegotiation;

    public String getRegion() {
        return "region";
    }

    public ProviderCredentials(String accessKey, String secretKey, String securityToken) {
        this.setObsCredentialsProvider(new BasicObsCredentialsProvider(accessKey, secretKey, securityToken));
    }

    public void setLocalAuthTypeCacheCapacity(final int localAuthTypeCacheCapacity) {
        this.localAuthType = new LinkedHashMap<String, AuthTypeEnum>(localAuthTypeCacheCapacity, 0.7f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, AuthTypeEnum> entry) {
                return this.size() > localAuthTypeCacheCapacity;
            }
        };
    }

    public AuthTypeEnum getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthTypeEnum authType) {
        this.authType = authType;
    }

    public void setIsAuthTypeNegotiation(boolean isAuthTypeNegotiation) {
        this.isAuthTypeNegotiation = isAuthTypeNegotiation;
    }

    public boolean getIsAuthTypeNegotiation() {
        return this.isAuthTypeNegotiation;
    }

    public void setObsCredentialsProvider(IObsCredentialsProvider obsCredentialsProvider) {
        this.obsCredentialsProvider = obsCredentialsProvider;
    }

    public IObsCredentialsProvider getObsCredentialsProvider() {
        return this.obsCredentialsProvider;
    }

    public BasicSecurityKey getSecurityKey() {
        return (BasicSecurityKey)this.obsCredentialsProvider.getSecurityKey();
    }

    public AuthTypeEnum getLocalAuthType(String bucketName) {
        if (!this.isAuthTypeNegotiation) {
            return this.authType;
        }
        AuthTypeEnum authTypeEnum = this.localAuthType.get(bucketName);
        return authTypeEnum == null ? this.authType : authTypeEnum;
    }

    public void setLocalAuthType(String bucketName, AuthTypeEnum authType) {
        if (this.localAuthType == null || bucketName.isEmpty()) {
            return;
        }
        this.localAuthType.put(bucketName, authType);
    }

    public LinkedHashMap<String, AuthTypeEnum> getLocalAuthType() {
        return this.localAuthType;
    }

    public void setLocalAuthType(LinkedHashMap<String, AuthTypeEnum> localAuthType) {
        this.localAuthType = localAuthType;
    }
}

