/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.DefaultProgressStatus;
import com.obs.services.internal.ProgressManager;
import com.obs.services.model.ProgressListener;

public class SimpleProgressManager
extends ProgressManager {
    protected long transferredBytes;
    protected long newlyTransferredBytes;
    protected long lastSecondBytes = -1L;
    protected long currentSecondBytes;
    protected long lastSwapTimeStamp = System.currentTimeMillis();

    public SimpleProgressManager(long totalBytes, long transferredBytes, ProgressListener progressListener, long intervalBytes) {
        super(totalBytes, progressListener, intervalBytes);
        this.transferredBytes = transferredBytes < 0L ? 0L : transferredBytes;
    }

    @Override
    protected void doProgressChanged(int bytes) {
        this.transferredBytes += (long)bytes;
        this.newlyTransferredBytes += (long)bytes;
        long now = System.currentTimeMillis();
        long swapIntervalTime = now - this.lastSwapTimeStamp;
        this.currentSecondBytes += (long)bytes;
        if (swapIntervalTime > 1000L) {
            this.lastSecondBytes = (long)((double)this.currentSecondBytes / ((double)swapIntervalTime / 1000.0));
            this.currentSecondBytes = 0L;
            this.lastSwapTimeStamp = now;
        }
        if (this.newlyTransferredBytes >= this.intervalBytes && (this.transferredBytes < this.totalBytes || this.totalBytes == -1L)) {
            DefaultProgressStatus status = new DefaultProgressStatus(this.newlyTransferredBytes, this.transferredBytes, this.totalBytes, now - this.lastCheckpoint, now - this.startCheckpoint);
            status.setInstantaneousSpeed(this.lastSecondBytes);
            this.progressListener.progressChanged(status);
            this.newlyTransferredBytes = 0L;
            this.lastCheckpoint = now;
        }
    }

    @Override
    public void progressEnd() {
        if (this.progressListener == null) {
            return;
        }
        long now = System.currentTimeMillis();
        DefaultProgressStatus status = new DefaultProgressStatus(this.newlyTransferredBytes, this.transferredBytes, this.totalBytes, now - this.lastCheckpoint, now - this.startCheckpoint);
        this.progressListener.progressChanged(status);
    }
}

