/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.vocabulary.EARL;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;

public class EarlReport {
    Model earl = ModelFactory.createDefaultModel();
    Resource system = null;
    Resource reporter = null;

    public EarlReport(String title, String version2, String homepage) {
        this.earl.setNsPrefix("earl", EARL.getURI());
        this.earl.setNsPrefix("foaf", FOAF.getURI());
        this.earl.setNsPrefix("rdf", RDF.getURI());
        this.earl.setNsPrefix("dc", DC.getURI());
        this.system = this.earl.createResource(EARL.Software);
        if (title != null) {
            this.system.addProperty(DC.title, title);
        }
        if (version2 != null) {
            this.system.addProperty(DCTerms.hasVersion, version2);
        }
        if (homepage != null) {
            this.system.addProperty(FOAF.homepage, (RDFNode)this.earl.createResource(homepage));
        }
        this.reporter = this.system;
    }

    public Resource getSystem() {
        return this.system;
    }

    public Resource getReporter() {
        return this.reporter;
    }

    public void setReporter(Resource reporter) {
        this.reporter = reporter;
    }

    public void success(String testURI) {
        this.createAssertionResult(testURI, EARL.pass);
    }

    public void failure(String testURI) {
        this.createAssertionResult(testURI, EARL.fail);
    }

    public void notApplicable(String testURI) {
        this.createAssertionResult(testURI, EARL.notApplicable);
    }

    public void notTested(String testURI) {
        this.createAssertionResult(testURI, EARL.notTested);
    }

    private void createAssertionResult(String testURI, Resource outcome) {
        Resource result = this.createResult(outcome);
        Resource assertion = this.createAssertion(testURI, result);
    }

    private Resource createAssertion(String testURI, Resource result) {
        Resource thisTest = this.earl.createResource(testURI);
        return this.earl.createResource(EARL.Assertion).addProperty(EARL.test, (RDFNode)thisTest).addProperty(EARL.result, (RDFNode)result).addProperty(EARL.subject, (RDFNode)this.system).addProperty(EARL.assertedBy, (RDFNode)this.system).addProperty(EARL.mode, (RDFNode)EARL.automatic);
    }

    private Resource createResult(Resource outcome) {
        String todayStr = Utils.todayAsXSDDateString();
        Literal now = ResourceFactory.createTypedLiteral((String)todayStr, (RDFDatatype)XSDDatatype.XSDdate);
        return this.earl.createResource(EARL.TestResult).addProperty(EARL.outcome, (RDFNode)outcome).addProperty(DC.date, (RDFNode)now);
    }

    public Model getModel() {
        return this.earl;
    }

    public Model getDescription() {
        return this.earl;
    }
}

