/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasFlag;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasLinkableGroup;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSLinkableGroup;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSAssertReport
implements IPSElement,
IPSHasFlag,
IPSHasForeignElements,
IPSHasMixedContent,
IPSHasID,
IPSHasRichGroup,
IPSHasLinkableGroup {
    private final boolean m_bIsAssert;
    private String m_sTest;
    private String m_sFlag;
    private String m_sID;
    private ICommonsList<String> m_aDiagnostics;
    private PSRichGroup m_aRich;
    private PSLinkableGroup m_aLinkable;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    public PSAssertReport(boolean bl) {
        this.m_bIsAssert = bl;
    }

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sTest)) {
            iPSErrorHandler.error(this, (this.m_bIsAssert ? "<assert>" : "<report>") + " has no 'test'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
        if (StringHelper.hasNoText((String)this.m_sTest)) {
            iPSErrorHandler.error(this, (this.m_bIsAssert ? "<assert>" : "<report>") + " has no 'test'");
        }
    }

    @Override
    public boolean isMinimal() {
        if (!this.m_bIsAssert) {
            return false;
        }
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(IMicroElement.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    public boolean isAssert() {
        return this.m_bIsAssert;
    }

    public boolean isReport() {
        return !this.m_bIsAssert;
    }

    public void setTest(@Nullable String string) {
        this.m_sTest = string;
    }

    @Nullable
    public String getTest() {
        return this.m_sTest;
    }

    public void setFlag(@Nullable String string) {
        this.m_sFlag = string;
    }

    @Override
    @Nullable
    public String getFlag() {
        return this.m_sFlag;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setDiagnostics(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.setDiagnostics((ICommonsList<String>)RegExHelper.getSplitToList((CharSequence)string.trim(), (String)"\\s+"));
        } else {
            this.m_aDiagnostics = null;
        }
    }

    public void setDiagnostics(@Nullable ICommonsList<String> iCommonsList) {
        this.m_aDiagnostics = iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllDiagnostics() {
        return new CommonsArrayList(this.m_aDiagnostics);
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void setLinkable(@Nullable PSLinkableGroup pSLinkableGroup) {
        this.m_aLinkable = pSLinkableGroup;
    }

    @Override
    @Nullable
    public PSLinkableGroup getLinkable() {
        return this.m_aLinkable;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add((Object)string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(String.class::isInstance);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    public void addName(@Nonnull PSName pSName) {
        ValueEnforcer.notNull((Object)pSName, (String)"Name");
        this.m_aContent.add((Object)pSName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSName> getAllNames() {
        return this.m_aContent.getAllInstanceOf(PSName.class);
    }

    public void addValueOf(@Nonnull PSValueOf pSValueOf) {
        ValueEnforcer.notNull((Object)pSValueOf, (String)"ValueOf");
        this.m_aContent.add((Object)pSValueOf);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSValueOf> getAllValueOfs() {
        return this.m_aContent.getAllInstanceOf(PSValueOf.class);
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        ValueEnforcer.notNull((Object)pSEmph, (String)"Emph");
        this.m_aContent.add((Object)pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSEmph> getAllEmphs() {
        return this.m_aContent.getAllInstanceOf(PSEmph.class);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add((Object)pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDir> getAllDirs() {
        return this.m_aContent.getAllInstanceOf(PSDir.class);
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        ValueEnforcer.notNull((Object)pSSpan, (String)"Span");
        this.m_aContent.add((Object)pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSSpan> getAllSpans() {
        return this.m_aContent.getAllInstanceOf(PSSpan.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", this.m_bIsAssert ? "assert" : "report");
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("flag", this.m_sFlag);
        microElement.setAttribute("test", this.m_sTest);
        if (CollectionHelper.isNotEmpty(this.m_aDiagnostics)) {
            microElement.setAttribute("diagnostics", StringHelper.getImploded((char)' ', this.m_aDiagnostics));
        }
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aLinkable != null) {
            this.m_aLinkable.fillMicroElement((IMicroElement)microElement);
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild((IMicroNode)((IMicroElement)object).getClone());
                continue;
            }
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("isAssert", this.m_bIsAssert).appendIfNotNull("test", (Object)this.m_sTest).appendIfNotNull("flag", (Object)this.m_sFlag).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("diagnostics", this.m_aDiagnostics).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotNull("linkable", (Object)this.m_aLinkable).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }

    @Nonnull
    public static PSAssertReport assertion() {
        return new PSAssertReport(true);
    }

    @Nonnull
    public static PSAssertReport report() {
        return new PSAssertReport(false);
    }
}

