/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.rule;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.ITypeConverterRule;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.typeconvert.rule.AbstractTypeConverterRule;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TypeConverterRuleFixedSourceAnyDestination<SRC>
extends AbstractTypeConverterRule<SRC, Object> {
    private final Class<SRC> m_aSrcClass;
    private final Function<? super SRC, ? extends Object> m_aInBetweenConverter;
    private Class<?> m_aEffectiveDstClass;

    public TypeConverterRuleFixedSourceAnyDestination(@Nonnull Class<SRC> clazz, @Nonnull Function<? super SRC, ? extends Object> function) {
        super(ITypeConverterRule.ESubType.FIXED_SRC_ANY_DST);
        this.m_aSrcClass = ValueEnforcer.notNull(clazz, "SrcClass");
        this.m_aInBetweenConverter = ValueEnforcer.notNull(function, "InBetweenConverter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        if (!this.m_aSrcClass.equals(clazz)) {
            return false;
        }
        this.m_aEffectiveDstClass = clazz2;
        return true;
    }

    @Nonnull
    protected Object getInBetweenValue(@Nonnull SRC SRC) {
        return this.m_aInBetweenConverter.apply(SRC);
    }

    @Override
    public final Object apply(@Nonnull SRC SRC) {
        Object object = this.getInBetweenValue(SRC);
        return TypeConverter.convert(object, this.m_aEffectiveDstClass);
    }

    @Nonnull
    public final Class<?> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("SrcClass", this.m_aSrcClass).append("InBetweenConverter", this.m_aInBetweenConverter).getToString();
    }
}

