/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.system.SystemProperties;
import javax.annotation.Nonnull;

public enum EJVMVendor {
    SUN_CLIENT{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bl = EJVMVendor.SUN_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bl && !EJVMVendor._isSunOrOracleServerJVM();
        }
    }
    ,
    SUN_SERVER{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bl = EJVMVendor.SUN_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bl && EJVMVendor._isSunOrOracleServerJVM();
        }
    }
    ,
    ORACLE_CLIENT{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bl = EJVMVendor.ORACLE_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bl && !EJVMVendor._isSunOrOracleServerJVM();
        }
    }
    ,
    ORACLE_SERVER{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bl = EJVMVendor.ORACLE_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bl && EJVMVendor._isSunOrOracleServerJVM();
        }
    }
    ,
    UNKNOWN{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            return false;
        }
    };

    private static final String SUN_VENDOR_NAME = "Sun Microsystems Inc.";
    private static final String ORACLE_VENDOR_NAME = "Oracle Corporation";
    private static final EJVMVendor INSTANCE;
    private final boolean m_bIsIt = this.determineIfItIsCurrentJVMVendor();

    private static boolean _isSunOrOracleServerJVM() {
        String string = SystemProperties.getJavaVmName();
        if ("Java HotSpot(TM) Server VM".equals(string)) {
            return true;
        }
        return "Java HotSpot(TM) 64-Bit Server VM".equals(string);
    }

    protected abstract boolean determineIfItIsCurrentJVMVendor();

    public final boolean isJVMVendor() {
        return this.m_bIsIt;
    }

    public final boolean isSun() {
        return this == SUN_CLIENT || this == SUN_SERVER;
    }

    public final boolean isOracle() {
        return this == ORACLE_CLIENT || this == ORACLE_SERVER;
    }

    @Nonnull
    public static EJVMVendor getCurrentVendor() {
        return INSTANCE;
    }

    static {
        EJVMVendor eJVMVendor = UNKNOWN;
        for (EJVMVendor eJVMVendor2 : EJVMVendor.values()) {
            if (!eJVMVendor2.isJVMVendor()) continue;
            eJVMVendor = eJVMVendor2;
            break;
        }
        INSTANCE = eJVMVendor;
    }
}

