/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.map.MapEntry;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsMap<KEYTYPE, VALUETYPE>
extends Map<KEYTYPE, VALUETYPE>,
ICloneable<ICommonsMap<KEYTYPE, VALUETYPE>> {
    @Nonnull
    @ReturnsMutableCopy
    default public <K, V> ICommonsMap<K, V> createInstance() {
        return new CommonsHashMap();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<KEYTYPE> copyOfKeySet() {
        return new CommonsHashSet(this.keySet());
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        return CollectionHelper.newSet(this.keySet(), predicate);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<VALUETYPE> copyOfValues() {
        return new CommonsArrayList(this.values());
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<VALUETYPE> copyOfValues(@Nullable Predicate<? super VALUETYPE> predicate) {
        if (predicate == null) {
            return this.copyOfValues();
        }
        return CollectionHelper.newList(this.values(), predicate);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> copyOfValuesMapped(@Nonnull Function<? super VALUETYPE, ? extends DSTTYPE> function) {
        return CollectionHelper.newListMapped(this.values(), function);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> copyOfValuesMapped(@Nullable Predicate<? super VALUETYPE> predicate, @Nonnull Function<? super VALUETYPE, ? extends DSTTYPE> function) {
        if (predicate == null) {
            return this.copyOfValuesMapped(function);
        }
        return CollectionHelper.newListMapped(this.values(), predicate, function);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        CommonsHashSet<int> commonsHashSet = new CommonsHashSet<int>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            commonsHashSet.add(new MapEntry(entry));
        }
        return commonsHashSet;
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nullable
    default public Map.Entry<KEYTYPE, VALUETYPE> getFirstEntry() {
        return this.getFirstEntry(null);
    }

    @Nullable
    default public Map.Entry<KEYTYPE, VALUETYPE> getFirstEntry(@Nullable Map.Entry<KEYTYPE, VALUETYPE> entry) {
        return this.isEmpty() ? entry : this.entrySet().iterator().next();
    }

    @Nullable
    default public KEYTYPE getFirstKey() {
        return this.getFirstKey(null);
    }

    @Nullable
    default public KEYTYPE getFirstKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : this.keySet().iterator().next());
    }

    @Nullable
    default public VALUETYPE getFirstValue() {
        return this.getFirstValue(null);
    }

    @Nullable
    default public VALUETYPE getFirstValue(@Nullable VALUETYPE VALUETYPE) {
        return (VALUETYPE)(this.isEmpty() ? VALUETYPE : this.values().iterator().next());
    }

    @Nullable
    default public Map.Entry<KEYTYPE, VALUETYPE> findFirstEntry(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        return CollectionHelper.findFirst(this.entrySet(), predicate);
    }

    @Nullable
    default public KEYTYPE findFirstKey(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        Map.Entry<KEYTYPE, VALUETYPE> entry = this.findFirstEntry(predicate);
        return entry == null ? null : (KEYTYPE)entry.getKey();
    }

    @Nullable
    default public VALUETYPE findFirstValue(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        Map.Entry<KEYTYPE, VALUETYPE> entry = this.findFirstEntry(predicate);
        return entry == null ? null : (VALUETYPE)entry.getValue();
    }

    default public boolean containsAnyEntry(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        return CollectionHelper.containsAny(this.entrySet(), predicate);
    }

    default public boolean containsAnyKey(@Nullable Predicate<? super KEYTYPE> predicate) {
        return CollectionHelper.containsAny(this.keySet(), predicate);
    }

    default public boolean containsAnyValue(@Nullable Predicate<? super VALUETYPE> predicate) {
        return CollectionHelper.containsAny(this.values(), predicate);
    }

    default public void forEachKey(@Nonnull Consumer<? super KEYTYPE> consumer) {
        this.forEach((object, object2) -> consumer.accept((Object)object));
    }

    default public void forEachValue(@Nonnull Consumer<? super VALUETYPE> consumer) {
        this.forEach((object, object2) -> consumer.accept((Object)object2));
    }

    default public void forEach(@Nullable BiPredicate<? super KEYTYPE, ? super VALUETYPE> biPredicate, @Nonnull BiConsumer<? super KEYTYPE, ? super VALUETYPE> biConsumer) {
        if (biPredicate == null) {
            this.forEach(biConsumer);
        } else {
            this.forEach((object, object2) -> {
                if (biPredicate.test((Object)object, (Object)object2)) {
                    biConsumer.accept((Object)object, (Object)object2);
                }
            });
        }
    }

    default public void forEachKey(@Nullable Predicate<? super KEYTYPE> predicate, @Nonnull Consumer<? super KEYTYPE> consumer) {
        if (predicate == null) {
            this.forEachKey(consumer);
        } else {
            this.forEach((object, object2) -> predicate.test((Object)object), (object, object2) -> consumer.accept((Object)object));
        }
    }

    default public void forEachValue(@Nullable Predicate<? super VALUETYPE> predicate, @Nonnull Consumer<? super VALUETYPE> consumer) {
        if (predicate == null) {
            this.forEachValue(consumer);
        } else {
            this.forEach((object, object2) -> predicate.test((Object)object2), (object, object2) -> consumer.accept((Object)object2));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nonnull Comparator<? super KEYTYPE> comparator) {
        return CollectionHelper.getSortedByKey(this, comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nonnull Comparator<? super VALUETYPE> comparator) {
        return CollectionHelper.getSortedByValue(this, comparator);
    }

    @Nullable
    @ReturnsMutableCopy
    default public ICommonsMap<VALUETYPE, KEYTYPE> getSwappedKeyValues() {
        ICommonsMap iCommonsMap = this.createInstance();
        for (Map.Entry entry : this.entrySet()) {
            iCommonsMap.put(entry.getValue(), entry.getKey());
        }
        return iCommonsMap;
    }

    @Nullable
    default public VALUETYPE put(@Nonnull Map.Entry<? extends KEYTYPE, ? extends VALUETYPE> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    default public void putIf(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE, @Nonnull Predicate<? super VALUETYPE> predicate) {
        ValueEnforcer.notNull(predicate, "Filter");
        if (predicate.test(VALUETYPE)) {
            this.put(KEYTYPE, VALUETYPE);
        }
    }

    default public void putIfNotNull(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        if (VALUETYPE != null) {
            this.put(KEYTYPE, VALUETYPE);
        }
    }

    default public void putAll(@Nullable Iterable<? extends Map.Entry<KEYTYPE, VALUETYPE>> iterable) {
        if (iterable != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : iterable) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    default public void putAll(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nullable Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        if (map != null) {
            if (predicate == null) {
                this.putAll(map);
            } else {
                for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                    if (!predicate.test(entry)) continue;
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    default public <ELEMENTTYPE> void putAllMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, ? extends KEYTYPE> function, @Nonnull Function<? super ELEMENTTYPE, ? extends VALUETYPE> function2) {
        ValueEnforcer.notNull(function, "KeyMapper");
        ValueEnforcer.notNull(function2, "ValueMapper");
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                this.put(function.apply(ELEMENTTYPE), function2.apply(ELEMENTTYPE));
            }
        }
    }

    default public <ELEMENTTYPE> void putAllMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, ? extends KEYTYPE> function, @Nonnull Function<? super ELEMENTTYPE, ? extends VALUETYPE> function2) {
        ValueEnforcer.notNull(function, "KeyMapper");
        ValueEnforcer.notNull(function2, "ValueMapper");
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                this.put(function.apply(ELEMENTTYPE), function2.apply(ELEMENTTYPE));
            }
        }
    }

    default public <SRCKEYTYPE, SRCVALUETYPE> void putAllMapped(@Nullable Map<? extends SRCKEYTYPE, ? extends SRCVALUETYPE> map, @Nonnull Function<? super SRCKEYTYPE, ? extends KEYTYPE> function, @Nonnull Function<? super SRCVALUETYPE, ? extends VALUETYPE> function2) {
        ValueEnforcer.notNull(function, "KeyMapper");
        ValueEnforcer.notNull(function2, "ValueMapper");
        if (map != null) {
            for (Map.Entry<SRCKEYTYPE, SRCVALUETYPE> entry : map.entrySet()) {
                this.put(function.apply(entry.getKey()), function2.apply(entry.getValue()));
            }
        }
    }

    default public void addAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    @Nonnull
    default public EChange setAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = this.removeAll();
        if (map != null) {
            this.putAll(map);
            if (this.isNotEmpty()) {
                eChange = EChange.CHANGED;
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange removeAll() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    default public EChange removeObject(@Nullable KEYTYPE KEYTYPE) {
        return EChange.valueOf(this.remove(KEYTYPE) != null);
    }

    @Nonnull
    default public EChange removeIf(@Nonnull Predicate<? super Map.Entry<? extends KEYTYPE, ? extends VALUETYPE>> predicate) {
        ValueEnforcer.notNull(predicate, "Filter");
        EChange eChange = EChange.UNCHANGED;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    default public EChange removeIfKey(@Nonnull Predicate<? super KEYTYPE> predicate) {
        return this.removeIf(entry -> predicate.test((Object)entry.getKey()));
    }

    @Nonnull
    default public EChange removeIfValue(@Nonnull Predicate<? super VALUETYPE> predicate) {
        return this.removeIf(entry -> predicate.test((Object)entry.getValue()));
    }

    @Nonnull
    @CodingStyleguideUnaware
    default public Map<KEYTYPE, VALUETYPE> getAsUnmodifiable() {
        return Collections.unmodifiableMap(this);
    }
}

