/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(prefix="graphql.servlet.async")
public class AsyncServletProperties {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private boolean enabled = false;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration timeout = DEFAULT_TIMEOUT;
    private boolean delegateSecurityContext = true;
    private Threads threads = new Threads();

    @Generated
    public AsyncServletProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isDelegateSecurityContext() {
        return this.delegateSecurityContext;
    }

    @Generated
    public Threads getThreads() {
        return this.threads;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setDelegateSecurityContext(boolean delegateSecurityContext) {
        this.delegateSecurityContext = delegateSecurityContext;
    }

    @Generated
    public void setThreads(Threads threads) {
        this.threads = threads;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncServletProperties)) {
            return false;
        }
        AsyncServletProperties other = (AsyncServletProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isDelegateSecurityContext() != other.isDelegateSecurityContext()) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Threads this$threads = this.getThreads();
        Threads other$threads = other.getThreads();
        return !(this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncServletProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isDelegateSecurityContext() ? 79 : 97);
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Threads $threads = this.getThreads();
        result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AsyncServletProperties(enabled=" + this.isEnabled() + ", timeout=" + this.getTimeout() + ", delegateSecurityContext=" + this.isDelegateSecurityContext() + ", threads=" + this.getThreads() + ")";
    }

    public static class Threads {
        private int min = 10;
        private int max = 200;
        private String namePrefix = "graphql-exec-";

        @Generated
        public Threads() {
        }

        @Generated
        public int getMin() {
            return this.min;
        }

        @Generated
        public int getMax() {
            return this.max;
        }

        @Generated
        public String getNamePrefix() {
            return this.namePrefix;
        }

        @Generated
        public void setMin(int min) {
            this.min = min;
        }

        @Generated
        public void setMax(int max) {
            this.max = max;
        }

        @Generated
        public void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Threads)) {
                return false;
            }
            Threads other = (Threads)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMin() != other.getMin()) {
                return false;
            }
            if (this.getMax() != other.getMax()) {
                return false;
            }
            String this$namePrefix = this.getNamePrefix();
            String other$namePrefix = other.getNamePrefix();
            return !(this$namePrefix == null ? other$namePrefix != null : !this$namePrefix.equals(other$namePrefix));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Threads;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMin();
            result = result * 59 + this.getMax();
            String $namePrefix = this.getNamePrefix();
            result = result * 59 + ($namePrefix == null ? 43 : $namePrefix.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncServletProperties.Threads(min=" + this.getMin() + ", max=" + this.getMax() + ", namePrefix=" + this.getNamePrefix() + ")";
        }
    }
}

