/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.util;

/**
 * This class represents a sorted list of disjoint, closed intervals.  When an<br>
 * interval is inserted, all intervals that overlap it or are adjacent to it are<br>
 * merged into one. I.e. [0,14] and [15,30] will be merged to [0,30].<br>
 * <br>
 * Iterators returned by this class are invalidated by non-const operations.
 */
public class SortedDisjointIntervalList {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public SortedDisjointIntervalList(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SortedDisjointIntervalList obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_SortedDisjointIntervalList(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public SortedDisjointIntervalList() {
    this(mainJNI.new_SortedDisjointIntervalList__SWIG_0(), true);
  }

  /**
   * Creates a SortedDisjointIntervalList and fills it with intervals<br>
   * [starts[i]..ends[i]]. All intervals must be consistent (starts[i] &lt;=<br>
   * ends[i]). There are two version, one for int64_t and one for int.
   */
  public SortedDisjointIntervalList(long[] starts, long[] ends) {
    this(mainJNI.new_SortedDisjointIntervalList__SWIG_1(starts, ends), true);
  }

  public SortedDisjointIntervalList(int[] starts, int[] ends) {
    this(mainJNI.new_SortedDisjointIntervalList__SWIG_2(starts, ends), true);
  }

  /**
   * Builds the complement of the interval list on the interval [start, end].
   */
  public SortedDisjointIntervalList buildComplementOnInterval(long start, long end) {
    return new SortedDisjointIntervalList(mainJNI.SortedDisjointIntervalList_buildComplementOnInterval(swigCPtr, this, start, end), true);
  }

  /**
   * Adds the interval [start..end] to the list, and merges overlapping or<br>
   * immediately adjacent intervals ([2, 5] and [6, 7] are adjacent, but<br>
   * [2, 5] and [7, 8] are not).<br>
   * <br>
   * Returns an iterator to the inserted interval (possibly merged with others).<br>
   * <br>
   * If start &gt; end, it does LOG(DFATAL) and returns end() (no interval added).
   */
  public SWIGTYPE_p_std__setT_operations_research__ClosedInterval_operations_research__SortedDisjointIntervalList__IntervalComparator_t__iterator insertInterval(long start, long end) {
    return new SWIGTYPE_p_std__setT_operations_research__ClosedInterval_operations_research__SortedDisjointIntervalList__IntervalComparator_t__iterator(mainJNI.SortedDisjointIntervalList_insertInterval(swigCPtr, this, start, end), true);
  }

  /**
   * Adds all intervals [starts[i]..ends[i]].<br>
   * <br>
   * Same behavior as InsertInterval() upon invalid intervals. There's a version<br>
   * with int64_t and int32_t.
   */
  public void insertIntervals(long[] starts, long[] ends) {
    mainJNI.SortedDisjointIntervalList_insertIntervals__SWIG_0(swigCPtr, this, starts, ends);
  }

  public void insertIntervals(int[] starts, int[] ends) {
    mainJNI.SortedDisjointIntervalList_insertIntervals__SWIG_1(swigCPtr, this, starts, ends);
  }

  /**
   * Returns the number of disjoint intervals in the list.
   */
  public int numIntervals() {
    return mainJNI.SortedDisjointIntervalList_numIntervals(swigCPtr, this);
  }

  public String toString() {
    return mainJNI.SortedDisjointIntervalList_toString(swigCPtr, this);
  }

}
