// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/cp_model.proto

package com.google.ortools.sat;

/**
 * <pre>
 * Maintain a reservoir level within bounds. The water level starts at 0, and at
 * any time, it must be within [min_level, max_level].
 * If the variable actives[i] is true, and if the variable times[i] is assigned
 * a value t, then the current level changes by demands[i] (which is constant)
 * at the time t. Therefore, at any time t:
 *      sum(demands[i] * actives[i] if times[i] &lt;= t) in [min_level, max_level]
 * Note that min level must be &lt;= 0, and the max level must be &gt;= 0. Please use
 * fixed demands to simulate initial state.
 * The array of boolean variables 'actives', if defined, indicates which actions
 * are actually performed. If this array is not defined, then it is assumed that
 * all actions will be performed.
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.ReservoirConstraintProto}
 */
public final class ReservoirConstraintProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.ReservoirConstraintProto)
    ReservoirConstraintProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ReservoirConstraintProto.newBuilder() to construct.
  private ReservoirConstraintProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ReservoirConstraintProto() {
    times_ = emptyIntList();
    demands_ = emptyLongList();
    actives_ = emptyIntList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ReservoirConstraintProto();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ReservoirConstraintProto(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {

            minLevel_ = input.readInt64();
            break;
          }
          case 16: {

            maxLevel_ = input.readInt64();
            break;
          }
          case 24: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              times_ = newIntList();
              mutable_bitField0_ |= 0x00000001;
            }
            times_.addInt(input.readInt32());
            break;
          }
          case 26: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
              times_ = newIntList();
              mutable_bitField0_ |= 0x00000001;
            }
            while (input.getBytesUntilLimit() > 0) {
              times_.addInt(input.readInt32());
            }
            input.popLimit(limit);
            break;
          }
          case 32: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              demands_ = newLongList();
              mutable_bitField0_ |= 0x00000002;
            }
            demands_.addLong(input.readInt64());
            break;
          }
          case 34: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000002) != 0) && input.getBytesUntilLimit() > 0) {
              demands_ = newLongList();
              mutable_bitField0_ |= 0x00000002;
            }
            while (input.getBytesUntilLimit() > 0) {
              demands_.addLong(input.readInt64());
            }
            input.popLimit(limit);
            break;
          }
          case 40: {
            if (!((mutable_bitField0_ & 0x00000004) != 0)) {
              actives_ = newIntList();
              mutable_bitField0_ |= 0x00000004;
            }
            actives_.addInt(input.readInt32());
            break;
          }
          case 42: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000004) != 0) && input.getBytesUntilLimit() > 0) {
              actives_ = newIntList();
              mutable_bitField0_ |= 0x00000004;
            }
            while (input.getBytesUntilLimit() > 0) {
              actives_.addInt(input.readInt32());
            }
            input.popLimit(limit);
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        times_.makeImmutable(); // C
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        demands_.makeImmutable(); // C
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        actives_.makeImmutable(); // C
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_ReservoirConstraintProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_ReservoirConstraintProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.ReservoirConstraintProto.class, com.google.ortools.sat.ReservoirConstraintProto.Builder.class);
  }

  public static final int MIN_LEVEL_FIELD_NUMBER = 1;
  private long minLevel_;
  /**
   * <code>int64 min_level = 1;</code>
   * @return The minLevel.
   */
  @java.lang.Override
  public long getMinLevel() {
    return minLevel_;
  }

  public static final int MAX_LEVEL_FIELD_NUMBER = 2;
  private long maxLevel_;
  /**
   * <code>int64 max_level = 2;</code>
   * @return The maxLevel.
   */
  @java.lang.Override
  public long getMaxLevel() {
    return maxLevel_;
  }

  public static final int TIMES_FIELD_NUMBER = 3;
  private com.google.protobuf.Internal.IntList times_;
  /**
   * <pre>
   * variables.
   * </pre>
   *
   * <code>repeated int32 times = 3;</code>
   * @return A list containing the times.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getTimesList() {
    return times_;
  }
  /**
   * <pre>
   * variables.
   * </pre>
   *
   * <code>repeated int32 times = 3;</code>
   * @return The count of times.
   */
  public int getTimesCount() {
    return times_.size();
  }
  /**
   * <pre>
   * variables.
   * </pre>
   *
   * <code>repeated int32 times = 3;</code>
   * @param index The index of the element to return.
   * @return The times at the given index.
   */
  public int getTimes(int index) {
    return times_.getInt(index);
  }
  private int timesMemoizedSerializedSize = -1;

  public static final int DEMANDS_FIELD_NUMBER = 4;
  private com.google.protobuf.Internal.LongList demands_;
  /**
   * <pre>
   * constants, can be negative.
   * </pre>
   *
   * <code>repeated int64 demands = 4;</code>
   * @return A list containing the demands.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long>
      getDemandsList() {
    return demands_;
  }
  /**
   * <pre>
   * constants, can be negative.
   * </pre>
   *
   * <code>repeated int64 demands = 4;</code>
   * @return The count of demands.
   */
  public int getDemandsCount() {
    return demands_.size();
  }
  /**
   * <pre>
   * constants, can be negative.
   * </pre>
   *
   * <code>repeated int64 demands = 4;</code>
   * @param index The index of the element to return.
   * @return The demands at the given index.
   */
  public long getDemands(int index) {
    return demands_.getLong(index);
  }
  private int demandsMemoizedSerializedSize = -1;

  public static final int ACTIVES_FIELD_NUMBER = 5;
  private com.google.protobuf.Internal.IntList actives_;
  /**
   * <pre>
   * literals.
   * </pre>
   *
   * <code>repeated int32 actives = 5;</code>
   * @return A list containing the actives.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getActivesList() {
    return actives_;
  }
  /**
   * <pre>
   * literals.
   * </pre>
   *
   * <code>repeated int32 actives = 5;</code>
   * @return The count of actives.
   */
  public int getActivesCount() {
    return actives_.size();
  }
  /**
   * <pre>
   * literals.
   * </pre>
   *
   * <code>repeated int32 actives = 5;</code>
   * @param index The index of the element to return.
   * @return The actives at the given index.
   */
  public int getActives(int index) {
    return actives_.getInt(index);
  }
  private int activesMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (minLevel_ != 0L) {
      output.writeInt64(1, minLevel_);
    }
    if (maxLevel_ != 0L) {
      output.writeInt64(2, maxLevel_);
    }
    if (getTimesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(timesMemoizedSerializedSize);
    }
    for (int i = 0; i < times_.size(); i++) {
      output.writeInt32NoTag(times_.getInt(i));
    }
    if (getDemandsList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(demandsMemoizedSerializedSize);
    }
    for (int i = 0; i < demands_.size(); i++) {
      output.writeInt64NoTag(demands_.getLong(i));
    }
    if (getActivesList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(activesMemoizedSerializedSize);
    }
    for (int i = 0; i < actives_.size(); i++) {
      output.writeInt32NoTag(actives_.getInt(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (minLevel_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(1, minLevel_);
    }
    if (maxLevel_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, maxLevel_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < times_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(times_.getInt(i));
      }
      size += dataSize;
      if (!getTimesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      timesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < demands_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt64SizeNoTag(demands_.getLong(i));
      }
      size += dataSize;
      if (!getDemandsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      demandsMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < actives_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(actives_.getInt(i));
      }
      size += dataSize;
      if (!getActivesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      activesMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.ReservoirConstraintProto)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.ReservoirConstraintProto other = (com.google.ortools.sat.ReservoirConstraintProto) obj;

    if (getMinLevel()
        != other.getMinLevel()) return false;
    if (getMaxLevel()
        != other.getMaxLevel()) return false;
    if (!getTimesList()
        .equals(other.getTimesList())) return false;
    if (!getDemandsList()
        .equals(other.getDemandsList())) return false;
    if (!getActivesList()
        .equals(other.getActivesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MIN_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getMinLevel());
    hash = (37 * hash) + MAX_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getMaxLevel());
    if (getTimesCount() > 0) {
      hash = (37 * hash) + TIMES_FIELD_NUMBER;
      hash = (53 * hash) + getTimesList().hashCode();
    }
    if (getDemandsCount() > 0) {
      hash = (37 * hash) + DEMANDS_FIELD_NUMBER;
      hash = (53 * hash) + getDemandsList().hashCode();
    }
    if (getActivesCount() > 0) {
      hash = (37 * hash) + ACTIVES_FIELD_NUMBER;
      hash = (53 * hash) + getActivesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.ReservoirConstraintProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.ReservoirConstraintProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Maintain a reservoir level within bounds. The water level starts at 0, and at
   * any time, it must be within [min_level, max_level].
   * If the variable actives[i] is true, and if the variable times[i] is assigned
   * a value t, then the current level changes by demands[i] (which is constant)
   * at the time t. Therefore, at any time t:
   *      sum(demands[i] * actives[i] if times[i] &lt;= t) in [min_level, max_level]
   * Note that min level must be &lt;= 0, and the max level must be &gt;= 0. Please use
   * fixed demands to simulate initial state.
   * The array of boolean variables 'actives', if defined, indicates which actions
   * are actually performed. If this array is not defined, then it is assumed that
   * all actions will be performed.
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.ReservoirConstraintProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.ReservoirConstraintProto)
      com.google.ortools.sat.ReservoirConstraintProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_ReservoirConstraintProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_ReservoirConstraintProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.ReservoirConstraintProto.class, com.google.ortools.sat.ReservoirConstraintProto.Builder.class);
    }

    // Construct using com.google.ortools.sat.ReservoirConstraintProto.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      minLevel_ = 0L;

      maxLevel_ = 0L;

      times_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      demands_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      actives_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_ReservoirConstraintProto_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.ReservoirConstraintProto getDefaultInstanceForType() {
      return com.google.ortools.sat.ReservoirConstraintProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.ReservoirConstraintProto build() {
      com.google.ortools.sat.ReservoirConstraintProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.ReservoirConstraintProto buildPartial() {
      com.google.ortools.sat.ReservoirConstraintProto result = new com.google.ortools.sat.ReservoirConstraintProto(this);
      int from_bitField0_ = bitField0_;
      result.minLevel_ = minLevel_;
      result.maxLevel_ = maxLevel_;
      if (((bitField0_ & 0x00000001) != 0)) {
        times_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.times_ = times_;
      if (((bitField0_ & 0x00000002) != 0)) {
        demands_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.demands_ = demands_;
      if (((bitField0_ & 0x00000004) != 0)) {
        actives_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.actives_ = actives_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.ReservoirConstraintProto) {
        return mergeFrom((com.google.ortools.sat.ReservoirConstraintProto)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.ReservoirConstraintProto other) {
      if (other == com.google.ortools.sat.ReservoirConstraintProto.getDefaultInstance()) return this;
      if (other.getMinLevel() != 0L) {
        setMinLevel(other.getMinLevel());
      }
      if (other.getMaxLevel() != 0L) {
        setMaxLevel(other.getMaxLevel());
      }
      if (!other.times_.isEmpty()) {
        if (times_.isEmpty()) {
          times_ = other.times_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureTimesIsMutable();
          times_.addAll(other.times_);
        }
        onChanged();
      }
      if (!other.demands_.isEmpty()) {
        if (demands_.isEmpty()) {
          demands_ = other.demands_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureDemandsIsMutable();
          demands_.addAll(other.demands_);
        }
        onChanged();
      }
      if (!other.actives_.isEmpty()) {
        if (actives_.isEmpty()) {
          actives_ = other.actives_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureActivesIsMutable();
          actives_.addAll(other.actives_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ortools.sat.ReservoirConstraintProto parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ortools.sat.ReservoirConstraintProto) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private long minLevel_ ;
    /**
     * <code>int64 min_level = 1;</code>
     * @return The minLevel.
     */
    @java.lang.Override
    public long getMinLevel() {
      return minLevel_;
    }
    /**
     * <code>int64 min_level = 1;</code>
     * @param value The minLevel to set.
     * @return This builder for chaining.
     */
    public Builder setMinLevel(long value) {
      
      minLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>int64 min_level = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearMinLevel() {
      
      minLevel_ = 0L;
      onChanged();
      return this;
    }

    private long maxLevel_ ;
    /**
     * <code>int64 max_level = 2;</code>
     * @return The maxLevel.
     */
    @java.lang.Override
    public long getMaxLevel() {
      return maxLevel_;
    }
    /**
     * <code>int64 max_level = 2;</code>
     * @param value The maxLevel to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLevel(long value) {
      
      maxLevel_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>int64 max_level = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearMaxLevel() {
      
      maxLevel_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList times_ = emptyIntList();
    private void ensureTimesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        times_ = mutableCopy(times_);
        bitField0_ |= 0x00000001;
       }
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @return A list containing the times.
     */
    public java.util.List<java.lang.Integer>
        getTimesList() {
      return ((bitField0_ & 0x00000001) != 0) ?
               java.util.Collections.unmodifiableList(times_) : times_;
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @return The count of times.
     */
    public int getTimesCount() {
      return times_.size();
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @param index The index of the element to return.
     * @return The times at the given index.
     */
    public int getTimes(int index) {
      return times_.getInt(index);
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @param index The index to set the value at.
     * @param value The times to set.
     * @return This builder for chaining.
     */
    public Builder setTimes(
        int index, int value) {
      ensureTimesIsMutable();
      times_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @param value The times to add.
     * @return This builder for chaining.
     */
    public Builder addTimes(int value) {
      ensureTimesIsMutable();
      times_.addInt(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @param values The times to add.
     * @return This builder for chaining.
     */
    public Builder addAllTimes(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureTimesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, times_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * variables.
     * </pre>
     *
     * <code>repeated int32 times = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearTimes() {
      times_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList demands_ = emptyLongList();
    private void ensureDemandsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        demands_ = mutableCopy(demands_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @return A list containing the demands.
     */
    public java.util.List<java.lang.Long>
        getDemandsList() {
      return ((bitField0_ & 0x00000002) != 0) ?
               java.util.Collections.unmodifiableList(demands_) : demands_;
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @return The count of demands.
     */
    public int getDemandsCount() {
      return demands_.size();
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @param index The index of the element to return.
     * @return The demands at the given index.
     */
    public long getDemands(int index) {
      return demands_.getLong(index);
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @param index The index to set the value at.
     * @param value The demands to set.
     * @return This builder for chaining.
     */
    public Builder setDemands(
        int index, long value) {
      ensureDemandsIsMutable();
      demands_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @param value The demands to add.
     * @return This builder for chaining.
     */
    public Builder addDemands(long value) {
      ensureDemandsIsMutable();
      demands_.addLong(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @param values The demands to add.
     * @return This builder for chaining.
     */
    public Builder addAllDemands(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureDemandsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, demands_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * constants, can be negative.
     * </pre>
     *
     * <code>repeated int64 demands = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearDemands() {
      demands_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList actives_ = emptyIntList();
    private void ensureActivesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        actives_ = mutableCopy(actives_);
        bitField0_ |= 0x00000004;
       }
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @return A list containing the actives.
     */
    public java.util.List<java.lang.Integer>
        getActivesList() {
      return ((bitField0_ & 0x00000004) != 0) ?
               java.util.Collections.unmodifiableList(actives_) : actives_;
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @return The count of actives.
     */
    public int getActivesCount() {
      return actives_.size();
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @param index The index of the element to return.
     * @return The actives at the given index.
     */
    public int getActives(int index) {
      return actives_.getInt(index);
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @param index The index to set the value at.
     * @param value The actives to set.
     * @return This builder for chaining.
     */
    public Builder setActives(
        int index, int value) {
      ensureActivesIsMutable();
      actives_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @param value The actives to add.
     * @return This builder for chaining.
     */
    public Builder addActives(int value) {
      ensureActivesIsMutable();
      actives_.addInt(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @param values The actives to add.
     * @return This builder for chaining.
     */
    public Builder addAllActives(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureActivesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, actives_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * literals.
     * </pre>
     *
     * <code>repeated int32 actives = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearActives() {
      actives_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.sat.ReservoirConstraintProto)
  }

  // @@protoc_insertion_point(class_scope:operations_research.sat.ReservoirConstraintProto)
  private static final com.google.ortools.sat.ReservoirConstraintProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.sat.ReservoirConstraintProto();
  }

  public static com.google.ortools.sat.ReservoirConstraintProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReservoirConstraintProto>
      PARSER = new com.google.protobuf.AbstractParser<ReservoirConstraintProto>() {
    @java.lang.Override
    public ReservoirConstraintProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ReservoirConstraintProto(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ReservoirConstraintProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReservoirConstraintProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.sat.ReservoirConstraintProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

