// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/linear_solver/linear_solver.proto

package com.google.ortools.linearsolver;

/**
 * <pre>
 * Status returned by the solver. They follow a hierarchical nomenclature, to
 * allow us to add more enum values in the future. Clients should use
 * InCategory() to match these enums, with the following C++ pseudo-code:
 * bool InCategory(MPSolverResponseStatus status, MPSolverResponseStatus cat) {
 *   if (cat == MPSOLVER_OPTIMAL) return status == MPSOLVER_OPTIMAL;
 *   while (status &gt; cat) status &gt;&gt;= 4;
 *   return status == cat;
 * }
 * </pre>
 *
 * Protobuf enum {@code operations_research.MPSolverResponseStatus}
 */
public enum MPSolverResponseStatus
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * The solver found the proven optimal solution. This is what should be
   * returned in most cases.
   * WARNING: for historical reason, the value is zero, which means that this
   * value can't have any subcategories.
   * </pre>
   *
   * <code>MPSOLVER_OPTIMAL = 0;</code>
   */
  MPSOLVER_OPTIMAL(0),
  /**
   * <pre>
   * The solver had enough time to find some solution that satisfies all
   * constraints, but it did not prove optimality (which means it may or may
   * not have reached the optimal).
   * This can happen for large LP models (Linear Programming), and is a frequent
   * response for time-limited MIPs (Mixed Integer Programming). In the MIP
   * case, the difference between the solution 'objective_value' and
   * 'best_objective_bound' fields of the MPSolutionResponse will give an
   * indication of how far this solution is from the optimal one.
   * </pre>
   *
   * <code>MPSOLVER_FEASIBLE = 1;</code>
   */
  MPSOLVER_FEASIBLE(1),
  /**
   * <pre>
   * The model does not have any solution, according to the solver (which
   * "proved" it, with the caveat that numerical proofs aren't actual proofs),
   * or based on trivial considerations (eg. a variable whose lower bound is
   * strictly greater than its upper bound).
   * </pre>
   *
   * <code>MPSOLVER_INFEASIBLE = 2;</code>
   */
  MPSOLVER_INFEASIBLE(2),
  /**
   * <pre>
   * There exist solutions that make the magnitude of the objective value
   * as large as wanted (i.e. -infinity (resp. +infinity) for a minimization
   * (resp. maximization) problem.
   * </pre>
   *
   * <code>MPSOLVER_UNBOUNDED = 3;</code>
   */
  MPSOLVER_UNBOUNDED(3),
  /**
   * <pre>
   * An error (most probably numerical) occurred.
   * One likely cause for such errors is a large numerical range among variable
   * coefficients (eg. 1e-16, 1e20), in which case one should try to shrink it.
   * </pre>
   *
   * <code>MPSOLVER_ABNORMAL = 4;</code>
   */
  MPSOLVER_ABNORMAL(4),
  /**
   * <pre>
   * The solver did not have a chance to diagnose the model in one of the
   * categories above.
   * </pre>
   *
   * <code>MPSOLVER_NOT_SOLVED = 6;</code>
   */
  MPSOLVER_NOT_SOLVED(6),
  /**
   * <pre>
   * Like "NOT_SOLVED", but typically used by model validation functions
   * returning a "model status", to enhance readability of the client code.
   * </pre>
   *
   * <code>MPSOLVER_MODEL_IS_VALID = 97;</code>
   */
  MPSOLVER_MODEL_IS_VALID(97),
  /**
   * <pre>
   * The solve was interrupted by the user, and the solver didn't have time to
   * return a proper status.
   * </pre>
   *
   * <code>MPSOLVER_CANCELLED_BY_USER = 98;</code>
   */
  MPSOLVER_CANCELLED_BY_USER(98),
  /**
   * <pre>
   * Special value: the solver status could not be properly translated and is
   * unknown.
   * </pre>
   *
   * <code>MPSOLVER_UNKNOWN_STATUS = 99;</code>
   */
  MPSOLVER_UNKNOWN_STATUS(99),
  /**
   * <pre>
   * Model errors. These are always deterministic and repeatable.
   * They should be accompanied with a string description of the error.
   * </pre>
   *
   * <code>MPSOLVER_MODEL_INVALID = 5;</code>
   */
  MPSOLVER_MODEL_INVALID(5),
  /**
   * <pre>
   * Something is wrong with the fields "solution_hint_var_index" and/or
   * "solution_hint_var_value".
   * </pre>
   *
   * <code>MPSOLVER_MODEL_INVALID_SOLUTION_HINT = 84;</code>
   */
  MPSOLVER_MODEL_INVALID_SOLUTION_HINT(84),
  /**
   * <pre>
   * Something is wrong with the solver_specific_parameters request field.
   * </pre>
   *
   * <code>MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS = 85;</code>
   */
  MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS(85),
  /**
   * <pre>
   * Implementation error: the requested solver implementation is not
   * available (see MPModelRequest.solver_type).
   * The linear solver binary was probably not linked with the required library,
   * eg //ortools/linear_solver:linear_solver_scip for SCIP.
   * </pre>
   *
   * <code>MPSOLVER_SOLVER_TYPE_UNAVAILABLE = 7;</code>
   */
  MPSOLVER_SOLVER_TYPE_UNAVAILABLE(7),
  /**
   * <pre>
   * Some of the selected options were incompatible, e.g. a cancellable solve
   * was requested via SolverClient::SolveMipRemotely() with an underlying
   * solver that doesn't support cancellation. status_str should contain a
   * description of the issue.
   * </pre>
   *
   * <code>MPSOLVER_INCOMPATIBLE_OPTIONS = 113;</code>
   */
  MPSOLVER_INCOMPATIBLE_OPTIONS(113),
  ;

  /**
   * <pre>
   * The solver found the proven optimal solution. This is what should be
   * returned in most cases.
   * WARNING: for historical reason, the value is zero, which means that this
   * value can't have any subcategories.
   * </pre>
   *
   * <code>MPSOLVER_OPTIMAL = 0;</code>
   */
  public static final int MPSOLVER_OPTIMAL_VALUE = 0;
  /**
   * <pre>
   * The solver had enough time to find some solution that satisfies all
   * constraints, but it did not prove optimality (which means it may or may
   * not have reached the optimal).
   * This can happen for large LP models (Linear Programming), and is a frequent
   * response for time-limited MIPs (Mixed Integer Programming). In the MIP
   * case, the difference between the solution 'objective_value' and
   * 'best_objective_bound' fields of the MPSolutionResponse will give an
   * indication of how far this solution is from the optimal one.
   * </pre>
   *
   * <code>MPSOLVER_FEASIBLE = 1;</code>
   */
  public static final int MPSOLVER_FEASIBLE_VALUE = 1;
  /**
   * <pre>
   * The model does not have any solution, according to the solver (which
   * "proved" it, with the caveat that numerical proofs aren't actual proofs),
   * or based on trivial considerations (eg. a variable whose lower bound is
   * strictly greater than its upper bound).
   * </pre>
   *
   * <code>MPSOLVER_INFEASIBLE = 2;</code>
   */
  public static final int MPSOLVER_INFEASIBLE_VALUE = 2;
  /**
   * <pre>
   * There exist solutions that make the magnitude of the objective value
   * as large as wanted (i.e. -infinity (resp. +infinity) for a minimization
   * (resp. maximization) problem.
   * </pre>
   *
   * <code>MPSOLVER_UNBOUNDED = 3;</code>
   */
  public static final int MPSOLVER_UNBOUNDED_VALUE = 3;
  /**
   * <pre>
   * An error (most probably numerical) occurred.
   * One likely cause for such errors is a large numerical range among variable
   * coefficients (eg. 1e-16, 1e20), in which case one should try to shrink it.
   * </pre>
   *
   * <code>MPSOLVER_ABNORMAL = 4;</code>
   */
  public static final int MPSOLVER_ABNORMAL_VALUE = 4;
  /**
   * <pre>
   * The solver did not have a chance to diagnose the model in one of the
   * categories above.
   * </pre>
   *
   * <code>MPSOLVER_NOT_SOLVED = 6;</code>
   */
  public static final int MPSOLVER_NOT_SOLVED_VALUE = 6;
  /**
   * <pre>
   * Like "NOT_SOLVED", but typically used by model validation functions
   * returning a "model status", to enhance readability of the client code.
   * </pre>
   *
   * <code>MPSOLVER_MODEL_IS_VALID = 97;</code>
   */
  public static final int MPSOLVER_MODEL_IS_VALID_VALUE = 97;
  /**
   * <pre>
   * The solve was interrupted by the user, and the solver didn't have time to
   * return a proper status.
   * </pre>
   *
   * <code>MPSOLVER_CANCELLED_BY_USER = 98;</code>
   */
  public static final int MPSOLVER_CANCELLED_BY_USER_VALUE = 98;
  /**
   * <pre>
   * Special value: the solver status could not be properly translated and is
   * unknown.
   * </pre>
   *
   * <code>MPSOLVER_UNKNOWN_STATUS = 99;</code>
   */
  public static final int MPSOLVER_UNKNOWN_STATUS_VALUE = 99;
  /**
   * <pre>
   * Model errors. These are always deterministic and repeatable.
   * They should be accompanied with a string description of the error.
   * </pre>
   *
   * <code>MPSOLVER_MODEL_INVALID = 5;</code>
   */
  public static final int MPSOLVER_MODEL_INVALID_VALUE = 5;
  /**
   * <pre>
   * Something is wrong with the fields "solution_hint_var_index" and/or
   * "solution_hint_var_value".
   * </pre>
   *
   * <code>MPSOLVER_MODEL_INVALID_SOLUTION_HINT = 84;</code>
   */
  public static final int MPSOLVER_MODEL_INVALID_SOLUTION_HINT_VALUE = 84;
  /**
   * <pre>
   * Something is wrong with the solver_specific_parameters request field.
   * </pre>
   *
   * <code>MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS = 85;</code>
   */
  public static final int MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS_VALUE = 85;
  /**
   * <pre>
   * Implementation error: the requested solver implementation is not
   * available (see MPModelRequest.solver_type).
   * The linear solver binary was probably not linked with the required library,
   * eg //ortools/linear_solver:linear_solver_scip for SCIP.
   * </pre>
   *
   * <code>MPSOLVER_SOLVER_TYPE_UNAVAILABLE = 7;</code>
   */
  public static final int MPSOLVER_SOLVER_TYPE_UNAVAILABLE_VALUE = 7;
  /**
   * <pre>
   * Some of the selected options were incompatible, e.g. a cancellable solve
   * was requested via SolverClient::SolveMipRemotely() with an underlying
   * solver that doesn't support cancellation. status_str should contain a
   * description of the issue.
   * </pre>
   *
   * <code>MPSOLVER_INCOMPATIBLE_OPTIONS = 113;</code>
   */
  public static final int MPSOLVER_INCOMPATIBLE_OPTIONS_VALUE = 113;


  public final int getNumber() {
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static MPSolverResponseStatus valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static MPSolverResponseStatus forNumber(int value) {
    switch (value) {
      case 0: return MPSOLVER_OPTIMAL;
      case 1: return MPSOLVER_FEASIBLE;
      case 2: return MPSOLVER_INFEASIBLE;
      case 3: return MPSOLVER_UNBOUNDED;
      case 4: return MPSOLVER_ABNORMAL;
      case 6: return MPSOLVER_NOT_SOLVED;
      case 97: return MPSOLVER_MODEL_IS_VALID;
      case 98: return MPSOLVER_CANCELLED_BY_USER;
      case 99: return MPSOLVER_UNKNOWN_STATUS;
      case 5: return MPSOLVER_MODEL_INVALID;
      case 84: return MPSOLVER_MODEL_INVALID_SOLUTION_HINT;
      case 85: return MPSOLVER_MODEL_INVALID_SOLVER_PARAMETERS;
      case 7: return MPSOLVER_SOLVER_TYPE_UNAVAILABLE;
      case 113: return MPSOLVER_INCOMPATIBLE_OPTIONS;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<MPSolverResponseStatus>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      MPSolverResponseStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MPSolverResponseStatus>() {
          public MPSolverResponseStatus findValueByNumber(int number) {
            return MPSolverResponseStatus.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return com.google.ortools.linearsolver.LinearSolver.getDescriptor().getEnumTypes().get(0);
  }

  private static final MPSolverResponseStatus[] VALUES = values();

  public static MPSolverResponseStatus valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private MPSolverResponseStatus(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:operations_research.MPSolverResponseStatus)
}

