/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  The following constraint ensures that incompatibilities and requirements<br>
 *  between types are respected.<br>
 * <br>
 *  It verifies both "hard" and "temporal" incompatibilities.<br>
 *  Two nodes with hard incompatible types cannot be served by the same vehicle<br>
 *  at all, while with a temporal incompatibility they can't be on the same<br>
 *  route at the same time.<br>
 *  The VisitTypePolicy of a node determines how visiting it impacts the type<br>
 *  count on the route.<br>
 * <br>
 *  For example, for<br>
 *  - three temporally incompatible types T1 T2 and T3<br>
 *  - 2 pairs of nodes a1/r1 and a2/r2 of type T1 and T2 respectively, with<br>
 *      - a1 and a2 of VisitTypePolicy TYPE_ADDED_TO_VEHICLE<br>
 *      - r1 and r2 of policy ADDED_TYPE_REMOVED_FROM_VEHICLE<br>
 *  - 3 nodes A, UV and AR of type T3, respectively with type policies<br>
 *    TYPE_ADDED_TO_VEHICLE, TYPE_ON_VEHICLE_UP_TO_VISIT and<br>
 *    TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED<br>
 *  the configurations<br>
 *  UV --&gt; a1 --&gt; r1 --&gt; a2 --&gt; r2,   a1 --&gt; r1 --&gt; a2 --&gt; r2 --&gt; A and<br>
 *  a1 --&gt; r1 --&gt; AR --&gt; a2 --&gt; r2 are acceptable, whereas the configurations<br>
 *  a1 --&gt; a2 --&gt; r1 --&gt; ..., or A --&gt; a1 --&gt; r1 --&gt; ..., or<br>
 *  a1 --&gt; r1 --&gt; UV --&gt; ... are not feasible.<br>
 * <br>
 *  It also verifies same-vehicle and temporal type requirements.<br>
 *  A node of type T_d with a same-vehicle requirement for type T_r needs to be<br>
 *  served by the same vehicle as a node of type T_r.<br>
 *  Temporal requirements, on the other hand, can take effect either when the<br>
 *  dependent type is being added to the route or when it's removed from it,<br>
 *  which is determined by the dependent node's VisitTypePolicy.<br>
 *  In the above example:<br>
 *  - If T3 is required on the same vehicle as T1, A, AR or UV must be on the<br>
 *    same vehicle as a1.<br>
 *  - If T2 is required when adding T1, a2 must be visited *before* a1, and if<br>
 *    r2 is also visited on the route, it must be *after* a1, i.e. T2 must be on<br>
 *    the vehicle when a1 is visited:<br>
 *    ... --&gt; a2 --&gt; ... --&gt; a1 --&gt; ... --&gt; r2 --&gt; ...<br>
 *  - If T3 is required when removing T1, T3 needs to be on the vehicle when<br>
 *    r1 is visited:<br>
 *    ... --&gt; A --&gt; ... --&gt; r1 --&gt; ...   OR   ... --&gt; r1 --&gt; ... --&gt; UV --&gt; ...
 */
public class TypeRegulationsConstraint extends Constraint {
  private transient long swigCPtr;

  protected TypeRegulationsConstraint(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.TypeRegulationsConstraint_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(TypeRegulationsConstraint obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_TypeRegulationsConstraint(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  public TypeRegulationsConstraint(RoutingModel model) {
    this(mainJNI.new_TypeRegulationsConstraint(RoutingModel.getCPtr(model), model), true);
  }

  public void post() {
    mainJNI.TypeRegulationsConstraint_post(swigCPtr, this);
  }

  public void initialPropagate() {
    mainJNI.TypeRegulationsConstraint_initialPropagate(swigCPtr, this);
  }

}
