/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  This class represent a reversible FIFO structure.<br>
 *  The main difference w.r.t a standard FIFO structure is that a Solver is<br>
 *  given as parameter to the modifiers such that the solver can store the<br>
 *  backtrack information<br>
 *  Iterator's traversing order should not be changed, as some algorithm<br>
 *  depend on it to be consistent.<br>
 *  It's main use is to store a list of demons in the various classes of<br>
 *  variables.<br>
 *  The base class for all local search operators.<br>
 * <br>
 *  A local search operator is an object that defines the neighborhood of a<br>
 *  solution. In other words, a neighborhood is the set of solutions which can<br>
 *  be reached from a given solution using an operator.<br>
 * <br>
 *  The behavior of the LocalSearchOperator class is similar to iterators.<br>
 *  The operator is synchronized with an assignment (gives the<br>
 *  current values of the variables); this is done in the Start() method.<br>
 * <br>
 *  Then one can iterate over the neighbors using the MakeNextNeighbor method.<br>
 *  This method returns an assignment which represents the incremental changes<br>
 *  to the current solution. It also returns a second assignment representing<br>
 *  the changes to the last solution defined by the neighborhood operator; this<br>
 *  assignment is empty if the neighborhood operator cannot track this<br>
 *  information.
 */
public class LocalSearchOperator extends BaseObject {
  private transient long swigCPtr;

  protected LocalSearchOperator(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.LocalSearchOperator_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LocalSearchOperator obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_LocalSearchOperator(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  protected void swigDirectorDisconnect() {
    swigCMemOwn = false;
    delete();
  }

  public void swigReleaseOwnership() {
    swigCMemOwn = false;
    mainJNI.LocalSearchOperator_change_ownership(this, swigCPtr, false);
  }

  public void swigTakeOwnership() {
    swigCMemOwn = true;
    mainJNI.LocalSearchOperator_change_ownership(this, swigCPtr, true);
  }

  public LocalSearchOperator() {
    this(mainJNI.new_LocalSearchOperator(), true);
    mainJNI.LocalSearchOperator_director_connect(this, swigCPtr, true, true);
  }

  public boolean nextNeighbor(Assignment delta, Assignment deltadelta) {
    return mainJNI.LocalSearchOperator_nextNeighbor(swigCPtr, this, Assignment.getCPtr(delta), delta, Assignment.getCPtr(deltadelta), deltadelta);
  }

  public void start(Assignment assignment) {
    mainJNI.LocalSearchOperator_start(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
  }

  public void reset() {
    if (getClass() == LocalSearchOperator.class) mainJNI.LocalSearchOperator_reset(swigCPtr, this); else mainJNI.LocalSearchOperator_resetSwigExplicitLocalSearchOperator(swigCPtr, this);
  }

  public boolean HasFragments() {
    return (getClass() == LocalSearchOperator.class) ? mainJNI.LocalSearchOperator_HasFragments(swigCPtr, this) : mainJNI.LocalSearchOperator_HasFragmentsSwigExplicitLocalSearchOperator(swigCPtr, this);
  }

  public boolean HoldsDelta() {
    return (getClass() == LocalSearchOperator.class) ? mainJNI.LocalSearchOperator_HoldsDelta(swigCPtr, this) : mainJNI.LocalSearchOperator_HoldsDeltaSwigExplicitLocalSearchOperator(swigCPtr, this);
  }

}
