/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.BatchJob;
import com.google.genai.types.BatchJobSource;
import com.google.genai.types.CancelBatchJobConfig;
import com.google.genai.types.CancelBatchJobParameters;
import com.google.genai.types.CreateBatchJobConfig;
import com.google.genai.types.CreateBatchJobParameters;
import com.google.genai.types.DeleteBatchJobConfig;
import com.google.genai.types.DeleteBatchJobParameters;
import com.google.genai.types.DeleteResourceJob;
import com.google.genai.types.GetBatchJobConfig;
import com.google.genai.types.GetBatchJobParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.ListBatchJobsConfig;
import com.google.genai.types.ListBatchJobsParameters;
import com.google.genai.types.ListBatchJobsResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.ResponseBody;

public final class Batches {
    final ApiClient apiClient;

    public Batches(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoMetadataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fps"}, Common.getValueByPath(fromObject, new String[]{"fps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endOffset"}, Common.getValueByPath(fromObject, new String[]{"endOffset"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startOffset"}, Common.getValueByPath(fromObject, new String[]{"startOffset"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, this.videoMetadataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"videoMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode schemaToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"anyOf"}) != null) {
            Common.setValueByPath(toObject, new String[]{"anyOf"}, Common.getValueByPath(fromObject, new String[]{"anyOf"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"default"}) != null) {
            Common.setValueByPath(toObject, new String[]{"default"}, Common.getValueByPath(fromObject, new String[]{"default"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enum"}, Common.getValueByPath(fromObject, new String[]{"enum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"example"}) != null) {
            Common.setValueByPath(toObject, new String[]{"example"}, Common.getValueByPath(fromObject, new String[]{"example"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"items"}) != null) {
            Common.setValueByPath(toObject, new String[]{"items"}, Common.getValueByPath(fromObject, new String[]{"items"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxItems"}, Common.getValueByPath(fromObject, new String[]{"maxItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxLength"}, Common.getValueByPath(fromObject, new String[]{"maxLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxProperties"}, Common.getValueByPath(fromObject, new String[]{"maxProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maximum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maximum"}, Common.getValueByPath(fromObject, new String[]{"maximum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minItems"}, Common.getValueByPath(fromObject, new String[]{"minItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minLength"}, Common.getValueByPath(fromObject, new String[]{"minLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minProperties"}, Common.getValueByPath(fromObject, new String[]{"minProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minimum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minimum"}, Common.getValueByPath(fromObject, new String[]{"minimum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nullable"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nullable"}, Common.getValueByPath(fromObject, new String[]{"nullable"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pattern"}) != null) {
            Common.setValueByPath(toObject, new String[]{"pattern"}, Common.getValueByPath(fromObject, new String[]{"pattern"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"properties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"properties"}, Common.getValueByPath(fromObject, new String[]{"properties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}) != null) {
            Common.setValueByPath(toObject, new String[]{"propertyOrdering"}, Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"required"}) != null) {
            Common.setValueByPath(toObject, new String[]{"required"}, Common.getValueByPath(fromObject, new String[]{"required"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"title"}) != null) {
            Common.setValueByPath(toObject, new String[]{"title"}, Common.getValueByPath(fromObject, new String[]{"title"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"type"}) != null) {
            Common.setValueByPath(toObject, new String[]{"type"}, Common.getValueByPath(fromObject, new String[]{"type"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode modelSelectionConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"featureSelectionPreference"}))) {
            throw new IllegalArgumentException("featureSelectionPreference parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode safetySettingToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"method"}))) {
            throw new IllegalArgumentException("method parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"category"}) != null) {
            Common.setValueByPath(toObject, new String[]{"category"}, Common.getValueByPath(fromObject, new String[]{"category"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"threshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"threshold"}, Common.getValueByPath(fromObject, new String[]{"threshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"behavior"}) != null) {
            Common.setValueByPath(toObject, new String[]{"behavior"}, Common.getValueByPath(fromObject, new String[]{"behavior"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode intervalToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, this.intervalToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode dynamicRetrievalConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicThreshold"}, Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchRetrievalToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicRetrievalConfig"}, this.dynamicRetrievalConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode enterpriseWebSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode apiKeyConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"apiKeyString"}))) {
            throw new IllegalArgumentException("apiKeyString parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode authConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"}))) {
            throw new IllegalArgumentException("apiKeyConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"authType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authType"}, Common.getValueByPath(fromObject, new String[]{"authType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleServiceAccountConfig"}, Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"httpBasicAuthConfig"}, Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oauthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oauthConfig"}, Common.getValueByPath(fromObject, new String[]{"oauthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oidcConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oidcConfig"}, Common.getValueByPath(fromObject, new String[]{"oidcConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"authConfig"}))) {
            throw new IllegalArgumentException("authConfig parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"retrieval"}))) {
            throw new IllegalArgumentException("retrieval parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, this.googleSearchRetrievalToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}))) {
            throw new IllegalArgumentException("enterpriseWebSearch parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"googleMaps"}))) {
            throw new IllegalArgumentException("googleMaps parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, this.urlContextToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContext"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode latLngToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latitude"}, Common.getValueByPath(fromObject, new String[]{"latitude"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"longitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"longitude"}, Common.getValueByPath(fromObject, new String[]{"longitude"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode retrievalConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latLng"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latLng"}, this.latLngToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"latLng"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, this.retrievalConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"retrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode prebuiltVoiceConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceName"}, Common.getValueByPath(fromObject, new String[]{"voiceName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode voiceConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"prebuiltVoiceConfig"}, this.prebuiltVoiceConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speakerVoiceConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"speaker"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speaker"}, Common.getValueByPath(fromObject, new String[]{"speaker"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"voiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceConfig"}, this.voiceConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"voiceConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode multiSpeakerVoiceConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"speakerVoiceConfigs"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"speakerVoiceConfigs"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.speakerVoiceConfigToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"speakerVoiceConfigs"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speechConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceConfig"}, this.voiceConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"voiceConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"multiSpeakerVoiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"multiSpeakerVoiceConfig"}, this.multiSpeakerVoiceConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"multiSpeakerVoiceConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode thinkingConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"includeThoughts"}) != null) {
            Common.setValueByPath(toObject, new String[]{"includeThoughts"}, Common.getValueByPath(fromObject, new String[]{"includeThoughts"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingBudget"}, Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentConfigToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, this.contentToMldev(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"temperature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"temperature"}, Common.getValueByPath(fromObject, new String[]{"temperature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topP"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topP"}, Common.getValueByPath(fromObject, new String[]{"topP"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topK"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topK"}, Common.getValueByPath(fromObject, new String[]{"topK"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"candidateCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"candidateCount"}, Common.getValueByPath(fromObject, new String[]{"candidateCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxOutputTokens"}, Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"stopSequences"}) != null) {
            Common.setValueByPath(toObject, new String[]{"stopSequences"}, Common.getValueByPath(fromObject, new String[]{"stopSequences"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseLogprobs"}, Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobs"}, Common.getValueByPath(fromObject, new String[]{"logprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"presencePenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"presencePenalty"}, Common.getValueByPath(fromObject, new String[]{"presencePenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"frequencyPenalty"}, Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"seed"}) != null) {
            Common.setValueByPath(toObject, new String[]{"seed"}, Common.getValueByPath(fromObject, new String[]{"seed"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseMimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseMimeType"}, Common.getValueByPath(fromObject, new String[]{"responseMimeType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseSchema"}, this.schemaToMldev(JsonSerializable.toJsonNode(Transformers.tSchema(Common.getValueByPath(fromObject, new String[]{"responseSchema"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"routingConfig"}))) {
            throw new IllegalArgumentException("routingConfig parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"modelSelectionConfig"}))) {
            throw new IllegalArgumentException("modelSelectionConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetySettings"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"safetySettings"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.safetySettingToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"safetySettings"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Transformers.tTools(Common.getValueByPath(fromObject, new String[]{"tools"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToMldev(JsonSerializable.toJsonNode(Transformers.tTool(item)), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, this.toolConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"toolConfig"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"labels"}))) {
            throw new IllegalArgumentException("labels parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContent"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"cachedContent"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"cachedContent"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseModalities"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseModalities"}, Common.getValueByPath(fromObject, new String[]{"responseModalities"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"speechConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speechConfig"}, this.speechConfigToMldev(JsonSerializable.toJsonNode(Transformers.tSpeechConfig(Common.getValueByPath(fromObject, new String[]{"speechConfig"}))), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"audioTimestamp"}))) {
            throw new IllegalArgumentException("audioTimestamp parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingConfig"}, this.thinkingConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"thinkingConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedRequestToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"request", "model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            ArrayNode keyArray = (ArrayNode)Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"contents"}));
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.contentToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"request", "contents"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"request", "generationConfig"}, this.generateContentConfigToMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"format"}))) {
            throw new IllegalArgumentException("format parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"gcsUri"}))) {
            throw new IllegalArgumentException("gcsUri parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}))) {
            throw new IllegalArgumentException("bigqueryUri parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileName"}, Common.getValueByPath(fromObject, new String[]{"fileName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedRequests"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"inlinedRequests"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.inlinedRequestToMldev(apiClient, JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"requests", "requests"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode citationMetadataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"citations"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citationSources"}, Common.getValueByPath(fromObject, new String[]{"citations"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlMetadataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievedUrl"}, Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlRetrievalStatus"}, Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextMetadataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"urlMetadata"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"urlMetadata"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.urlMetadataToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"urlMetadata"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode candidateToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"content"}) != null) {
            Common.setValueByPath(toObject, new String[]{"content"}, this.contentToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"content"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"citationMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citationMetadata"}, this.citationMetadataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"citationMetadata"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"finishMessage"}))) {
            throw new IllegalArgumentException("finishMessage parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"tokenCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"tokenCount"}, Common.getValueByPath(fromObject, new String[]{"tokenCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishReason"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishReason"}, Common.getValueByPath(fromObject, new String[]{"finishReason"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContextMetadata"}, this.urlContextMetadataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"avgLogprobs"}, Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"groundingMetadata"}, Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"index"}) != null) {
            Common.setValueByPath(toObject, new String[]{"index"}, Common.getValueByPath(fromObject, new String[]{"index"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobsResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobsResult"}, Common.getValueByPath(fromObject, new String[]{"logprobsResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetyRatings"}) != null) {
            Common.setValueByPath(toObject, new String[]{"safetyRatings"}, Common.getValueByPath(fromObject, new String[]{"safetyRatings"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentResponseToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"candidates"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"candidates"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.candidateToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"candidates"}, result);
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"createTime"}))) {
            throw new IllegalArgumentException("createTime parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"responseId"}))) {
            throw new IllegalArgumentException("responseId parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelVersion"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelVersion"}, Common.getValueByPath(fromObject, new String[]{"modelVersion"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"promptFeedback"}) != null) {
            Common.setValueByPath(toObject, new String[]{"promptFeedback"}, Common.getValueByPath(fromObject, new String[]{"promptFeedback"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode jobErrorToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"details"}))) {
            throw new IllegalArgumentException("details parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"code"}))) {
            throw new IllegalArgumentException("code parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"message"}))) {
            throw new IllegalArgumentException("message parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedResponseToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateContentResponseToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, this.jobErrorToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"error"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"format"}))) {
            throw new IllegalArgumentException("format parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"gcsUri"}))) {
            throw new IllegalArgumentException("gcsUri parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}))) {
            throw new IllegalArgumentException("bigqueryUri parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responsesFile"}, Common.getValueByPath(fromObject, new String[]{"fileName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedResponses"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"inlinedResponses"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.inlinedResponseToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"inlinedResponses", "inlinedResponses"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"batch", "displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"dest"}))) {
            throw new IllegalArgumentException("dest parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"src"}) != null) {
            Common.setValueByPath(toObject, new String[]{"batch", "inputConfig"}, this.batchJobSourceToMldev(apiClient, JsonSerializable.toJsonNode(Transformers.tBatchJobSource(Common.getValueByPath(fromObject, new String[]{"src"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.createBatchJobConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode cancelBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"filter"}))) {
            throw new IllegalArgumentException("filter parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.listBatchJobsConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteBatchJobParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoMetadataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fps"}, Common.getValueByPath(fromObject, new String[]{"fps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endOffset"}, Common.getValueByPath(fromObject, new String[]{"endOffset"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startOffset"}, Common.getValueByPath(fromObject, new String[]{"startOffset"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, this.videoMetadataToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"videoMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode schemaToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"anyOf"}) != null) {
            Common.setValueByPath(toObject, new String[]{"anyOf"}, Common.getValueByPath(fromObject, new String[]{"anyOf"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"default"}) != null) {
            Common.setValueByPath(toObject, new String[]{"default"}, Common.getValueByPath(fromObject, new String[]{"default"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enum"}, Common.getValueByPath(fromObject, new String[]{"enum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"example"}) != null) {
            Common.setValueByPath(toObject, new String[]{"example"}, Common.getValueByPath(fromObject, new String[]{"example"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"items"}) != null) {
            Common.setValueByPath(toObject, new String[]{"items"}, Common.getValueByPath(fromObject, new String[]{"items"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxItems"}, Common.getValueByPath(fromObject, new String[]{"maxItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxLength"}, Common.getValueByPath(fromObject, new String[]{"maxLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxProperties"}, Common.getValueByPath(fromObject, new String[]{"maxProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maximum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maximum"}, Common.getValueByPath(fromObject, new String[]{"maximum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minItems"}, Common.getValueByPath(fromObject, new String[]{"minItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minLength"}, Common.getValueByPath(fromObject, new String[]{"minLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minProperties"}, Common.getValueByPath(fromObject, new String[]{"minProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minimum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minimum"}, Common.getValueByPath(fromObject, new String[]{"minimum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nullable"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nullable"}, Common.getValueByPath(fromObject, new String[]{"nullable"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pattern"}) != null) {
            Common.setValueByPath(toObject, new String[]{"pattern"}, Common.getValueByPath(fromObject, new String[]{"pattern"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"properties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"properties"}, Common.getValueByPath(fromObject, new String[]{"properties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}) != null) {
            Common.setValueByPath(toObject, new String[]{"propertyOrdering"}, Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"required"}) != null) {
            Common.setValueByPath(toObject, new String[]{"required"}, Common.getValueByPath(fromObject, new String[]{"required"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"title"}) != null) {
            Common.setValueByPath(toObject, new String[]{"title"}, Common.getValueByPath(fromObject, new String[]{"title"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"type"}) != null) {
            Common.setValueByPath(toObject, new String[]{"type"}, Common.getValueByPath(fromObject, new String[]{"type"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode modelSelectionConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"featureSelectionPreference"}) != null) {
            Common.setValueByPath(toObject, new String[]{"featureSelectionPreference"}, Common.getValueByPath(fromObject, new String[]{"featureSelectionPreference"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode safetySettingToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"method"}) != null) {
            Common.setValueByPath(toObject, new String[]{"method"}, Common.getValueByPath(fromObject, new String[]{"method"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"category"}) != null) {
            Common.setValueByPath(toObject, new String[]{"category"}, Common.getValueByPath(fromObject, new String[]{"category"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"threshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"threshold"}, Common.getValueByPath(fromObject, new String[]{"threshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"behavior"}))) {
            throw new IllegalArgumentException("behavior parameter is not supported in Vertex AI.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode intervalToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, this.intervalToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode dynamicRetrievalConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicThreshold"}, Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchRetrievalToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicRetrievalConfig"}, this.dynamicRetrievalConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode enterpriseWebSearchToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode apiKeyConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"apiKeyString"}) != null) {
            Common.setValueByPath(toObject, new String[]{"apiKeyString"}, Common.getValueByPath(fromObject, new String[]{"apiKeyString"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode authConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"apiKeyConfig"}, this.apiKeyConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"authType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authType"}, Common.getValueByPath(fromObject, new String[]{"authType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleServiceAccountConfig"}, Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"httpBasicAuthConfig"}, Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oauthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oauthConfig"}, Common.getValueByPath(fromObject, new String[]{"oauthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oidcConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oidcConfig"}, Common.getValueByPath(fromObject, new String[]{"oidcConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"authConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authConfig"}, this.authConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"authConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrieval"}, Common.getValueByPath(fromObject, new String[]{"retrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, this.googleSearchRetrievalToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enterpriseWebSearch"}, this.enterpriseWebSearchToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, this.googleMapsToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleMaps"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, this.urlContextToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContext"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode latLngToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latitude"}, Common.getValueByPath(fromObject, new String[]{"latitude"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"longitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"longitude"}, Common.getValueByPath(fromObject, new String[]{"longitude"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode retrievalConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latLng"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latLng"}, this.latLngToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"latLng"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, this.retrievalConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"retrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode prebuiltVoiceConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceName"}, Common.getValueByPath(fromObject, new String[]{"voiceName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode voiceConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"prebuiltVoiceConfig"}, this.prebuiltVoiceConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speakerVoiceConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"speaker"}))) {
            throw new IllegalArgumentException("speaker parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"voiceConfig"}))) {
            throw new IllegalArgumentException("voiceConfig parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode multiSpeakerVoiceConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"speakerVoiceConfigs"}))) {
            throw new IllegalArgumentException("speakerVoiceConfigs parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speechConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceConfig"}, this.voiceConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"voiceConfig"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"multiSpeakerVoiceConfig"}))) {
            throw new IllegalArgumentException("multiSpeakerVoiceConfig parameter is not supported in Vertex AI.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode thinkingConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"includeThoughts"}) != null) {
            Common.setValueByPath(toObject, new String[]{"includeThoughts"}, Common.getValueByPath(fromObject, new String[]{"includeThoughts"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingBudget"}, Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentConfigToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, this.contentToVertex(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"temperature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"temperature"}, Common.getValueByPath(fromObject, new String[]{"temperature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topP"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topP"}, Common.getValueByPath(fromObject, new String[]{"topP"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topK"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topK"}, Common.getValueByPath(fromObject, new String[]{"topK"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"candidateCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"candidateCount"}, Common.getValueByPath(fromObject, new String[]{"candidateCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxOutputTokens"}, Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"stopSequences"}) != null) {
            Common.setValueByPath(toObject, new String[]{"stopSequences"}, Common.getValueByPath(fromObject, new String[]{"stopSequences"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseLogprobs"}, Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobs"}, Common.getValueByPath(fromObject, new String[]{"logprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"presencePenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"presencePenalty"}, Common.getValueByPath(fromObject, new String[]{"presencePenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"frequencyPenalty"}, Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"seed"}) != null) {
            Common.setValueByPath(toObject, new String[]{"seed"}, Common.getValueByPath(fromObject, new String[]{"seed"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseMimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseMimeType"}, Common.getValueByPath(fromObject, new String[]{"responseMimeType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseSchema"}, this.schemaToVertex(JsonSerializable.toJsonNode(Transformers.tSchema(Common.getValueByPath(fromObject, new String[]{"responseSchema"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"routingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"routingConfig"}, Common.getValueByPath(fromObject, new String[]{"routingConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelSelectionConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelConfig"}, this.modelSelectionConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"modelSelectionConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetySettings"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"safetySettings"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.safetySettingToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"safetySettings"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Transformers.tTools(Common.getValueByPath(fromObject, new String[]{"tools"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToVertex(JsonSerializable.toJsonNode(Transformers.tTool(item)), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, this.toolConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"toolConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"labels"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"labels"}, Common.getValueByPath(fromObject, new String[]{"labels"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContent"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"cachedContent"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"cachedContent"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseModalities"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseModalities"}, Common.getValueByPath(fromObject, new String[]{"responseModalities"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"speechConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speechConfig"}, this.speechConfigToVertex(JsonSerializable.toJsonNode(Transformers.tSpeechConfig(Common.getValueByPath(fromObject, new String[]{"speechConfig"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"audioTimestamp"}) != null) {
            Common.setValueByPath(toObject, new String[]{"audioTimestamp"}, Common.getValueByPath(fromObject, new String[]{"audioTimestamp"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingConfig"}, this.thinkingConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"thinkingConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedRequestToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"model"}))) {
            throw new IllegalArgumentException("model parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"contents"}))) {
            throw new IllegalArgumentException("contents parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"config"}))) {
            throw new IllegalArgumentException("config parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"instancesFormat"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsSource", "uris"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigquerySource", "inputUri"}, Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"fileName"}))) {
            throw new IllegalArgumentException("fileName parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"inlinedRequests"}))) {
            throw new IllegalArgumentException("inlinedRequests parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode citationMetadataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"citations"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citations"}, Common.getValueByPath(fromObject, new String[]{"citations"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlMetadataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievedUrl"}, Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlRetrievalStatus"}, Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextMetadataToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"urlMetadata"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"urlMetadata"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.urlMetadataToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"urlMetadata"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode candidateToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"content"}) != null) {
            Common.setValueByPath(toObject, new String[]{"content"}, this.contentToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"content"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"citationMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citationMetadata"}, this.citationMetadataToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"citationMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishMessage"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishMessage"}, Common.getValueByPath(fromObject, new String[]{"finishMessage"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"tokenCount"}))) {
            throw new IllegalArgumentException("tokenCount parameter is not supported in Vertex AI.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishReason"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishReason"}, Common.getValueByPath(fromObject, new String[]{"finishReason"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContextMetadata"}, this.urlContextMetadataToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"avgLogprobs"}, Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"groundingMetadata"}, Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"index"}) != null) {
            Common.setValueByPath(toObject, new String[]{"index"}, Common.getValueByPath(fromObject, new String[]{"index"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobsResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobsResult"}, Common.getValueByPath(fromObject, new String[]{"logprobsResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetyRatings"}) != null) {
            Common.setValueByPath(toObject, new String[]{"safetyRatings"}, Common.getValueByPath(fromObject, new String[]{"safetyRatings"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentResponseToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"candidates"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"candidates"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.candidateToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"candidates"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseId"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseId"}, Common.getValueByPath(fromObject, new String[]{"responseId"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelVersion"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelVersion"}, Common.getValueByPath(fromObject, new String[]{"modelVersion"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"promptFeedback"}) != null) {
            Common.setValueByPath(toObject, new String[]{"promptFeedback"}, Common.getValueByPath(fromObject, new String[]{"promptFeedback"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode jobErrorToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"details"}) != null) {
            Common.setValueByPath(toObject, new String[]{"details"}, Common.getValueByPath(fromObject, new String[]{"details"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"code"}) != null) {
            Common.setValueByPath(toObject, new String[]{"code"}, Common.getValueByPath(fromObject, new String[]{"code"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"message"}) != null) {
            Common.setValueByPath(toObject, new String[]{"message"}, Common.getValueByPath(fromObject, new String[]{"message"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedResponseToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"response"}))) {
            throw new IllegalArgumentException("response parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"error"}))) {
            throw new IllegalArgumentException("error parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"predictionsFormat"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsDestination", "outputUriPrefix"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigqueryDestination", "outputUri"}, Common.getValueByPath(fromObject, new String[]{"bigqueryUri"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"fileName"}))) {
            throw new IllegalArgumentException("fileName parameter is not supported in Vertex AI.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"inlinedResponses"}))) {
            throw new IllegalArgumentException("inlinedResponses parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dest"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"outputConfig"}, this.batchJobDestinationToVertex(JsonSerializable.toJsonNode(Transformers.tBatchJobDestination(Common.getValueByPath(fromObject, new String[]{"dest"}))), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"src"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inputConfig"}, this.batchJobSourceToVertex(JsonSerializable.toJsonNode(Transformers.tBatchJobSource(Common.getValueByPath(fromObject, new String[]{"src"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.createBatchJobConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode cancelBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"filter"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "filter"}, Common.getValueByPath(fromObject, new String[]{"filter"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.listBatchJobsConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteBatchJobParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tBatchJobName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, Common.getValueByPath(fromObject, new String[]{"config"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode jobErrorFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoMetadataFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fps"}, Common.getValueByPath(fromObject, new String[]{"fps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endOffset"}, Common.getValueByPath(fromObject, new String[]{"endOffset"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startOffset"}, Common.getValueByPath(fromObject, new String[]{"startOffset"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, this.videoMetadataFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"videoMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode schemaFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"anyOf"}) != null) {
            Common.setValueByPath(toObject, new String[]{"anyOf"}, Common.getValueByPath(fromObject, new String[]{"anyOf"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"default"}) != null) {
            Common.setValueByPath(toObject, new String[]{"default"}, Common.getValueByPath(fromObject, new String[]{"default"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enum"}, Common.getValueByPath(fromObject, new String[]{"enum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"example"}) != null) {
            Common.setValueByPath(toObject, new String[]{"example"}, Common.getValueByPath(fromObject, new String[]{"example"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"items"}) != null) {
            Common.setValueByPath(toObject, new String[]{"items"}, Common.getValueByPath(fromObject, new String[]{"items"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxItems"}, Common.getValueByPath(fromObject, new String[]{"maxItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxLength"}, Common.getValueByPath(fromObject, new String[]{"maxLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxProperties"}, Common.getValueByPath(fromObject, new String[]{"maxProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maximum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maximum"}, Common.getValueByPath(fromObject, new String[]{"maximum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minItems"}, Common.getValueByPath(fromObject, new String[]{"minItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minLength"}, Common.getValueByPath(fromObject, new String[]{"minLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minProperties"}, Common.getValueByPath(fromObject, new String[]{"minProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minimum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minimum"}, Common.getValueByPath(fromObject, new String[]{"minimum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nullable"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nullable"}, Common.getValueByPath(fromObject, new String[]{"nullable"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pattern"}) != null) {
            Common.setValueByPath(toObject, new String[]{"pattern"}, Common.getValueByPath(fromObject, new String[]{"pattern"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"properties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"properties"}, Common.getValueByPath(fromObject, new String[]{"properties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}) != null) {
            Common.setValueByPath(toObject, new String[]{"propertyOrdering"}, Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"required"}) != null) {
            Common.setValueByPath(toObject, new String[]{"required"}, Common.getValueByPath(fromObject, new String[]{"required"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"title"}) != null) {
            Common.setValueByPath(toObject, new String[]{"title"}, Common.getValueByPath(fromObject, new String[]{"title"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"type"}) != null) {
            Common.setValueByPath(toObject, new String[]{"type"}, Common.getValueByPath(fromObject, new String[]{"type"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode modelSelectionConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode safetySettingFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"category"}) != null) {
            Common.setValueByPath(toObject, new String[]{"category"}, Common.getValueByPath(fromObject, new String[]{"category"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"threshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"threshold"}, Common.getValueByPath(fromObject, new String[]{"threshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"behavior"}) != null) {
            Common.setValueByPath(toObject, new String[]{"behavior"}, Common.getValueByPath(fromObject, new String[]{"behavior"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode intervalFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, this.intervalFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode dynamicRetrievalConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicThreshold"}, Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchRetrievalFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicRetrievalConfig"}, this.dynamicRetrievalConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode enterpriseWebSearchFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode apiKeyConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode authConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"authType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authType"}, Common.getValueByPath(fromObject, new String[]{"authType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleServiceAccountConfig"}, Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"httpBasicAuthConfig"}, Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oauthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oauthConfig"}, Common.getValueByPath(fromObject, new String[]{"oauthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oidcConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oidcConfig"}, Common.getValueByPath(fromObject, new String[]{"oidcConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, this.googleSearchRetrievalFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, this.urlContextFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContext"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode latLngFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latitude"}, Common.getValueByPath(fromObject, new String[]{"latitude"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"longitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"longitude"}, Common.getValueByPath(fromObject, new String[]{"longitude"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode retrievalConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latLng"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latLng"}, this.latLngFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"latLng"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, this.retrievalConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"retrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode prebuiltVoiceConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceName"}, Common.getValueByPath(fromObject, new String[]{"voiceName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode voiceConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"prebuiltVoiceConfig"}, this.prebuiltVoiceConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speakerVoiceConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"speaker"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speaker"}, Common.getValueByPath(fromObject, new String[]{"speaker"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"voiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceConfig"}, this.voiceConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"voiceConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode multiSpeakerVoiceConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"speakerVoiceConfigs"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"speakerVoiceConfigs"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.speakerVoiceConfigFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"speakerVoiceConfigs"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speechConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceConfig"}, this.voiceConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"voiceConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"multiSpeakerVoiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"multiSpeakerVoiceConfig"}, this.multiSpeakerVoiceConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"multiSpeakerVoiceConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode thinkingConfigFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"includeThoughts"}) != null) {
            Common.setValueByPath(toObject, new String[]{"includeThoughts"}, Common.getValueByPath(fromObject, new String[]{"includeThoughts"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingBudget"}, Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentConfigFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(toObject, new String[]{"systemInstruction"}, this.contentFromMldev(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath((JsonNode)parentObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"temperature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"temperature"}, Common.getValueByPath(fromObject, new String[]{"temperature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topP"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topP"}, Common.getValueByPath(fromObject, new String[]{"topP"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topK"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topK"}, Common.getValueByPath(fromObject, new String[]{"topK"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"candidateCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"candidateCount"}, Common.getValueByPath(fromObject, new String[]{"candidateCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxOutputTokens"}, Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"stopSequences"}) != null) {
            Common.setValueByPath(toObject, new String[]{"stopSequences"}, Common.getValueByPath(fromObject, new String[]{"stopSequences"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseLogprobs"}, Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobs"}, Common.getValueByPath(fromObject, new String[]{"logprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"presencePenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"presencePenalty"}, Common.getValueByPath(fromObject, new String[]{"presencePenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"frequencyPenalty"}, Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"seed"}) != null) {
            Common.setValueByPath(toObject, new String[]{"seed"}, Common.getValueByPath(fromObject, new String[]{"seed"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseMimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseMimeType"}, Common.getValueByPath(fromObject, new String[]{"responseMimeType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseSchema"}, this.schemaFromMldev(JsonSerializable.toJsonNode(Transformers.tSchema(Common.getValueByPath(fromObject, new String[]{"responseSchema"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"safetySettings"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath((JsonNode)parentObject, new String[]{"safetySettings"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.safetySettingFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"safetySettings"}, result);
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Transformers.tTools(Common.getValueByPath((JsonNode)parentObject, new String[]{"tools"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolFromMldev(JsonSerializable.toJsonNode(Transformers.tTool(item)), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"toolConfig"}, this.toolConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath((JsonNode)parentObject, new String[]{"toolConfig"})), toObject));
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"cachedContent"}) != null) {
            Common.setValueByPath(toObject, new String[]{"cachedContent"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath((JsonNode)parentObject, new String[]{"cachedContent"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseModalities"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseModalities"}, Common.getValueByPath(fromObject, new String[]{"responseModalities"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"speechConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speechConfig"}, this.speechConfigFromMldev(JsonSerializable.toJsonNode(Transformers.tSpeechConfig(Common.getValueByPath(fromObject, new String[]{"speechConfig"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingConfig"}, this.thinkingConfigFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"thinkingConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedRequestFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"request", "model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"request", "model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"request", "contents"}) != null) {
            ArrayNode keyArray = (ArrayNode)Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"request", "contents"}));
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.contentFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"contents"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"request", "generationConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.generateContentConfigFromMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"request", "generationConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceFromMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fileName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileName"}, Common.getValueByPath(fromObject, new String[]{"fileName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"requests", "requests"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"requests", "requests"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.inlinedRequestFromMldev(apiClient, JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"inlinedRequests"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode citationMetadataFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"citationSources"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citations"}, Common.getValueByPath(fromObject, new String[]{"citationSources"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlMetadataFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievedUrl"}, Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlRetrievalStatus"}, Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextMetadataFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"urlMetadata"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"urlMetadata"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.urlMetadataFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"urlMetadata"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode candidateFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"content"}) != null) {
            Common.setValueByPath(toObject, new String[]{"content"}, this.contentFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"content"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"citationMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citationMetadata"}, this.citationMetadataFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"citationMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tokenCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"tokenCount"}, Common.getValueByPath(fromObject, new String[]{"tokenCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishReason"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishReason"}, Common.getValueByPath(fromObject, new String[]{"finishReason"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContextMetadata"}, this.urlContextMetadataFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"avgLogprobs"}, Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"groundingMetadata"}, Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"index"}) != null) {
            Common.setValueByPath(toObject, new String[]{"index"}, Common.getValueByPath(fromObject, new String[]{"index"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobsResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobsResult"}, Common.getValueByPath(fromObject, new String[]{"logprobsResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetyRatings"}) != null) {
            Common.setValueByPath(toObject, new String[]{"safetyRatings"}, Common.getValueByPath(fromObject, new String[]{"safetyRatings"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"candidates"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"candidates"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.candidateFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"candidates"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelVersion"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelVersion"}, Common.getValueByPath(fromObject, new String[]{"modelVersion"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"promptFeedback"}) != null) {
            Common.setValueByPath(toObject, new String[]{"promptFeedback"}, Common.getValueByPath(fromObject, new String[]{"promptFeedback"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateContentResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, this.jobErrorFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"error"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"responsesFile"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileName"}, Common.getValueByPath(fromObject, new String[]{"responsesFile"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlinedResponses", "inlinedResponses"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"inlinedResponses", "inlinedResponses"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.inlinedResponseFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"inlinedResponses"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"metadata", "displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "state"}) != null) {
            Common.setValueByPath(toObject, new String[]{"state"}, Transformers.tJobState(Common.getValueByPath(fromObject, new String[]{"metadata", "state"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"metadata", "createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"metadata", "endTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "updateTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"updateTime"}, Common.getValueByPath(fromObject, new String[]{"metadata", "updateTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Common.getValueByPath(fromObject, new String[]{"metadata", "model"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata", "output"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dest"}, this.batchJobDestinationFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"metadata", "output"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"operations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"operations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.batchJobFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"batchJobs"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteResourceJobFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, this.jobErrorFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"error"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode jobErrorFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"details"}) != null) {
            Common.setValueByPath(toObject, new String[]{"details"}, Common.getValueByPath(fromObject, new String[]{"details"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"code"}) != null) {
            Common.setValueByPath(toObject, new String[]{"code"}, Common.getValueByPath(fromObject, new String[]{"code"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"message"}) != null) {
            Common.setValueByPath(toObject, new String[]{"message"}, Common.getValueByPath(fromObject, new String[]{"message"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoMetadataFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"fps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fps"}, Common.getValueByPath(fromObject, new String[]{"fps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endOffset"}, Common.getValueByPath(fromObject, new String[]{"endOffset"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startOffset"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startOffset"}, Common.getValueByPath(fromObject, new String[]{"startOffset"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, this.videoMetadataFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"videoMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, Common.getValueByPath(fromObject, new String[]{"functionCall"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode schemaFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"anyOf"}) != null) {
            Common.setValueByPath(toObject, new String[]{"anyOf"}, Common.getValueByPath(fromObject, new String[]{"anyOf"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"default"}) != null) {
            Common.setValueByPath(toObject, new String[]{"default"}, Common.getValueByPath(fromObject, new String[]{"default"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enum"}, Common.getValueByPath(fromObject, new String[]{"enum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"example"}) != null) {
            Common.setValueByPath(toObject, new String[]{"example"}, Common.getValueByPath(fromObject, new String[]{"example"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"format"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"format"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"items"}) != null) {
            Common.setValueByPath(toObject, new String[]{"items"}, Common.getValueByPath(fromObject, new String[]{"items"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxItems"}, Common.getValueByPath(fromObject, new String[]{"maxItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxLength"}, Common.getValueByPath(fromObject, new String[]{"maxLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxProperties"}, Common.getValueByPath(fromObject, new String[]{"maxProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maximum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maximum"}, Common.getValueByPath(fromObject, new String[]{"maximum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minItems"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minItems"}, Common.getValueByPath(fromObject, new String[]{"minItems"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minLength"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minLength"}, Common.getValueByPath(fromObject, new String[]{"minLength"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minProperties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minProperties"}, Common.getValueByPath(fromObject, new String[]{"minProperties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"minimum"}) != null) {
            Common.setValueByPath(toObject, new String[]{"minimum"}, Common.getValueByPath(fromObject, new String[]{"minimum"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nullable"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nullable"}, Common.getValueByPath(fromObject, new String[]{"nullable"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pattern"}) != null) {
            Common.setValueByPath(toObject, new String[]{"pattern"}, Common.getValueByPath(fromObject, new String[]{"pattern"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"properties"}) != null) {
            Common.setValueByPath(toObject, new String[]{"properties"}, Common.getValueByPath(fromObject, new String[]{"properties"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}) != null) {
            Common.setValueByPath(toObject, new String[]{"propertyOrdering"}, Common.getValueByPath(fromObject, new String[]{"propertyOrdering"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"required"}) != null) {
            Common.setValueByPath(toObject, new String[]{"required"}, Common.getValueByPath(fromObject, new String[]{"required"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"title"}) != null) {
            Common.setValueByPath(toObject, new String[]{"title"}, Common.getValueByPath(fromObject, new String[]{"title"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"type"}) != null) {
            Common.setValueByPath(toObject, new String[]{"type"}, Common.getValueByPath(fromObject, new String[]{"type"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode modelSelectionConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"featureSelectionPreference"}) != null) {
            Common.setValueByPath(toObject, new String[]{"featureSelectionPreference"}, Common.getValueByPath(fromObject, new String[]{"featureSelectionPreference"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode safetySettingFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"method"}) != null) {
            Common.setValueByPath(toObject, new String[]{"method"}, Common.getValueByPath(fromObject, new String[]{"method"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"category"}) != null) {
            Common.setValueByPath(toObject, new String[]{"category"}, Common.getValueByPath(fromObject, new String[]{"category"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"threshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"threshold"}, Common.getValueByPath(fromObject, new String[]{"threshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode intervalFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, this.intervalFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode dynamicRetrievalConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicThreshold"}, Common.getValueByPath(fromObject, new String[]{"dynamicThreshold"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchRetrievalFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dynamicRetrievalConfig"}, this.dynamicRetrievalConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"dynamicRetrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode enterpriseWebSearchFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode apiKeyConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"apiKeyString"}) != null) {
            Common.setValueByPath(toObject, new String[]{"apiKeyString"}, Common.getValueByPath(fromObject, new String[]{"apiKeyString"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode authConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"apiKeyConfig"}, this.apiKeyConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"apiKeyConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"authType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authType"}, Common.getValueByPath(fromObject, new String[]{"authType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleServiceAccountConfig"}, Common.getValueByPath(fromObject, new String[]{"googleServiceAccountConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"httpBasicAuthConfig"}, Common.getValueByPath(fromObject, new String[]{"httpBasicAuthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oauthConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oauthConfig"}, Common.getValueByPath(fromObject, new String[]{"oauthConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"oidcConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"oidcConfig"}, Common.getValueByPath(fromObject, new String[]{"oidcConfig"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"authConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"authConfig"}, this.authConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"authConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrieval"}, Common.getValueByPath(fromObject, new String[]{"retrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, this.googleSearchRetrievalFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enterpriseWebSearch"}, this.enterpriseWebSearchFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, this.googleMapsFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleMaps"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, this.urlContextFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContext"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode latLngFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latitude"}, Common.getValueByPath(fromObject, new String[]{"latitude"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"longitude"}) != null) {
            Common.setValueByPath(toObject, new String[]{"longitude"}, Common.getValueByPath(fromObject, new String[]{"longitude"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode retrievalConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"latLng"}) != null) {
            Common.setValueByPath(toObject, new String[]{"latLng"}, this.latLngFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"latLng"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, this.retrievalConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"retrievalConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode prebuiltVoiceConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceName"}, Common.getValueByPath(fromObject, new String[]{"voiceName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode voiceConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"prebuiltVoiceConfig"}, this.prebuiltVoiceConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"prebuiltVoiceConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speakerVoiceConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode multiSpeakerVoiceConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode speechConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"voiceConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"voiceConfig"}, this.voiceConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"voiceConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"languageCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"languageCode"}, Common.getValueByPath(fromObject, new String[]{"languageCode"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode thinkingConfigFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"includeThoughts"}) != null) {
            Common.setValueByPath(toObject, new String[]{"includeThoughts"}, Common.getValueByPath(fromObject, new String[]{"includeThoughts"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingBudget"}, Common.getValueByPath(fromObject, new String[]{"thinkingBudget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentConfigFromVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(toObject, new String[]{"systemInstruction"}, this.contentFromVertex(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath((JsonNode)parentObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"temperature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"temperature"}, Common.getValueByPath(fromObject, new String[]{"temperature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topP"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topP"}, Common.getValueByPath(fromObject, new String[]{"topP"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topK"}) != null) {
            Common.setValueByPath(toObject, new String[]{"topK"}, Common.getValueByPath(fromObject, new String[]{"topK"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"candidateCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"candidateCount"}, Common.getValueByPath(fromObject, new String[]{"candidateCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}) != null) {
            Common.setValueByPath(toObject, new String[]{"maxOutputTokens"}, Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"stopSequences"}) != null) {
            Common.setValueByPath(toObject, new String[]{"stopSequences"}, Common.getValueByPath(fromObject, new String[]{"stopSequences"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseLogprobs"}, Common.getValueByPath(fromObject, new String[]{"responseLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobs"}, Common.getValueByPath(fromObject, new String[]{"logprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"presencePenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"presencePenalty"}, Common.getValueByPath(fromObject, new String[]{"presencePenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}) != null) {
            Common.setValueByPath(toObject, new String[]{"frequencyPenalty"}, Common.getValueByPath(fromObject, new String[]{"frequencyPenalty"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"seed"}) != null) {
            Common.setValueByPath(toObject, new String[]{"seed"}, Common.getValueByPath(fromObject, new String[]{"seed"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseMimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseMimeType"}, Common.getValueByPath(fromObject, new String[]{"responseMimeType"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseSchema"}, this.schemaFromVertex(JsonSerializable.toJsonNode(Transformers.tSchema(Common.getValueByPath(fromObject, new String[]{"responseSchema"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"routingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"routingConfig"}, Common.getValueByPath(fromObject, new String[]{"routingConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelSelectionConfig"}, this.modelSelectionConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"modelConfig"})), toObject));
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"safetySettings"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath((JsonNode)parentObject, new String[]{"safetySettings"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.safetySettingFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"safetySettings"}, result);
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Transformers.tTools(Common.getValueByPath((JsonNode)parentObject, new String[]{"tools"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolFromVertex(JsonSerializable.toJsonNode(Transformers.tTool(item)), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"toolConfig"}, this.toolConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath((JsonNode)parentObject, new String[]{"toolConfig"})), toObject));
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"labels"}) != null) {
            Common.setValueByPath(toObject, new String[]{"labels"}, Common.getValueByPath((JsonNode)parentObject, new String[]{"labels"}));
        }
        if (Common.getValueByPath((JsonNode)parentObject, new String[]{"cachedContent"}) != null) {
            Common.setValueByPath(toObject, new String[]{"cachedContent"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath((JsonNode)parentObject, new String[]{"cachedContent"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseModalities"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseModalities"}, Common.getValueByPath(fromObject, new String[]{"responseModalities"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"speechConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"speechConfig"}, this.speechConfigFromVertex(JsonSerializable.toJsonNode(Transformers.tSpeechConfig(Common.getValueByPath(fromObject, new String[]{"speechConfig"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"audioTimestamp"}) != null) {
            Common.setValueByPath(toObject, new String[]{"audioTimestamp"}, Common.getValueByPath(fromObject, new String[]{"audioTimestamp"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thinkingConfig"}, this.thinkingConfigFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"thinkingConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedRequestFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobSourceFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"instancesFormat"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"instancesFormat"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsSource", "uris"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsUri"}, Common.getValueByPath(fromObject, new String[]{"gcsSource", "uris"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigquerySource", "inputUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigqueryUri"}, Common.getValueByPath(fromObject, new String[]{"bigquerySource", "inputUri"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode citationMetadataFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"citations"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citations"}, Common.getValueByPath(fromObject, new String[]{"citations"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlMetadataFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievedUrl"}, Common.getValueByPath(fromObject, new String[]{"retrievedUrl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlRetrievalStatus"}, Common.getValueByPath(fromObject, new String[]{"urlRetrievalStatus"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode urlContextMetadataFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"urlMetadata"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"urlMetadata"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.urlMetadataFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"urlMetadata"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode candidateFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"content"}) != null) {
            Common.setValueByPath(toObject, new String[]{"content"}, this.contentFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"content"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"citationMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"citationMetadata"}, this.citationMetadataFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"citationMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishMessage"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishMessage"}, Common.getValueByPath(fromObject, new String[]{"finishMessage"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"finishReason"}) != null) {
            Common.setValueByPath(toObject, new String[]{"finishReason"}, Common.getValueByPath(fromObject, new String[]{"finishReason"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContextMetadata"}, this.urlContextMetadataFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"urlContextMetadata"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}) != null) {
            Common.setValueByPath(toObject, new String[]{"avgLogprobs"}, Common.getValueByPath(fromObject, new String[]{"avgLogprobs"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"groundingMetadata"}, Common.getValueByPath(fromObject, new String[]{"groundingMetadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"index"}) != null) {
            Common.setValueByPath(toObject, new String[]{"index"}, Common.getValueByPath(fromObject, new String[]{"index"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"logprobsResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"logprobsResult"}, Common.getValueByPath(fromObject, new String[]{"logprobsResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"safetyRatings"}) != null) {
            Common.setValueByPath(toObject, new String[]{"safetyRatings"}, Common.getValueByPath(fromObject, new String[]{"safetyRatings"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateContentResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"candidates"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"candidates"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.candidateFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"candidates"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseId"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseId"}, Common.getValueByPath(fromObject, new String[]{"responseId"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"modelVersion"}) != null) {
            Common.setValueByPath(toObject, new String[]{"modelVersion"}, Common.getValueByPath(fromObject, new String[]{"modelVersion"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"promptFeedback"}) != null) {
            Common.setValueByPath(toObject, new String[]{"promptFeedback"}, Common.getValueByPath(fromObject, new String[]{"promptFeedback"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"usageMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"usageMetadata"}, Common.getValueByPath(fromObject, new String[]{"usageMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode inlinedResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobDestinationFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"predictionsFormat"}) != null) {
            Common.setValueByPath(toObject, new String[]{"format"}, Common.getValueByPath(fromObject, new String[]{"predictionsFormat"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"gcsDestination", "outputUriPrefix"}) != null) {
            Common.setValueByPath(toObject, new String[]{"gcsUri"}, Common.getValueByPath(fromObject, new String[]{"gcsDestination", "outputUriPrefix"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bigqueryDestination", "outputUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"bigqueryUri"}, Common.getValueByPath(fromObject, new String[]{"bigqueryDestination", "outputUri"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode batchJobFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"state"}) != null) {
            Common.setValueByPath(toObject, new String[]{"state"}, Transformers.tJobState(Common.getValueByPath(fromObject, new String[]{"state"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, this.jobErrorFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"error"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"createTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"createTime"}, Common.getValueByPath(fromObject, new String[]{"createTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"startTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"startTime"}, Common.getValueByPath(fromObject, new String[]{"startTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"endTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"endTime"}, Common.getValueByPath(fromObject, new String[]{"endTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"updateTime"}) != null) {
            Common.setValueByPath(toObject, new String[]{"updateTime"}, Common.getValueByPath(fromObject, new String[]{"updateTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Common.getValueByPath(fromObject, new String[]{"model"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inputConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"src"}, this.batchJobSourceFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inputConfig"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"outputConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"dest"}, this.batchJobDestinationFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"outputConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listBatchJobsResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"batchPredictionJobs"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"batchPredictionJobs"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.batchJobFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"batchJobs"}, result);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteResourceJobFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper.createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, this.jobErrorFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"error"})), toObject));
        }
        return toObject;
    }

    BatchJob privateCreate(String model, BatchJobSource src, CreateBatchJobConfig config) {
        String path;
        ObjectNode body;
        CreateBatchJobParameters.Builder parameterBuilder = CreateBatchJobParameters.builder();
        if (!Common.isZero(model)) {
            parameterBuilder.model(model);
        }
        if (!Common.isZero(src)) {
            parameterBuilder.src(src);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.createBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs", body.get("_url"));
        } else {
            body = this.createBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{model}:batchGenerateContent", body.get("_url")) : "{model}:batchGenerateContent";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("post", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            ResponseBody responseBody = response.getBody();
            try {
                responseString = responseBody.string();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.batchJobFromVertex(responseNode, null) : this.batchJobFromMldev(responseNode, null);
            BatchJob batchJob = JsonSerializable.fromJsonNode(responseNode, BatchJob.class);
            return batchJob;
        }
    }

    public BatchJob get(String name, GetBatchJobConfig config) {
        String path;
        ObjectNode body;
        GetBatchJobParameters.Builder parameterBuilder = GetBatchJobParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.getBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs/{name}", body.get("_url"));
        } else {
            body = this.getBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches/{name}", body.get("_url")) : "batches/{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("get", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            ResponseBody responseBody = response.getBody();
            try {
                responseString = responseBody.string();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.batchJobFromVertex(responseNode, null) : this.batchJobFromMldev(responseNode, null);
            BatchJob batchJob = JsonSerializable.fromJsonNode(responseNode, BatchJob.class);
            return batchJob;
        }
    }

    public void cancel(String name, CancelBatchJobConfig config) {
        String path;
        ObjectNode body;
        CancelBatchJobParameters.Builder parameterBuilder = CancelBatchJobParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.cancelBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs/{name}:cancel", body.get("_url"));
        } else {
            body = this.cancelBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches/{name}:cancel", body.get("_url")) : "batches/{name}:cancel";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        this.apiClient.request("post", path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ListBatchJobsResponse privateList(ListBatchJobsConfig config) {
        String path;
        ObjectNode body;
        ListBatchJobsParameters.Builder parameterBuilder = ListBatchJobsParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.listBatchJobsParametersToVertex(parameterNode, null);
            path = Common.formatMap("batchPredictionJobs", body.get("_url"));
        } else {
            body = this.listBatchJobsParametersToMldev(parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches", body.get("_url")) : "batches";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("get", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            ResponseBody responseBody = response.getBody();
            try {
                responseString = responseBody.string();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.listBatchJobsResponseFromVertex(responseNode, null) : this.listBatchJobsResponseFromMldev(responseNode, null);
            ListBatchJobsResponse listBatchJobsResponse = JsonSerializable.fromJsonNode(responseNode, ListBatchJobsResponse.class);
            return listBatchJobsResponse;
        }
    }

    public DeleteResourceJob delete(String name, DeleteBatchJobConfig config) {
        String path;
        ObjectNode body;
        DeleteBatchJobParameters.Builder parameterBuilder = DeleteBatchJobParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.deleteBatchJobParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("batchPredictionJobs/{name}", body.get("_url"));
        } else {
            body = this.deleteBatchJobParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("batches/{name}", body.get("_url")) : "batches/{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        body.remove("config");
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        try (ApiResponse response = this.apiClient.request("delete", path, JsonSerializable.toJsonString(body), requestHttpOptions);){
            String responseString;
            ResponseBody responseBody = response.getBody();
            try {
                responseString = responseBody.string();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read HTTP response.", e);
            }
            JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
            responseNode = this.apiClient.vertexAI() ? this.deleteResourceJobFromVertex(responseNode, null) : this.deleteResourceJobFromMldev(responseNode, null);
            DeleteResourceJob deleteResourceJob = JsonSerializable.fromJsonNode(responseNode, DeleteResourceJob.class);
            return deleteResourceJob;
        }
    }

    public BatchJob create(String model, BatchJobSource src, CreateBatchJobConfig config) {
        if (this.apiClient.vertexAI()) {
            if (src.gcsUri().isPresent() && src.bigqueryUri().isPresent()) {
                throw new GenAiIOException("Only one of gcsUri and bigqueryUri can be set.");
            }
            if (!src.gcsUri().isPresent() && !src.bigqueryUri().isPresent()) {
                throw new GenAiIOException("One of gcsUri and bigqueryUri must be set.");
            }
        } else {
            if (src.fileName().isPresent() && src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("Only one of fileName and InlinedRequests can be set.");
            }
            if (!src.fileName().isPresent() && !src.inlinedRequests().isPresent()) {
                throw new GenAiIOException("One of fileName and InlinedRequests must be set.");
            }
        }
        return this.privateCreate(model, src, config);
    }

    public Pager<BatchJob> list(ListBatchJobsConfig config) {
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListBatchJobsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListBatchJobsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListBatchJobsConfig)requestConfig);
        };
        return new Pager<BatchJob>(BasePager.PagedItem.BATCH_JOBS, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(config)));
    }
}

