/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.AsyncModels;
import com.google.genai.ChatBase;
import com.google.genai.ResponseStream;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public class AsyncChat
extends ChatBase {
    private final ApiClient apiClient;
    private final AsyncModels models;
    private final String model;
    private final GenerateContentConfig config;
    private static final Logger logger = Logger.getLogger(AsyncChat.class.getName());

    AsyncChat(ApiClient apiClient, String model, GenerateContentConfig config) {
        super(new ArrayList<Content>(), new ArrayList<Content>());
        this.apiClient = apiClient;
        this.models = new AsyncModels(apiClient);
        this.model = model;
        this.config = config;
    }

    public CompletableFuture<GenerateContentResponse> sendMessage(String text, GenerateContentConfig config) {
        return this.privateSendMessage((List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<GenerateContentResponse> sendMessage(String text) {
        return this.privateSendMessage((List<Content>)Transformers.tContents(text), null);
    }

    public CompletableFuture<GenerateContentResponse> sendMessage(Content content, GenerateContentConfig config) {
        return this.privateSendMessage((List<Content>)Transformers.tContents(content), config);
    }

    public CompletableFuture<GenerateContentResponse> sendMessage(Content content) {
        return this.privateSendMessage((List<Content>)Transformers.tContents(content), null);
    }

    public CompletableFuture<GenerateContentResponse> sendMessage(List<Content> contents, GenerateContentConfig config) {
        return this.privateSendMessage(contents, config);
    }

    public CompletableFuture<GenerateContentResponse> sendMessage(List<Content> contents) {
        return this.privateSendMessage(contents, null);
    }

    private CompletableFuture<GenerateContentResponse> privateSendMessage(List<Content> contents, GenerateContentConfig config) {
        List<Content> requestContents = this.prepareSendMessageRequest(contents);
        if (this.config != null && config == null) {
            config = this.config;
        }
        GenerateContentConfig finalConfig = config;
        CompletableFuture<GenerateContentResponse> responseFuture = this.models.generateContent(this.model, requestContents, finalConfig);
        return ((CompletableFuture)responseFuture.thenApply(response -> {
            this.updateHistoryNonStreaming((GenerateContentResponse)response, contents);
            return response;
        })).exceptionally(exception -> {
            logger.warning("Async chat response failed with exception: " + exception);
            throw new GenAiIOException((Throwable)exception);
        });
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> sendMessageStream(String text, GenerateContentConfig config) {
        return this.privateSendMessageStream((List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> sendMessageStream(String text) {
        return this.privateSendMessageStream((List<Content>)Transformers.tContents(text), null);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> sendMessageStream(Content content, GenerateContentConfig config) {
        return this.privateSendMessageStream((List<Content>)Transformers.tContents(content), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> sendMessageStream(Content content) {
        return this.privateSendMessageStream((List<Content>)Transformers.tContents(content), null);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> sendMessageStream(List<Content> contents, GenerateContentConfig config) {
        return this.privateSendMessageStream(contents, config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> sendMessageStream(List<Content> contents) {
        return this.privateSendMessageStream(contents, null);
    }

    private CompletableFuture<ResponseStream<GenerateContentResponse>> privateSendMessageStream(List<Content> contents, GenerateContentConfig config) {
        List<Content> requestContents = this.prepareSendMessageRequest(contents);
        if (this.config != null && config == null) {
            config = this.config;
        }
        CompletableFuture<ResponseStream<GenerateContentResponse>> responseStreamFuture = this.models.generateContentStream(this.model, requestContents, config);
        return ((CompletableFuture)responseStreamFuture.thenApply(resolvedResponseStream -> {
            resolvedResponseStream.recordingHistory = true;
            resolvedResponseStream.asyncChatSession = this;
            this.currentUserMessage = contents;
            this.currentResponseStream = resolvedResponseStream;
            return resolvedResponseStream;
        })).exceptionally(exception -> {
            logger.warning("Async streaming chat response failed with exception: " + exception);
            throw new GenAiIOException((Throwable)exception);
        });
    }
}

