/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.AsyncPager;
import com.google.genai.BasePager;
import com.google.genai.JsonSerializable;
import com.google.genai.Models;
import com.google.genai.ResponseStream;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.ComputeTokensConfig;
import com.google.genai.types.ComputeTokensResponse;
import com.google.genai.types.Content;
import com.google.genai.types.CountTokensConfig;
import com.google.genai.types.CountTokensResponse;
import com.google.genai.types.DeleteModelConfig;
import com.google.genai.types.DeleteModelResponse;
import com.google.genai.types.EditImageConfig;
import com.google.genai.types.EditImageResponse;
import com.google.genai.types.EmbedContentConfig;
import com.google.genai.types.EmbedContentResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.GenerateImagesConfig;
import com.google.genai.types.GenerateImagesResponse;
import com.google.genai.types.GenerateVideosConfig;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.GetModelConfig;
import com.google.genai.types.Image;
import com.google.genai.types.ListModelsConfig;
import com.google.genai.types.Model;
import com.google.genai.types.ReferenceImage;
import com.google.genai.types.UpdateModelConfig;
import com.google.genai.types.UpscaleImageConfig;
import com.google.genai.types.UpscaleImageResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class AsyncModels {
    Models models;

    public AsyncModels(ApiClient apiClient) {
        this.models = new Models(apiClient);
    }

    public CompletableFuture<Model> get(String model, GetModelConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.get(model, config));
    }

    public CompletableFuture<Model> update(String model, UpdateModelConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.update(model, config));
    }

    public CompletableFuture<DeleteModelResponse> delete(String model, DeleteModelConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.delete(model, config));
    }

    public CompletableFuture<CountTokensResponse> countTokens(String model, List<Content> contents, CountTokensConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.countTokens(model, contents, config));
    }

    public CompletableFuture<ComputeTokensResponse> computeTokens(String model, List<Content> contents, ComputeTokensConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.computeTokens(model, contents, config));
    }

    public CompletableFuture<GenerateVideosOperation> generateVideos(String model, String prompt, Image image, GenerateVideosConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateVideos(model, prompt, image, config));
    }

    public CompletableFuture<CountTokensResponse> countTokens(String model, String text, CountTokensConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.countTokens(model, text, config));
    }

    public CompletableFuture<ComputeTokensResponse> computeTokens(String model, String text, ComputeTokensConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.computeTokens(model, text, config));
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, List<Content> contents, GenerateContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateContent(model, contents, config));
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, Content content, GenerateContentConfig config) {
        return this.generateContent(model, (List<Content>)Transformers.tContents(content), config);
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, String text, GenerateContentConfig config) {
        return this.generateContent(model, (List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, List<Content> contents, GenerateContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateContentStream(model, contents, config));
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, Content content, GenerateContentConfig config) {
        return this.generateContentStream(model, (List<Content>)Transformers.tContents(content), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, String text, GenerateContentConfig config) {
        return this.generateContentStream(model, (List<Content>)Transformers.tContents(text), config);
    }

    public CompletableFuture<GenerateImagesResponse> generateImages(String model, String prompt, GenerateImagesConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateImages(model, prompt, config));
    }

    public CompletableFuture<EditImageResponse> editImage(String model, String prompt, List<ReferenceImage> referenceImages, EditImageConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.editImage(model, prompt, referenceImages, config));
    }

    public CompletableFuture<UpscaleImageResponse> upscaleImage(String model, Image image, String upscaleFactor, UpscaleImageConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.upscaleImage(model, image, upscaleFactor, config));
    }

    public CompletableFuture<EmbedContentResponse> embedContent(String model, String text, EmbedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.embedContent(model, text, config));
    }

    public CompletableFuture<EmbedContentResponse> embedContent(String model, List<String> texts, EmbedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.embedContent(model, texts, config));
    }

    public CompletableFuture<AsyncPager<Model>> list(ListModelsConfig config) {
        if (config == null) {
            config = ListModelsConfig.builder().build();
        }
        if (config.filter().isPresent()) {
            throw new IllegalArgumentException("Filter is currently not supported for list models.");
        }
        ListModelsConfig.Builder configBuilder = config.toBuilder();
        if (!config.queryBase().isPresent()) {
            configBuilder.queryBase(true);
        } else if (!config.queryBase().get().booleanValue() && this.models.apiClient.vertexAI()) {
            configBuilder.filter("labels.tune-type:*");
        }
        ListModelsConfig updatedConfig = configBuilder.build();
        Function<JsonSerializable, CompletableFuture> request = requestConfig -> {
            if (!(requestConfig instanceof ListModelsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListModelsConfig but received " + requestConfig.getClass().getName());
            }
            return CompletableFuture.supplyAsync(() -> JsonSerializable.toJsonNode(this.models.privateList((ListModelsConfig)requestConfig)));
        };
        return CompletableFuture.supplyAsync(() -> new AsyncPager(BasePager.PagedItem.MODELS, request, (ObjectNode)JsonSerializable.toJsonNode(updatedConfig), (CompletableFuture)request.apply(updatedConfig)));
    }
}

