/* Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.firebase.projectmanagement;

/**
 * Enum denoting types of SHA certificates currently supported by Firebase.
 */
public enum ShaCertificateType {
  /** Certificate generated by SHA-1 hashing algorithm. */
  SHA_1,
  /** Certificate generated by SHA-256 hashing algorithm. */
  SHA_256
}
