/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;

final class ComponentTreeDepsGenerator {
    private final Set<ClassName> generatedProxies = new HashSet<ClassName>();
    private final XProcessingEnv env;
    private final XFiler.Mode mode;

    ComponentTreeDepsGenerator(XProcessingEnv env, XFiler.Mode mode) {
        this.env = env;
        this.mode = mode;
    }

    void generate(ComponentTreeDepsMetadata metadata) throws IOException {
        ClassName name = metadata.name();
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name).addAnnotation(this.componentTreeDepsAnnotation(metadata));
        Processors.addGeneratedAnnotation(builder, this.env, ClassNames.ROOT_PROCESSOR.toString());
        this.env.getFiler().write(JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).build(), this.mode);
    }

    AnnotationSpec componentTreeDepsAnnotation(ComponentTreeDepsMetadata metadata) throws IOException {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.COMPONENT_TREE_DEPS);
        this.addDeps(builder, metadata.aggregatedRootDeps(), "rootDeps");
        this.addDeps(builder, metadata.defineComponentDeps(), "defineComponentDeps");
        this.addDeps(builder, metadata.aliasOfDeps(), "aliasOfDeps");
        this.addDeps(builder, metadata.aggregatedDeps(), "aggregatedDeps");
        this.addDeps(builder, metadata.aggregatedUninstallModulesDeps(), "uninstallModulesDeps");
        this.addDeps(builder, metadata.aggregatedEarlyEntryPointDeps(), "earlyEntryPointDeps");
        return builder.build();
    }

    private void addDeps(AnnotationSpec.Builder builder, ImmutableSet<XTypeElement> deps, String name) throws IOException {
        for (XTypeElement dep : deps) {
            builder.addMember(name, "$T.class", new Object[]{this.maybeWrapInPublicProxy(dep)});
        }
    }

    private ClassName maybeWrapInPublicProxy(XTypeElement dep) {
        Optional<ClassName> proxyName = AggregatedElements.aggregatedElementProxyName(dep);
        if (proxyName.isPresent()) {
            if (this.generatedProxies.add(proxyName.get()) && this.env.findTypeElement(proxyName.get().canonicalName()) == null) {
                this.generateProxy(dep, proxyName.get());
            }
            return proxyName.get();
        }
        return dep.getClassName();
    }

    private void generateProxy(XTypeElement dep, ClassName proxyName) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)proxyName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.AGGREGATED_ELEMENT_PROXY).addMember("value", "$T.class", new Object[]{dep.getClassName()}).build());
        Processors.addGeneratedAnnotation(builder, this.env, ClassNames.ROOT_PROCESSOR.toString());
        this.env.getFiler().write(JavaFile.builder((String)proxyName.packageName(), (TypeSpec)builder.build()).build(), this.mode);
    }
}

