/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.ActivityGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.ApplicationGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.BroadcastReceiverGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.FragmentGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.InjectorEntryPointGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.ServiceGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.ViewGenerator;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.optionvalues.GradleProjectType;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public final class AndroidEntryPointProcessor
extends BaseProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AndroidClassNames.ANDROID_ENTRY_POINT.toString(), (Object)AndroidClassNames.HILT_ANDROID_APP.toString());
    }

    @Override
    public boolean delayErrors() {
        return true;
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        AndroidEntryPointMetadata metadata = AndroidEntryPointMetadata.of(this.getProcessingEnv(), element);
        new InjectorEntryPointGenerator(this.getProcessingEnv(), metadata).generate();
        switch (metadata.androidType()) {
            case APPLICATION: {
                GradleProjectType projectType = HiltCompilerOptions.getGradleProjectType(this.getProcessingEnv());
                if (projectType != GradleProjectType.UNSET) {
                    ProcessorErrors.checkState(projectType == GradleProjectType.APP, element, (Object)"Application class annotated with @HiltAndroidApp has to be defined in an android application project");
                }
                if (HiltCompilerOptions.useAggregatingRootProcessor(this.getProcessingEnv())) {
                    new ApplicationGenerator(this.getProcessingEnv(), metadata).generate();
                    break;
                }
                ProcessorErrors.checkState(metadata.requiresBytecodeInjection(), metadata.element(), "'enableAggregatingTask=true' cannot be used when the application directly references the generated Hilt class, %s. Either extend %s directly (relying on the Gradle plugin described in https://dagger.dev/hilt/gradle-setup#why-use-the-plugin or set 'enableAggregatingTask=false'.", metadata.generatedClassName(), metadata.baseClassName());
                break;
            }
            case ACTIVITY: {
                new ActivityGenerator(this.getProcessingEnv(), metadata).generate();
                break;
            }
            case BROADCAST_RECEIVER: {
                new BroadcastReceiverGenerator(this.getProcessingEnv(), metadata).generate();
                break;
            }
            case FRAGMENT: {
                new FragmentGenerator(this.getProcessingEnv(), metadata).generate();
                break;
            }
            case SERVICE: {
                new ServiceGenerator(this.getProcessingEnv(), metadata).generate();
                break;
            }
            case VIEW: {
                new ViewGenerator(this.getProcessingEnv(), metadata).generate();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Hilt type: " + (Object)((Object)metadata.androidType()));
            }
        }
    }
}

