/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import java.util.Optional;

final class GwtCompatibility {
    GwtCompatibility() {
    }

    static Optional<XAnnotationSpec> gwtIncompatibleAnnotation(Binding binding) {
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        for (XElement element = binding.bindingElement().get(); element != null; element = element.getEnclosingElement()) {
            Optional<XAnnotationSpec> gwtIncompatible = element.getAllAnnotations().stream().filter(GwtCompatibility::isGwtIncompatible).map(XAnnotations::asClassName).map(XAnnotationSpec::of).findFirst();
            if (!gwtIncompatible.isPresent()) continue;
            return gwtIncompatible;
        }
        return Optional.empty();
    }

    private static boolean isGwtIncompatible(XAnnotation annotation) {
        return XAnnotations.getClassName(annotation).simpleName().contentEquals("GwtIncompatible");
    }
}

