/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.ksp.symbol.Origin;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;

public final class XTypeElements {
    public static ImmutableList<TypeVariableName> typeVariableNames(XTypeElement typeElement) {
        return (ImmutableList)typeElement.getTypeParameters().stream().map(XTypeParameterElement::getTypeVariableName).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isNested(XTypeElement typeElement) {
        return typeElement.getEnclosingTypeElement() != null;
    }

    public static boolean hasTypeParameters(XTypeElement typeElement) {
        return !typeElement.getTypeParameters().isEmpty();
    }

    public static ImmutableList<XMethodElement> getAllUnimplementedMethods(XTypeElement type) {
        return (ImmutableList)XTypeElements.getAllNonPrivateInstanceMethods(type).stream().filter(XHasModifiers::isAbstract).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllNonPrivateInstanceMethods(XTypeElement type) {
        return (ImmutableList)XTypeElements.getAllMethods(type).stream().filter(method -> !method.isPrivate() && !method.isStatic()).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllMethods(XTypeElement type) {
        return (ImmutableList)StreamsKt.asStream((Sequence)type.getAllMethods()).filter(method -> XTypeElements.isAccessibleFrom(method, type)).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllMethodsIncludingPrivate(XTypeElement type) {
        return (ImmutableList)StreamsKt.asStream((Sequence)type.getAllMethods()).collect(DaggerStreams.toImmutableList());
    }

    private static boolean isAccessibleFrom(XMethodElement method, XTypeElement type) {
        if (method.isPublic() || method.isProtected()) {
            return true;
        }
        if (method.isPrivate()) {
            return false;
        }
        return method.getClosestMemberContainer().getClassName().packageName().equals(type.getClassName().packageName());
    }

    public static boolean isEffectivelyPublic(XTypeElement element) {
        return XTypeElements.allVisibilities(element).stream().allMatch(visibility -> visibility.equals((Object)Visibility.PUBLIC));
    }

    public static boolean isEffectivelyPrivate(XTypeElement element) {
        return XTypeElements.allVisibilities(element).contains((Object)Visibility.PRIVATE);
    }

    public static boolean isJvmClass(XTypeElement element) {
        return element.isClass() || element.isKotlinObject() || element.isCompanionObject();
    }

    private static ImmutableSet<Visibility> allVisibilities(XTypeElement element) {
        Preconditions.checkNotNull((Object)element);
        ImmutableSet.Builder visibilities = ImmutableSet.builder();
        for (XTypeElement currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingTypeElement()) {
            visibilities.add((Object)Visibility.of(currentElement));
        }
        return visibilities.build();
    }

    public static boolean isKotlinSource(XTypeElement typeElement) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XElement)typeElement);
        switch (processingEnv.getBackend()) {
            case KSP: {
                Origin origin = XConverters.toKS((XTypeElement)typeElement).getOrigin();
                return origin == Origin.KOTLIN || origin == Origin.KOTLIN_LIB;
            }
            case JAVAC: {
                return typeElement.hasAnnotation(ClassName.get((String)"kotlin", (String)"Metadata", (String[])new String[0]));
            }
        }
        throw new AssertionError((Object)("Unhandled backend kind: " + processingEnv.getBackend()));
    }

    private XTypeElements() {
    }

    private static enum Visibility {
        PUBLIC,
        PRIVATE,
        OTHER;


        private static Visibility of(XTypeElement element) {
            Preconditions.checkNotNull((Object)element);
            if (element.isPrivate()) {
                return PRIVATE;
            }
            if (element.isPublic()) {
                return PUBLIC;
            }
            return OTHER;
        }
    }
}

