/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.ExpressionType;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

abstract class FrameworkInstanceRequestRepresentation
extends RequestRepresentation {
    private final ContributionBinding binding;
    private final FrameworkInstanceSupplier frameworkInstanceSupplier;
    private final XProcessingEnv processingEnv;

    FrameworkInstanceRequestRepresentation(ContributionBinding binding, FrameworkInstanceSupplier frameworkInstanceSupplier, XProcessingEnv processingEnv) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.frameworkInstanceSupplier = (FrameworkInstanceSupplier)Preconditions.checkNotNull((Object)frameworkInstanceSupplier);
        this.processingEnv = (XProcessingEnv)Preconditions.checkNotNull((Object)processingEnv);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        MemberSelect memberSelect = this.frameworkInstanceSupplier.memberSelect();
        XType expressionType = XProcessingEnvs.wrapType(this.frameworkType().frameworkClassName(), this.binding.contributedType(), this.processingEnv);
        return Expression.create(Accessibility.isTypeAccessibleFrom(this.binding.contributedType(), requestingClass.packageName()) || FrameworkInstanceRequestRepresentation.isInlinedFactoryCreation(memberSelect) ? ExpressionType.create(expressionType) : ExpressionType.createRawType(expressionType), memberSelect.getExpressionFor(requestingClass));
    }

    protected abstract FrameworkType frameworkType();

    private static boolean isInlinedFactoryCreation(MemberSelect memberSelect) {
        return memberSelect.staticMember();
    }
}

