/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

final class ComponentHjarProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final SourceFileGenerator<ComponentDescriptor> componentGenerator;

    @Inject
    ComponentHjarProcessingStep(XMessager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorFactory componentDescriptorFactory, SourceFileGenerator<ComponentDescriptor> componentGenerator) {
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.componentGenerator = componentGenerator;
    }

    @Override
    public Set<ClassName> annotationClassNames() {
        return Sets.union(ComponentAnnotation.rootComponentAnnotations(), ComponentCreatorAnnotation.rootComponentCreatorAnnotations());
    }

    @Override
    protected void process(XTypeElement element, ImmutableSet<ClassName> annotations) {
        if (!Collections.disjoint(annotations, ComponentAnnotation.rootComponentAnnotations())) {
            this.processRootComponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentCreatorAnnotation.rootComponentCreatorAnnotations())) {
            this.processRootCreator(element);
        }
    }

    private void processRootComponent(XTypeElement element) {
        ValidationReport validationReport = this.componentValidator.validate(element);
        validationReport.printMessagesTo(this.messager);
        if (validationReport.isClean()) {
            this.componentGenerator.generate(this.componentDescriptorFactory.rootComponentDescriptor(element), this.messager);
        }
    }

    private void processRootCreator(XTypeElement creator) {
        this.creatorValidator.validate(creator).printMessagesTo(this.messager);
    }
}

