/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XRawType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;

public final class ExpressionType {
    private final Optional<XType> optionalType;
    private final Optional<XRawType> optionalRawType;
    private final XProcessingEnv processingEnv;

    public static ExpressionType create(XType type) {
        return new ExpressionType(Optional.of(type), Optional.empty(), XConverters.getProcessingEnv((XType)type));
    }

    static ExpressionType create(XRawType type, XProcessingEnv processingEnv) {
        return new ExpressionType(Optional.empty(), Optional.of(type), processingEnv);
    }

    public static ExpressionType createRawType(XType type) {
        return ExpressionType.create(type.getRawType(), XConverters.getProcessingEnv((XType)type));
    }

    private ExpressionType(Optional<XType> optionalType, Optional<XRawType> optionalRawType, XProcessingEnv processingEnv) {
        this.optionalType = optionalType;
        this.optionalRawType = optionalRawType;
        this.processingEnv = processingEnv;
        Preconditions.checkState((optionalType.isPresent() || optionalRawType.isPresent() ? 1 : 0) != 0);
    }

    public ExpressionType unwrapType() {
        return this.optionalType.isPresent() && !XTypes.isRawParameterizedType(this.optionalType.get()) ? ExpressionType.create(XProcessingEnvs.unwrapType(this.optionalType.get())) : ExpressionType.create(this.processingEnv.requireType((TypeName)TypeName.OBJECT));
    }

    public ExpressionType wrapType(ClassName wrapper) {
        return this.optionalType.isPresent() ? ExpressionType.create(XProcessingEnvs.wrapType(wrapper, this.optionalType.get(), this.processingEnv)) : ExpressionType.createRawType(this.processingEnv.requireType((TypeName)wrapper));
    }

    public ExpressionType rewrapType(ClassName wrapper) {
        return this.optionalType.isPresent() ? ExpressionType.create(XTypes.rewrapType(this.optionalType.get(), wrapper)) : ExpressionType.createRawType(this.processingEnv.requireType((TypeName)wrapper));
    }

    public TypeName getTypeName() {
        return this.optionalType.isPresent() ? this.optionalType.get().getTypeName() : this.optionalRawType.get().getTypeName();
    }

    public boolean isSameType(XType type) {
        return this.optionalType.isPresent() ? this.optionalType.get().isSameType(type) : XTypes.isRawParameterizedType(type) && this.getTypeName().equals((Object)type.getTypeName());
    }

    public boolean isSameType(XRawType type) {
        return this.getTypeName().equals((Object)type.getTypeName());
    }

    public boolean isAssignableTo(XType type) {
        return this.optionalType.isPresent() ? type.isAssignableFrom(this.optionalType.get()) : type.getRawType().isAssignableFrom(this.optionalRawType.get());
    }

    public boolean isAssignableTo(XRawType rawType) {
        return this.optionalType.isPresent() ? rawType.isAssignableFrom(this.optionalType.get()) : rawType.isAssignableFrom(this.optionalRawType.get());
    }

    Optional<XType> asType() {
        return this.optionalType;
    }

    Optional<XRawType> asRawType() {
        return this.optionalRawType;
    }

    XProcessingEnv getProcessingEnv() {
        return this.processingEnv;
    }
}

