/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.InjectionSiteFactory;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.Nullability;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;

public final class BindingFactory {
    private final KeyFactory keyFactory;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final InjectionSiteFactory injectionSiteFactory;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    BindingFactory(KeyFactory keyFactory, DependencyRequestFactory dependencyRequestFactory, InjectionSiteFactory injectionSiteFactory, InjectionAnnotations injectionAnnotations) {
        this.keyFactory = keyFactory;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.injectionSiteFactory = injectionSiteFactory;
        this.injectionAnnotations = injectionAnnotations;
    }

    public ProvisionBinding injectionBinding(XConstructorElement constructorElement, Optional<XType> resolvedEnclosingType) {
        Preconditions.checkArgument((boolean)InjectionAnnotations.hasInjectOrAssistedInjectAnnotation((XElement)constructorElement));
        XConstructorType constructorType = constructorElement.getExecutableType();
        XType enclosingType = constructorElement.getEnclosingElement().getType();
        if (!enclosingType.getTypeArguments().isEmpty() && resolvedEnclosingType.isPresent()) {
            this.checkIsSameErasedType(resolvedEnclosingType.get(), enclosingType);
            enclosingType = resolvedEnclosingType.get();
            constructorType = constructorElement.asMemberOf(enclosingType);
        }
        ImmutableSet.Builder provisionDependencies = ImmutableSet.builder();
        for (int i = 0; i < constructorElement.getParameters().size(); ++i) {
            XExecutableParameterElement parameter = (XExecutableParameterElement)constructorElement.getParameters().get(i);
            XType parameterType = (XType)constructorType.getParameterTypes().get(i);
            if (AssistedInjectionAnnotations.isAssistedParameter((XVariableElement)parameter)) continue;
            provisionDependencies.add((Object)this.dependencyRequestFactory.forRequiredResolvedVariable((XVariableElement)parameter, parameterType));
        }
        ProvisionBinding.Builder builder = ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement((XElement)constructorElement)).key(this.keyFactory.forInjectConstructorWithResolvedType(enclosingType))).provisionDependencies((Iterable<DependencyRequest>)provisionDependencies.build()).injectionSites(this.injectionSiteFactory.getInjectionSites(enclosingType)).kind(constructorElement.hasAnnotation(TypeNames.ASSISTED_INJECT) ? BindingKind.ASSISTED_INJECTION : BindingKind.INJECTION)).scope(this.injectionAnnotations.getScope((XElement)constructorElement.getEnclosingElement()));
        if (BindingFactory.hasNonDefaultTypeParameters(enclosingType)) {
            builder.unresolved(this.injectionBinding(constructorElement, Optional.empty()));
        }
        return (ProvisionBinding)builder.build();
    }

    public ProvisionBinding assistedFactoryBinding(XTypeElement factory, Optional<XType> resolvedFactoryType) {
        XType factoryType = factory.getType();
        if (!factoryType.getTypeArguments().isEmpty() && resolvedFactoryType.isPresent()) {
            this.checkIsSameErasedType(resolvedFactoryType.get(), factoryType);
            factoryType = resolvedFactoryType.get();
        }
        XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory);
        XMethodType factoryMethodType = factoryMethod.asMemberOf(factoryType);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(this.keyFactory.forType(factoryType))).bindingElement((XElement)factory)).provisionDependencies((Iterable<DependencyRequest>)ImmutableSet.of((Object)DependencyRequest.builder().key(this.keyFactory.forType(factoryMethodType.getReturnType())).kind(RequestKind.PROVIDER).build())).kind(BindingKind.ASSISTED_FACTORY)).build();
    }

    public ProvisionBinding providesMethodBinding(XMethodElement providesMethod, XTypeElement contributedBy) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)this.setMethodBindingProperties(ProvisionBinding.builder(), providesMethod, contributedBy, this.keyFactory.forProvidesMethod(providesMethod, contributedBy), this::providesMethodBinding).kind(BindingKind.PROVISION)).scope(this.injectionAnnotations.getScope((XElement)providesMethod)).nullability(Nullability.of((XElement)providesMethod))).build();
    }

    public ProductionBinding producesMethodBinding(XMethodElement producesMethod, XTypeElement contributedBy) {
        ProductionBinding.Builder builder = ((ProductionBinding.Builder)this.setMethodBindingProperties(ProductionBinding.builder(), producesMethod, contributedBy, this.keyFactory.forProducesMethod(producesMethod, contributedBy), this::producesMethodBinding).kind(BindingKind.PRODUCTION)).productionKind(ProductionBinding.ProductionKind.fromProducesMethod(producesMethod)).thrownTypes(producesMethod.getThrownTypes()).executorRequest(this.dependencyRequestFactory.forProductionImplementationExecutor()).monitorRequest(this.dependencyRequestFactory.forProductionComponentMonitor());
        return (ProductionBinding)builder.build();
    }

    private <C extends ContributionBinding, B extends ContributionBinding.Builder<C, B>> B setMethodBindingProperties(B builder, XMethodElement method, XTypeElement contributedBy, Key key, BiFunction<XMethodElement, XTypeElement, C> create) {
        XMethodType methodType = method.asMemberOf(contributedBy.getType());
        if (!methodType.isSameType((XExecutableType)method.getExecutableType())) {
            Preconditions.checkState((boolean)XElementKt.isTypeElement((XElement)method.getEnclosingElement()));
            builder.unresolved((ContributionBinding)((ContributionBinding)create.apply(method, XElements.asTypeElement((XElement)method.getEnclosingElement()))));
        }
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.fromBindingElement((XElement)method))).bindingElement((XElement)method)).contributingModule(contributedBy)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), methodType.getParameterTypes()))).mapKey(MapKeys.getMapKey((XElement)method).map(DaggerAnnotation::from));
    }

    public ContributionBinding syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions) {
        ContributionBinding.Builder builder = this.multibindingRequiresProduction(key, multibindingContributions) ? ProductionBinding.builder() : ProvisionBinding.builder();
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions))).kind(BindingFactory.bindingKindForMultibindingKey(key))).build();
    }

    private static BindingKind bindingKindForMultibindingKey(Key key) {
        if (SetType.isSet(key)) {
            return BindingKind.MULTIBOUND_SET;
        }
        if (MapType.isMap(key)) {
            return BindingKind.MULTIBOUND_MAP;
        }
        throw new IllegalArgumentException(String.format("key is not for a set or map: %s", key));
    }

    private boolean multibindingRequiresProduction(Key key, Iterable<ContributionBinding> multibindingContributions) {
        MapType mapType;
        if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(TypeNames.PRODUCER) || mapType.valuesAreTypeOf(TypeNames.PRODUCED) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(TypeNames.PRODUCED)) {
            return true;
        }
        return Iterables.any(multibindingContributions, binding -> binding.bindingType().equals((Object)BindingType.PRODUCTION));
    }

    public ProvisionBinding componentBinding(XTypeElement componentDefinitionType) {
        Preconditions.checkNotNull((Object)componentDefinitionType);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement((XElement)componentDefinitionType)).key(this.keyFactory.forType(componentDefinitionType.getType()))).kind(BindingKind.COMPONENT)).build();
    }

    public ProvisionBinding componentDependencyBinding(ComponentRequirement dependency) {
        Preconditions.checkNotNull((Object)dependency);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement((XElement)dependency.typeElement())).key(this.keyFactory.forType(dependency.type()))).kind(BindingKind.COMPONENT_DEPENDENCY)).build();
    }

    public ContributionBinding componentDependencyMethodBinding(ComponentDescriptor componentDescriptor, XMethodElement dependencyMethod) {
        Preconditions.checkArgument((boolean)dependencyMethod.getParameters().isEmpty());
        ContributionBinding.Builder builder = componentDescriptor.isProduction() && ComponentDescriptor.isComponentProductionMethod(dependencyMethod) ? ((ProductionBinding.Builder)((ProductionBinding.Builder)ProductionBinding.builder().key(this.keyFactory.forProductionComponentMethod(dependencyMethod))).kind(BindingKind.COMPONENT_PRODUCTION)).thrownTypes(dependencyMethod.getThrownTypes()) : ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(this.keyFactory.forComponentMethod(dependencyMethod))).nullability(Nullability.of((XElement)dependencyMethod))).kind(BindingKind.COMPONENT_PROVISION)).scope(this.injectionAnnotations.getScope((XElement)dependencyMethod));
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).bindingElement((XElement)dependencyMethod)).build();
    }

    ProvisionBinding boundInstanceBinding(ComponentRequirement requirement, XElement element) {
        Preconditions.checkArgument((XElementKt.isVariableElement((XElement)element) || XElementKt.isMethod((XElement)element) ? 1 : 0) != 0);
        XVariableElement parameterElement = XElementKt.isVariableElement((XElement)element) ? XElements.asVariable(element) : (XVariableElement)Iterables.getOnlyElement((Iterable)XElements.asMethod(element).getParameters());
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(element)).key(requirement.key().get())).nullability(Nullability.of((XElement)parameterElement))).kind(BindingKind.BOUND_INSTANCE)).build();
    }

    ProvisionBinding subcomponentCreatorBinding(XMethodElement subcomponentCreatorMethod, XTypeElement component) {
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getParameters().isEmpty());
        Key key = this.keyFactory.forSubcomponentCreatorMethod(subcomponentCreatorMethod, component.getType());
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement((XElement)subcomponentCreatorMethod)).key(key)).kind(BindingKind.SUBCOMPONENT_CREATOR)).build();
    }

    ProvisionBinding subcomponentCreatorBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
        SubcomponentDeclaration subcomponentDeclaration = (SubcomponentDeclaration)subcomponentDeclarations.iterator().next();
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(subcomponentDeclaration.key())).kind(BindingKind.SUBCOMPONENT_CREATOR)).build();
    }

    ContributionBinding delegateBinding(DelegateDeclaration delegateDeclaration, ContributionBinding actualBinding) {
        switch (actualBinding.bindingType()) {
            case PRODUCTION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProductionBinding.builder().nullability(actualBinding.nullability()), delegateDeclaration, TypeNames.PRODUCER);
            }
            case PROVISION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProvisionBinding.builder().scope(this.injectionAnnotations.getScope(delegateDeclaration.bindingElement().get())).nullability(actualBinding.nullability()), delegateDeclaration, TypeNames.PROVIDER);
            }
        }
        throw new AssertionError((Object)("bindingType: " + actualBinding));
    }

    public ContributionBinding unresolvedDelegateBinding(DelegateDeclaration delegateDeclaration) {
        return this.buildDelegateBinding(ProvisionBinding.builder().scope(this.injectionAnnotations.getScope(delegateDeclaration.bindingElement().get())), delegateDeclaration, TypeNames.PROVIDER);
    }

    private ContributionBinding buildDelegateBinding(ContributionBinding.Builder<?, ?> builder, DelegateDeclaration delegateDeclaration, ClassName frameworkType) {
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(delegateDeclaration.contributionType())).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).key(this.keyFactory.forDelegateBinding(delegateDeclaration, frameworkType))).dependencies(delegateDeclaration.delegateRequest())).mapKey(delegateDeclaration.mapKey())).kind(BindingKind.DELEGATE)).build();
    }

    ContributionBinding syntheticOptionalBinding(Key key, RequestKind requestKind, ImmutableCollection<? extends Binding> underlyingKeyBindings) {
        if (underlyingKeyBindings.isEmpty()) {
            return ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(key)).kind(BindingKind.OPTIONAL)).build();
        }
        boolean requiresProduction = underlyingKeyBindings.stream().anyMatch(binding -> binding.bindingType() == BindingType.PRODUCTION) || requestKind.equals((Object)RequestKind.PRODUCER) || requestKind.equals((Object)RequestKind.PRODUCED);
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)(requiresProduction ? ProductionBinding.builder() : ProvisionBinding.builder()).contributionType(ContributionType.UNIQUE)).key(key)).kind(BindingKind.OPTIONAL)).dependencies(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key, requestKind))).build();
    }

    public ProvisionBinding membersInjectorBinding(Key key, MembersInjectionBinding membersInjectionBinding) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(key)).contributionType(ContributionType.UNIQUE)).kind(BindingKind.MEMBERS_INJECTOR)).bindingElement((XElement)membersInjectionBinding.key().type().xprocessing().getTypeElement())).provisionDependencies((Iterable<DependencyRequest>)membersInjectionBinding.dependencies()).injectionSites(membersInjectionBinding.injectionSites()).build();
    }

    public MembersInjectionBinding membersInjectionBinding(XType type, Optional<XType> resolvedType) {
        if (!type.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            this.checkIsSameErasedType(resolvedType.get(), type);
            type = resolvedType.get();
        }
        ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites = this.injectionSiteFactory.getInjectionSites(type);
        ImmutableSet dependencies = (ImmutableSet)injectionSites.stream().flatMap(injectionSite -> injectionSite.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
        return MembersInjectionBinding.create(this.keyFactory.forMembersInjectedType(type), (ImmutableSet<DependencyRequest>)dependencies, BindingFactory.hasNonDefaultTypeParameters(type) ? Optional.of(this.membersInjectionBinding(type.getTypeElement().getType(), Optional.empty())) : Optional.empty(), injectionSites);
    }

    private void checkIsSameErasedType(XType type1, XType type2) {
        Preconditions.checkState((boolean)XTypes.erasedTypeName(type1).equals((Object)XTypes.erasedTypeName(type2)), (String)"erased expected type: %s, erased actual type: %s", (Object)XTypes.erasedTypeName(type1), (Object)XTypes.erasedTypeName(type2));
    }

    private static boolean hasNonDefaultTypeParameters(XType type) {
        if (!XTypes.isDeclared(type)) {
            return false;
        }
        XType defaultType = type.getTypeElement().getType();
        if (defaultType.getTypeArguments().isEmpty()) {
            return false;
        }
        if (defaultType.getTypeArguments().size() != type.getTypeArguments().size()) {
            return true;
        }
        for (int i = 0; i < defaultType.getTypeArguments().size(); ++i) {
            if (((XType)defaultType.getTypeArguments().get(i)).isSameType((XType)type.getTypeArguments().get(i))) continue;
            return true;
        }
        return false;
    }
}

