/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;

public final class RequestKinds {
    private static final ImmutableMap<RequestKind, ClassName> FRAMEWORK_CLASSES = ImmutableMap.of((Object)((Object)RequestKind.PROVIDER), (Object)TypeNames.PROVIDER, (Object)((Object)RequestKind.LAZY), (Object)TypeNames.LAZY, (Object)((Object)RequestKind.PRODUCER), (Object)TypeNames.PRODUCER, (Object)((Object)RequestKind.PRODUCED), (Object)TypeNames.PRODUCED);

    public static XType requestType(RequestKind requestKind, XType type, XProcessingEnv processingEnv) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return XProcessingEnvs.wrapType(TypeNames.PROVIDER, RequestKinds.requestType(RequestKind.LAZY, type, processingEnv), processingEnv);
            }
            case FUTURE: {
                return XProcessingEnvs.wrapType(TypeNames.LISTENABLE_FUTURE, type, processingEnv);
            }
        }
        return XProcessingEnvs.wrapType(RequestKinds.frameworkClassName(requestKind), type, processingEnv);
    }

    public static TypeName requestTypeName(RequestKind requestKind, TypeName keyType) {
        switch (requestKind) {
            case INSTANCE: {
                return keyType;
            }
            case PROVIDER: {
                return TypeNames.providerOf(keyType);
            }
            case LAZY: {
                return TypeNames.lazyOf(keyType);
            }
            case PROVIDER_OF_LAZY: {
                return TypeNames.providerOf((TypeName)TypeNames.lazyOf(keyType));
            }
            case PRODUCER: {
                return TypeNames.producerOf(keyType);
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyType);
            }
            case FUTURE: {
                return TypeNames.listenableFutureOf(keyType);
            }
        }
        throw new AssertionError((Object)requestKind);
    }

    public static RequestKind getRequestKind(XType type) {
        XTypes.checkTypePresent(type);
        if (!XTypes.isDeclared(type) || type.getTypeArguments().isEmpty()) {
            return RequestKind.INSTANCE;
        }
        if (XTypes.isTypeOf(type, TypeNames.PROVIDER) && XTypes.isTypeOf(XTypes.unwrapType(type), TypeNames.LAZY)) {
            return RequestKind.PROVIDER_OF_LAZY;
        }
        return ((Optional)FRAMEWORK_CLASSES.keySet().stream().filter(kind -> XTypes.isTypeOf(type, (ClassName)FRAMEWORK_CLASSES.get((Object)kind))).collect(DaggerCollectors.toOptional())).orElse(RequestKind.INSTANCE);
    }

    public static XType extractKeyType(XType type) {
        return RequestKinds.extractKeyType(RequestKinds.getRequestKind(type), type);
    }

    private static XType extractKeyType(RequestKind requestKind, XType type) {
        switch (requestKind) {
            case INSTANCE: {
                return type;
            }
            case PROVIDER_OF_LAZY: {
                return RequestKinds.extractKeyType(RequestKind.LAZY, RequestKinds.extractKeyType(RequestKind.PROVIDER, type));
            }
        }
        return XTypes.unwrapType(type);
    }

    public static ClassName frameworkClassName(RequestKind requestKind) {
        Preconditions.checkArgument((boolean)FRAMEWORK_CLASSES.containsKey((Object)requestKind), (String)"no framework class for %s", (Object)((Object)requestKind));
        return (ClassName)FRAMEWORK_CLASSES.get((Object)requestKind);
    }

    public static boolean canBeSatisfiedByProductionBinding(RequestKind requestKind) {
        switch (requestKind) {
            case INSTANCE: 
            case PROVIDER_OF_LAZY: 
            case PROVIDER: 
            case LAZY: 
            case MEMBERS_INJECTION: {
                return false;
            }
            case FUTURE: 
            case PRODUCER: 
            case PRODUCED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private RequestKinds() {
    }
}

