/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.DeleteExecutionRequest;
import com.google.cloud.run.v2.Execution;
import com.google.cloud.run.v2.ExecutionsClient;
import com.google.cloud.run.v2.GetExecutionRequest;
import com.google.cloud.run.v2.ListExecutionsRequest;
import com.google.cloud.run.v2.ListExecutionsResponse;
import com.google.cloud.run.v2.stub.ExecutionsStub;
import com.google.cloud.run.v2.stub.GrpcExecutionsStub;
import com.google.cloud.run.v2.stub.HttpJsonExecutionsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ExecutionsStubSettings
extends StubSettings<ExecutionsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetExecutionRequest, Execution> getExecutionSettings;
    private final PagedCallSettings<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings;
    private final UnaryCallSettings<DeleteExecutionRequest, Operation> deleteExecutionSettings;
    private final OperationCallSettings<DeleteExecutionRequest, Execution, Execution> deleteExecutionOperationSettings;
    private static final PagedListDescriptor<ListExecutionsRequest, ListExecutionsResponse, Execution> LIST_EXECUTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListExecutionsRequest, ListExecutionsResponse, Execution>(){

        public String emptyToken() {
            return "";
        }

        public ListExecutionsRequest injectToken(ListExecutionsRequest payload, String token) {
            return ListExecutionsRequest.newBuilder((ListExecutionsRequest)payload).setPageToken(token).build();
        }

        public ListExecutionsRequest injectPageSize(ListExecutionsRequest payload, int pageSize) {
            return ListExecutionsRequest.newBuilder((ListExecutionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExecutionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExecutionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Execution> extractResources(ListExecutionsResponse payload) {
            return payload.getExecutionsList() == null ? ImmutableList.of() : payload.getExecutionsList();
        }
    };
    private static final PagedListResponseFactory<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> LIST_EXECUTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse>(){

        public ApiFuture<ExecutionsClient.ListExecutionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> callable, ListExecutionsRequest request, ApiCallContext context, ApiFuture<ListExecutionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXECUTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExecutionsClient.ListExecutionsPagedResponse.createAsync((PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetExecutionRequest, Execution> getExecutionSettings() {
        return this.getExecutionSettings;
    }

    public PagedCallSettings<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings() {
        return this.listExecutionsSettings;
    }

    public UnaryCallSettings<DeleteExecutionRequest, Operation> deleteExecutionSettings() {
        return this.deleteExecutionSettings;
    }

    public OperationCallSettings<DeleteExecutionRequest, Execution, Execution> deleteExecutionOperationSettings() {
        return this.deleteExecutionOperationSettings;
    }

    public ExecutionsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExecutionsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonExecutionsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "run.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "run.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExecutionsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExecutionsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExecutionsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ExecutionsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExecutionsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getExecutionSettings = settingsBuilder.getExecutionSettings().build();
        this.listExecutionsSettings = settingsBuilder.listExecutionsSettings().build();
        this.deleteExecutionSettings = settingsBuilder.deleteExecutionSettings().build();
        this.deleteExecutionOperationSettings = settingsBuilder.deleteExecutionOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExecutionsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetExecutionRequest, Execution> getExecutionSettings;
        private final PagedCallSettings.Builder<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings;
        private final UnaryCallSettings.Builder<DeleteExecutionRequest, Operation> deleteExecutionSettings;
        private final OperationCallSettings.Builder<DeleteExecutionRequest, Execution, Execution> deleteExecutionOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getExecutionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExecutionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXECUTIONS_PAGE_STR_FACT);
            this.deleteExecutionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExecutionOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getExecutionSettings, this.listExecutionsSettings, this.deleteExecutionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExecutionsStubSettings settings) {
            super((StubSettings)settings);
            this.getExecutionSettings = settings.getExecutionSettings.toBuilder();
            this.listExecutionsSettings = settings.listExecutionsSettings.toBuilder();
            this.deleteExecutionSettings = settings.deleteExecutionSettings.toBuilder();
            this.deleteExecutionOperationSettings = settings.deleteExecutionOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getExecutionSettings, this.listExecutionsSettings, this.deleteExecutionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExecutionsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExecutionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExecutionsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExecutionsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ExecutionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ExecutionsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ExecutionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExecutionsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExecutionsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ExecutionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getExecutionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listExecutionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteExecutionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteExecutionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Execution.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Execution.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetExecutionRequest, Execution> getExecutionSettings() {
            return this.getExecutionSettings;
        }

        public PagedCallSettings.Builder<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings() {
            return this.listExecutionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteExecutionRequest, Operation> deleteExecutionSettings() {
            return this.deleteExecutionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteExecutionRequest, Execution, Execution> deleteExecutionOperationSettings() {
            return this.deleteExecutionOperationSettings;
        }

        public ExecutionsStubSettings build() throws IOException {
            return new ExecutionsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

