/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.r2dbc.BindingFailureException;
import com.google.cloud.spanner.r2dbc.statement.TypedNull;
import com.google.cloud.spanner.r2dbc.util.Assert;
import com.google.cloud.spanner.r2dbc.v2.ClientLibraryTypeBinder;
import com.google.cloud.spanner.r2dbc.v2.ClientLibraryTypeBinderImpl;
import com.google.cloud.spanner.r2dbc.v2.JsonWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ClientLibraryBinder {
    private static final List<ClientLibraryTypeBinder> binders = ClientLibraryBinder.buildBinders();

    ClientLibraryBinder() {
    }

    private static List<ClientLibraryTypeBinder> buildBinders() {
        ArrayList<ClientLibraryTypeBinder> binders = new ArrayList<ClientLibraryTypeBinder>();
        binders.add(new ClientLibraryTypeBinderImpl<Integer>(Integer.class, (binder, val) -> binder.to(ClientLibraryBinder.longFromInteger(val))));
        binders.add(new ClientLibraryTypeBinderImpl<Long>(Long.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<Double>(Double.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<Boolean>(Boolean.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<ByteArray>(ByteArray.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<Date>(Date.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<String>(String.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<Timestamp>(Timestamp.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<BigDecimal>(BigDecimal.class, (binder, val) -> binder.to(val)));
        binders.add(new ClientLibraryTypeBinderImpl<JsonWrapper>(JsonWrapper.class, (binder, val) -> binder.to(val == null ? Value.json(null) : val.getJsonVal())));
        return binders;
    }

    static void bind(Statement.Builder builder, String name, Object value) {
        Assert.requireNonNull(name, "Column name must not be null");
        Assert.requireNonNull(value, "Value must not be null");
        Class<?> valueClass = ClientLibraryBinder.isTypedNull(value) ? ((TypedNull)value).getType() : value.getClass();
        Optional<ClientLibraryTypeBinder> optionalBinder = binders.stream().filter(e -> e.canBind(valueClass)).findFirst();
        if (!optionalBinder.isPresent()) {
            throw new BindingFailureException("Can't find a binder for type: " + valueClass);
        }
        if (!ClientLibraryBinder.isTypedNull(value)) {
            optionalBinder.get().bind(builder, name, value);
        } else {
            optionalBinder.get().bind(builder, name, null);
        }
    }

    private static boolean isTypedNull(Object value) {
        return value.getClass().equals(TypedNull.class);
    }

    private static Long longFromInteger(Integer intValue) {
        return intValue == null ? null : Long.valueOf(intValue.longValue());
    }
}

