/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.util;

import com.google.cloud.spanner.r2dbc.util.CollectionsBuilder;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.util.Set;
import javax.annotation.Nullable;

public class SpannerExceptionUtil {
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
    private static final Set<String> RETRYABLE_ERROR_MESSAGES = CollectionsBuilder.setOf("HTTP/2 error code: INTERNAL_ERROR", "Connection closed with unknown cause", "Received unexpected EOS on DATA frame from server");

    public static R2dbcException createR2dbcException(int errorCode, String message) {
        return SpannerExceptionUtil.createR2dbcException(errorCode, message, null);
    }

    public static R2dbcException createR2dbcException(Throwable baseException) {
        if (baseException == null) {
            return new R2dbcNonTransientResourceException();
        }
        if (!(baseException instanceof StatusRuntimeException)) {
            return new R2dbcNonTransientResourceException(baseException.getMessage(), baseException);
        }
        StatusRuntimeException statusRuntimeException = (StatusRuntimeException)baseException;
        int errorCode = statusRuntimeException.getStatus().getCode().value();
        if (SpannerExceptionUtil.isRetryable(statusRuntimeException)) {
            return new R2dbcTransientResourceException(baseException.getMessage(), null, errorCode, baseException);
        }
        return SpannerExceptionUtil.createR2dbcException(errorCode, baseException.getMessage(), baseException);
    }

    private static R2dbcException createR2dbcException(int errorCode, String message, @Nullable Throwable baseException) {
        switch (errorCode) {
            case 6: {
                return new R2dbcDataIntegrityViolationException(message, null, errorCode, baseException);
            }
            case 3: {
                return new R2dbcBadGrammarException(message, null, errorCode, baseException);
            }
            case 7: {
                return new R2dbcPermissionDeniedException(message, null, errorCode, baseException);
            }
        }
        return new R2dbcNonTransientResourceException(message, null, errorCode, baseException);
    }

    private static boolean isRetryable(StatusRuntimeException statusRuntimeException) {
        if (statusRuntimeException.getStatus().getCode() == Status.Code.INTERNAL && RETRYABLE_ERROR_MESSAGES.stream().anyMatch(errorFragment -> statusRuntimeException.getMessage().contains((CharSequence)errorFragment))) {
            return true;
        }
        return statusRuntimeException.getStatus().getCode() == Status.Code.RESOURCE_EXHAUSTED && SpannerExceptionUtil.extractRetryDelay((Throwable)statusRuntimeException) != null;
    }

    private static java.time.Duration extractRetryDelay(Throwable cause) {
        RetryInfo retryInfo;
        Metadata trailers = Status.trailersFromThrowable((Throwable)cause);
        if (trailers != null && trailers.containsKey(KEY_RETRY_INFO) && (retryInfo = (RetryInfo)trailers.get(KEY_RETRY_INFO)).hasRetryDelay()) {
            Duration protobufDuration = retryInfo.getRetryDelay();
            return java.time.Duration.ofSeconds(protobufDuration.getSeconds()).withNanos(protobufDuration.getNanos());
        }
        return null;
    }
}

