/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.groupssettings;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.groupssettings.GroupssettingsRequest;
import com.google.api.services.groupssettings.GroupssettingsRequestInitializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Groupssettings
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "groups/v1/groups/";
    public static final String DEFAULT_BATCH_PATH = "batch/groupssettings/v1";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/groups/v1/groups/";

    public Groupssettings(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Groupssettings(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Groups groups() {
        return new Groups();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Groups Settings API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Groupssettings.DEFAULT_ROOT_URL, Groupssettings.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Groupssettings.DEFAULT_BATCH_PATH);
        }

        public Groupssettings build() {
            return new Groupssettings(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setGroupssettingsRequestInitializer(GroupssettingsRequestInitializer groupssettingsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)groupssettingsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Groups {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Groupssettings.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Patch patch(String string, com.google.api.services.groupssettings.model.Groups groups) throws IOException {
            Patch patch = new Patch(string, groups);
            Groupssettings.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, com.google.api.services.groupssettings.model.Groups groups) throws IOException {
            Update update = new Update(string, groups);
            Groupssettings.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends GroupssettingsRequest<com.google.api.services.groupssettings.model.Groups> {
            private static final String REST_PATH = "{groupUniqueId}";
            @Key
            private String groupUniqueId;

            protected Update(String string, com.google.api.services.groupssettings.model.Groups groups2) {
                super(Groupssettings.this, "PUT", REST_PATH, (Object)groups2, com.google.api.services.groupssettings.model.Groups.class);
                this.groupUniqueId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupUniqueId must be specified.");
                this.set("alt", "json");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getGroupUniqueId() {
                return this.groupUniqueId;
            }

            public Update setGroupUniqueId(String string) {
                this.groupUniqueId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends GroupssettingsRequest<com.google.api.services.groupssettings.model.Groups> {
            private static final String REST_PATH = "{groupUniqueId}";
            @Key
            private String groupUniqueId;

            protected Patch(String string, com.google.api.services.groupssettings.model.Groups groups2) {
                super(Groupssettings.this, "PATCH", REST_PATH, (Object)groups2, com.google.api.services.groupssettings.model.Groups.class);
                this.groupUniqueId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupUniqueId must be specified.");
                this.set("alt", "json");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getGroupUniqueId() {
                return this.groupUniqueId;
            }

            public Patch setGroupUniqueId(String string) {
                this.groupUniqueId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GroupssettingsRequest<com.google.api.services.groupssettings.model.Groups> {
            private static final String REST_PATH = "{groupUniqueId}";
            @Key
            private String groupUniqueId;

            protected Get(String string) {
                super(Groupssettings.this, "GET", REST_PATH, null, com.google.api.services.groupssettings.model.Groups.class);
                this.groupUniqueId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupUniqueId must be specified.");
                this.set("alt", "json");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getGroupUniqueId() {
                return this.groupUniqueId;
            }

            public Get setGroupUniqueId(String string) {
                this.groupUniqueId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

