/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-08-27 at 02:26:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a result for a match participant.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParticipantResult extends com.google.api.client.json.GenericJson {

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#participantResult.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ID of the participant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String participantId;

  /**
   * The placement or ranking of the participant in the match results; a number from one to the
   * number of participants in the match. Multiple participants may have the same placing value in
   * case of a type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer placing;

  /**
   * The result of the participant for this match. Possible values are:   - "MATCH_RESULT_WIN" - The
   * participant won the match.  - "MATCH_RESULT_LOSS" - The participant lost the match.  -
   * "MATCH_RESULT_TIE" - The participant tied the match.  - "MATCH_RESULT_NONE" - There was no
   * winner for the match (nobody wins or loses this kind of game.)  - "MATCH_RESULT_DISCONNECT" -
   * The participant disconnected / left during the match.  - "MATCH_RESULT_DISAGREED" - Different
   * clients reported different results for this participant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String result;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#participantResult.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#participantResult.
   * @param kind kind or {@code null} for none
   */
  public ParticipantResult setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The ID of the participant.
   * @return value or {@code null} for none
   */
  public java.lang.String getParticipantId() {
    return participantId;
  }

  /**
   * The ID of the participant.
   * @param participantId participantId or {@code null} for none
   */
  public ParticipantResult setParticipantId(java.lang.String participantId) {
    this.participantId = participantId;
    return this;
  }

  /**
   * The placement or ranking of the participant in the match results; a number from one to the
   * number of participants in the match. Multiple participants may have the same placing value in
   * case of a type.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPlacing() {
    return placing;
  }

  /**
   * The placement or ranking of the participant in the match results; a number from one to the
   * number of participants in the match. Multiple participants may have the same placing value in
   * case of a type.
   * @param placing placing or {@code null} for none
   */
  public ParticipantResult setPlacing(java.lang.Integer placing) {
    this.placing = placing;
    return this;
  }

  /**
   * The result of the participant for this match. Possible values are:   - "MATCH_RESULT_WIN" - The
   * participant won the match.  - "MATCH_RESULT_LOSS" - The participant lost the match.  -
   * "MATCH_RESULT_TIE" - The participant tied the match.  - "MATCH_RESULT_NONE" - There was no
   * winner for the match (nobody wins or loses this kind of game.)  - "MATCH_RESULT_DISCONNECT" -
   * The participant disconnected / left during the match.  - "MATCH_RESULT_DISAGREED" - Different
   * clients reported different results for this participant.
   * @return value or {@code null} for none
   */
  public java.lang.String getResult() {
    return result;
  }

  /**
   * The result of the participant for this match. Possible values are:   - "MATCH_RESULT_WIN" - The
   * participant won the match.  - "MATCH_RESULT_LOSS" - The participant lost the match.  -
   * "MATCH_RESULT_TIE" - The participant tied the match.  - "MATCH_RESULT_NONE" - There was no
   * winner for the match (nobody wins or loses this kind of game.)  - "MATCH_RESULT_DISCONNECT" -
   * The participant disconnected / left during the match.  - "MATCH_RESULT_DISAGREED" - Different
   * clients reported different results for this participant.
   * @param result result or {@code null} for none
   */
  public ParticipantResult setResult(java.lang.String result) {
    this.result = result;
    return this;
  }

  @Override
  public ParticipantResult set(String fieldName, Object value) {
    return (ParticipantResult) super.set(fieldName, value);
  }

  @Override
  public ParticipantResult clone() {
    return (ParticipantResult) super.clone();
  }

}
