/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-08-27 at 02:26:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a score rank in a leaderboard.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LeaderboardScoreRank extends com.google.api.client.json.GenericJson {

  /**
   * The number of scores in the leaderboard as a string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedNumScores;

  /**
   * The rank in the leaderboard as a string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedRank;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#leaderboardScoreRank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The number of scores in the leaderboard.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numScores;

  /**
   * The rank in the leaderboard.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rank;

  /**
   * The number of scores in the leaderboard as a string.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedNumScores() {
    return formattedNumScores;
  }

  /**
   * The number of scores in the leaderboard as a string.
   * @param formattedNumScores formattedNumScores or {@code null} for none
   */
  public LeaderboardScoreRank setFormattedNumScores(java.lang.String formattedNumScores) {
    this.formattedNumScores = formattedNumScores;
    return this;
  }

  /**
   * The rank in the leaderboard as a string.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedRank() {
    return formattedRank;
  }

  /**
   * The rank in the leaderboard as a string.
   * @param formattedRank formattedRank or {@code null} for none
   */
  public LeaderboardScoreRank setFormattedRank(java.lang.String formattedRank) {
    this.formattedRank = formattedRank;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#leaderboardScoreRank.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#leaderboardScoreRank.
   * @param kind kind or {@code null} for none
   */
  public LeaderboardScoreRank setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The number of scores in the leaderboard.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumScores() {
    return numScores;
  }

  /**
   * The number of scores in the leaderboard.
   * @param numScores numScores or {@code null} for none
   */
  public LeaderboardScoreRank setNumScores(java.lang.Long numScores) {
    this.numScores = numScores;
    return this;
  }

  /**
   * The rank in the leaderboard.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRank() {
    return rank;
  }

  /**
   * The rank in the leaderboard.
   * @param rank rank or {@code null} for none
   */
  public LeaderboardScoreRank setRank(java.lang.Long rank) {
    this.rank = rank;
    return this;
  }

  @Override
  public LeaderboardScoreRank set(String fieldName, Object value) {
    return (LeaderboardScoreRank) super.set(fieldName, value);
  }

  @Override
  public LeaderboardScoreRank clone() {
    return (LeaderboardScoreRank) super.clone();
  }

}
