/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-08-27 at 02:26:17 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an achievement reveal response
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AchievementRevealResponse extends com.google.api.client.json.GenericJson {

  /**
   * The current state of the achievement for which a reveal was attempted. This might be UNLOCKED
   * if the achievement was already unlocked. Possible values are:   - "REVEALED" - Achievement is
   * revealed.  - "UNLOCKED" - Achievement is unlocked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentState;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementRevealResponse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The current state of the achievement for which a reveal was attempted. This might be UNLOCKED
   * if the achievement was already unlocked. Possible values are:   - "REVEALED" - Achievement is
   * revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentState() {
    return currentState;
  }

  /**
   * The current state of the achievement for which a reveal was attempted. This might be UNLOCKED
   * if the achievement was already unlocked. Possible values are:   - "REVEALED" - Achievement is
   * revealed.  - "UNLOCKED" - Achievement is unlocked.
   * @param currentState currentState or {@code null} for none
   */
  public AchievementRevealResponse setCurrentState(java.lang.String currentState) {
    this.currentState = currentState;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementRevealResponse.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#achievementRevealResponse.
   * @param kind kind or {@code null} for none
   */
  public AchievementRevealResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public AchievementRevealResponse set(String fieldName, Object value) {
    return (AchievementRevealResponse) super.set(fieldName, value);
  }

  @Override
  public AchievementRevealResponse clone() {
    return (AchievementRevealResponse) super.clone();
  }

}
