/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-10-17 16:43:55 UTC)
 * on 2016-11-10 at 22:38:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for FreeBusyRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FreeBusyRequest extends com.google.api.client.json.GenericJson {

  /**
   * Maximal number of calendars for which FreeBusy information is to be provided. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer calendarExpansionMax;

  /**
   * Maximal number of calendar identifiers to be provided for a single group. Optional. An error
   * will be returned for a group with more members than this value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer groupExpansionMax;

  /**
   * List of calendars and/or groups to query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FreeBusyRequestItem> items;

  /**
   * The end of the interval for the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeMax;

  /**
   * The start of the interval for the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime timeMin;

  /**
   * Time zone used in the response. Optional. The default is UTC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Maximal number of calendars for which FreeBusy information is to be provided. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCalendarExpansionMax() {
    return calendarExpansionMax;
  }

  /**
   * Maximal number of calendars for which FreeBusy information is to be provided. Optional.
   * @param calendarExpansionMax calendarExpansionMax or {@code null} for none
   */
  public FreeBusyRequest setCalendarExpansionMax(java.lang.Integer calendarExpansionMax) {
    this.calendarExpansionMax = calendarExpansionMax;
    return this;
  }

  /**
   * Maximal number of calendar identifiers to be provided for a single group. Optional. An error
   * will be returned for a group with more members than this value.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getGroupExpansionMax() {
    return groupExpansionMax;
  }

  /**
   * Maximal number of calendar identifiers to be provided for a single group. Optional. An error
   * will be returned for a group with more members than this value.
   * @param groupExpansionMax groupExpansionMax or {@code null} for none
   */
  public FreeBusyRequest setGroupExpansionMax(java.lang.Integer groupExpansionMax) {
    this.groupExpansionMax = groupExpansionMax;
    return this;
  }

  /**
   * List of calendars and/or groups to query.
   * @return value or {@code null} for none
   */
  public java.util.List<FreeBusyRequestItem> getItems() {
    return items;
  }

  /**
   * List of calendars and/or groups to query.
   * @param items items or {@code null} for none
   */
  public FreeBusyRequest setItems(java.util.List<FreeBusyRequestItem> items) {
    this.items = items;
    return this;
  }

  /**
   * The end of the interval for the query.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeMax() {
    return timeMax;
  }

  /**
   * The end of the interval for the query.
   * @param timeMax timeMax or {@code null} for none
   */
  public FreeBusyRequest setTimeMax(com.google.api.client.util.DateTime timeMax) {
    this.timeMax = timeMax;
    return this;
  }

  /**
   * The start of the interval for the query.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeMin() {
    return timeMin;
  }

  /**
   * The start of the interval for the query.
   * @param timeMin timeMin or {@code null} for none
   */
  public FreeBusyRequest setTimeMin(com.google.api.client.util.DateTime timeMin) {
    this.timeMin = timeMin;
    return this;
  }

  /**
   * Time zone used in the response. Optional. The default is UTC.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Time zone used in the response. Optional. The default is UTC.
   * @param timeZone timeZone or {@code null} for none
   */
  public FreeBusyRequest setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  @Override
  public FreeBusyRequest set(String fieldName, Object value) {
    return (FreeBusyRequest) super.set(fieldName, value);
  }

  @Override
  public FreeBusyRequest clone() {
    return (FreeBusyRequest) super.clone();
  }

}
