/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/trace.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * A simulated forwarding path is composed of multiple steps.
 * Each step has a well-defined state and an associated configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.Step}
 */
public final class Step extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.Step)
    StepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Step.newBuilder() to construct.
  private Step(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Step() {
    description_ = "";
    state_ = 0;
    projectId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Step();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_Step_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_Step_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.Step.class,
            com.google.cloud.networkmanagement.v1beta1.Step.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of states that are defined in the network state machine.
   * Each step in the packet trace is in a specific state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.Step.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Compute Engine instance.
     * An InstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_INSTANCE = 1;</code>
     */
    START_FROM_INSTANCE(1),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from the internet.
     * The endpoint information is populated.
     * </pre>
     *
     * <code>START_FROM_INTERNET = 2;</code>
     */
    START_FROM_INTERNET(2),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a VPC or on-premises network
     * with internal source IP.
     * If the source is a VPC network visible to the user, a NetworkInfo
     * is populated with details of the network.
     * </pre>
     *
     * <code>START_FROM_PRIVATE_NETWORK = 3;</code>
     */
    START_FROM_PRIVATE_NETWORK(3),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Google Kubernetes Engine cluster
     * master. A GKEMasterInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_GKE_MASTER = 21;</code>
     */
    START_FROM_GKE_MASTER(21),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud SQL instance.
     * A CloudSQLInstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_SQL_INSTANCE = 22;</code>
     */
    START_FROM_CLOUD_SQL_INSTANCE(22),
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud function.
     * A CloudFunctionInfo is populated with starting function information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_FUNCTION = 23;</code>
     */
    START_FROM_CLOUD_FUNCTION(23),
    /**
     *
     *
     * <pre>
     * Config checking state: verify ingress firewall rule.
     * </pre>
     *
     * <code>APPLY_INGRESS_FIREWALL_RULE = 4;</code>
     */
    APPLY_INGRESS_FIREWALL_RULE(4),
    /**
     *
     *
     * <pre>
     * Config checking state: verify egress firewall rule.
     * </pre>
     *
     * <code>APPLY_EGRESS_FIREWALL_RULE = 5;</code>
     */
    APPLY_EGRESS_FIREWALL_RULE(5),
    /**
     *
     *
     * <pre>
     * Config checking state: verify route.
     * </pre>
     *
     * <code>APPLY_ROUTE = 6;</code>
     */
    APPLY_ROUTE(6),
    /**
     *
     *
     * <pre>
     * Config checking state: match forwarding rule.
     * </pre>
     *
     * <code>APPLY_FORWARDING_RULE = 7;</code>
     */
    APPLY_FORWARDING_RULE(7),
    /**
     *
     *
     * <pre>
     * Config checking state: packet sent or received under foreign IP
     * address and allowed.
     * </pre>
     *
     * <code>SPOOFING_APPROVED = 8;</code>
     */
    SPOOFING_APPROVED(8),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine instance.
     * </pre>
     *
     * <code>ARRIVE_AT_INSTANCE = 9;</code>
     */
    ARRIVE_AT_INSTANCE(9),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine internal load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_INTERNAL_LOAD_BALANCER = 10;</code>
     */
    ARRIVE_AT_INTERNAL_LOAD_BALANCER(10),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine external load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 11;</code>
     */
    ARRIVE_AT_EXTERNAL_LOAD_BALANCER(11),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_GATEWAY = 12;</code>
     */
    ARRIVE_AT_VPN_GATEWAY(12),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN tunnel.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_TUNNEL = 13;</code>
     */
    ARRIVE_AT_VPN_TUNNEL(13),
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a VPC connector.
     * </pre>
     *
     * <code>ARRIVE_AT_VPC_CONNECTOR = 24;</code>
     */
    ARRIVE_AT_VPC_CONNECTOR(24),
    /**
     *
     *
     * <pre>
     * Transition state: packet header translated.
     * </pre>
     *
     * <code>NAT = 14;</code>
     */
    NAT(14),
    /**
     *
     *
     * <pre>
     * Transition state: original connection is terminated and a new proxied
     * connection is initiated.
     * </pre>
     *
     * <code>PROXY_CONNECTION = 15;</code>
     */
    PROXY_CONNECTION(15),
    /**
     *
     *
     * <pre>
     * Final state: packet could be delivered.
     * </pre>
     *
     * <code>DELIVER = 16;</code>
     */
    DELIVER(16),
    /**
     *
     *
     * <pre>
     * Final state: packet could be dropped.
     * </pre>
     *
     * <code>DROP = 17;</code>
     */
    DROP(17),
    /**
     *
     *
     * <pre>
     * Final state: packet could be forwarded to a network with an unknown
     * configuration.
     * </pre>
     *
     * <code>FORWARD = 18;</code>
     */
    FORWARD(18),
    /**
     *
     *
     * <pre>
     * Final state: analysis is aborted.
     * </pre>
     *
     * <code>ABORT = 19;</code>
     */
    ABORT(19),
    /**
     *
     *
     * <pre>
     * Special state: viewer of the test result does not have permission to
     * see the configuration in this step.
     * </pre>
     *
     * <code>VIEWER_PERMISSION_MISSING = 20;</code>
     */
    VIEWER_PERMISSION_MISSING(20),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Compute Engine instance.
     * An InstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_INSTANCE = 1;</code>
     */
    public static final int START_FROM_INSTANCE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from the internet.
     * The endpoint information is populated.
     * </pre>
     *
     * <code>START_FROM_INTERNET = 2;</code>
     */
    public static final int START_FROM_INTERNET_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a VPC or on-premises network
     * with internal source IP.
     * If the source is a VPC network visible to the user, a NetworkInfo
     * is populated with details of the network.
     * </pre>
     *
     * <code>START_FROM_PRIVATE_NETWORK = 3;</code>
     */
    public static final int START_FROM_PRIVATE_NETWORK_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Google Kubernetes Engine cluster
     * master. A GKEMasterInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_GKE_MASTER = 21;</code>
     */
    public static final int START_FROM_GKE_MASTER_VALUE = 21;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud SQL instance.
     * A CloudSQLInstanceInfo is populated with starting instance information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_SQL_INSTANCE = 22;</code>
     */
    public static final int START_FROM_CLOUD_SQL_INSTANCE_VALUE = 22;
    /**
     *
     *
     * <pre>
     * Initial state: packet originating from a Cloud function.
     * A CloudFunctionInfo is populated with starting function information.
     * </pre>
     *
     * <code>START_FROM_CLOUD_FUNCTION = 23;</code>
     */
    public static final int START_FROM_CLOUD_FUNCTION_VALUE = 23;
    /**
     *
     *
     * <pre>
     * Config checking state: verify ingress firewall rule.
     * </pre>
     *
     * <code>APPLY_INGRESS_FIREWALL_RULE = 4;</code>
     */
    public static final int APPLY_INGRESS_FIREWALL_RULE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Config checking state: verify egress firewall rule.
     * </pre>
     *
     * <code>APPLY_EGRESS_FIREWALL_RULE = 5;</code>
     */
    public static final int APPLY_EGRESS_FIREWALL_RULE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Config checking state: verify route.
     * </pre>
     *
     * <code>APPLY_ROUTE = 6;</code>
     */
    public static final int APPLY_ROUTE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Config checking state: match forwarding rule.
     * </pre>
     *
     * <code>APPLY_FORWARDING_RULE = 7;</code>
     */
    public static final int APPLY_FORWARDING_RULE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Config checking state: packet sent or received under foreign IP
     * address and allowed.
     * </pre>
     *
     * <code>SPOOFING_APPROVED = 8;</code>
     */
    public static final int SPOOFING_APPROVED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine instance.
     * </pre>
     *
     * <code>ARRIVE_AT_INSTANCE = 9;</code>
     */
    public static final int ARRIVE_AT_INSTANCE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine internal load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_INTERNAL_LOAD_BALANCER = 10;</code>
     */
    public static final int ARRIVE_AT_INTERNAL_LOAD_BALANCER_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Compute Engine external load balancer.
     * </pre>
     *
     * <code>ARRIVE_AT_EXTERNAL_LOAD_BALANCER = 11;</code>
     */
    public static final int ARRIVE_AT_EXTERNAL_LOAD_BALANCER_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_GATEWAY = 12;</code>
     */
    public static final int ARRIVE_AT_VPN_GATEWAY_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a Cloud VPN tunnel.
     * </pre>
     *
     * <code>ARRIVE_AT_VPN_TUNNEL = 13;</code>
     */
    public static final int ARRIVE_AT_VPN_TUNNEL_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Forwarding state: arriving at a VPC connector.
     * </pre>
     *
     * <code>ARRIVE_AT_VPC_CONNECTOR = 24;</code>
     */
    public static final int ARRIVE_AT_VPC_CONNECTOR_VALUE = 24;
    /**
     *
     *
     * <pre>
     * Transition state: packet header translated.
     * </pre>
     *
     * <code>NAT = 14;</code>
     */
    public static final int NAT_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Transition state: original connection is terminated and a new proxied
     * connection is initiated.
     * </pre>
     *
     * <code>PROXY_CONNECTION = 15;</code>
     */
    public static final int PROXY_CONNECTION_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Final state: packet could be delivered.
     * </pre>
     *
     * <code>DELIVER = 16;</code>
     */
    public static final int DELIVER_VALUE = 16;
    /**
     *
     *
     * <pre>
     * Final state: packet could be dropped.
     * </pre>
     *
     * <code>DROP = 17;</code>
     */
    public static final int DROP_VALUE = 17;
    /**
     *
     *
     * <pre>
     * Final state: packet could be forwarded to a network with an unknown
     * configuration.
     * </pre>
     *
     * <code>FORWARD = 18;</code>
     */
    public static final int FORWARD_VALUE = 18;
    /**
     *
     *
     * <pre>
     * Final state: analysis is aborted.
     * </pre>
     *
     * <code>ABORT = 19;</code>
     */
    public static final int ABORT_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Special state: viewer of the test result does not have permission to
     * see the configuration in this step.
     * </pre>
     *
     * <code>VIEWER_PERMISSION_MISSING = 20;</code>
     */
    public static final int VIEWER_PERMISSION_MISSING_VALUE = 20;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return START_FROM_INSTANCE;
        case 2:
          return START_FROM_INTERNET;
        case 3:
          return START_FROM_PRIVATE_NETWORK;
        case 21:
          return START_FROM_GKE_MASTER;
        case 22:
          return START_FROM_CLOUD_SQL_INSTANCE;
        case 23:
          return START_FROM_CLOUD_FUNCTION;
        case 4:
          return APPLY_INGRESS_FIREWALL_RULE;
        case 5:
          return APPLY_EGRESS_FIREWALL_RULE;
        case 6:
          return APPLY_ROUTE;
        case 7:
          return APPLY_FORWARDING_RULE;
        case 8:
          return SPOOFING_APPROVED;
        case 9:
          return ARRIVE_AT_INSTANCE;
        case 10:
          return ARRIVE_AT_INTERNAL_LOAD_BALANCER;
        case 11:
          return ARRIVE_AT_EXTERNAL_LOAD_BALANCER;
        case 12:
          return ARRIVE_AT_VPN_GATEWAY;
        case 13:
          return ARRIVE_AT_VPN_TUNNEL;
        case 24:
          return ARRIVE_AT_VPC_CONNECTOR;
        case 14:
          return NAT;
        case 15:
          return PROXY_CONNECTION;
        case 16:
          return DELIVER;
        case 17:
          return DROP;
        case 18:
          return FORWARD;
        case 19:
          return ABORT;
        case 20:
          return VIEWER_PERMISSION_MISSING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.Step.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.Step.State)
  }

  private int stepInfoCase_ = 0;
  private java.lang.Object stepInfo_;

  public enum StepInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSTANCE(5),
    FIREWALL(6),
    ROUTE(7),
    ENDPOINT(8),
    FORWARDING_RULE(9),
    VPN_GATEWAY(10),
    VPN_TUNNEL(11),
    VPC_CONNECTOR(21),
    DELIVER(12),
    FORWARD(13),
    ABORT(14),
    DROP(15),
    LOAD_BALANCER(16),
    NETWORK(17),
    GKE_MASTER(18),
    CLOUD_SQL_INSTANCE(19),
    CLOUD_FUNCTION(20),
    STEPINFO_NOT_SET(0);
    private final int value;

    private StepInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StepInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static StepInfoCase forNumber(int value) {
      switch (value) {
        case 5:
          return INSTANCE;
        case 6:
          return FIREWALL;
        case 7:
          return ROUTE;
        case 8:
          return ENDPOINT;
        case 9:
          return FORWARDING_RULE;
        case 10:
          return VPN_GATEWAY;
        case 11:
          return VPN_TUNNEL;
        case 21:
          return VPC_CONNECTOR;
        case 12:
          return DELIVER;
        case 13:
          return FORWARD;
        case 14:
          return ABORT;
        case 15:
          return DROP;
        case 16:
          return LOAD_BALANCER;
        case 17:
          return NETWORK;
        case 18:
          return GKE_MASTER;
        case 19:
          return CLOUD_SQL_INSTANCE;
        case 20:
          return CLOUD_FUNCTION;
        case 0:
          return STEPINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StepInfoCase getStepInfoCase() {
    return StepInfoCase.forNumber(stepInfoCase_);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 1;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * A description of the step. Usually this is a summary of the state.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of the step. Usually this is a summary of the state.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_;
  /**
   *
   *
   * <pre>
   * Each step is in one of the pre-defined states.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Each step is in one of the pre-defined states.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Step.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.Step.State result =
        com.google.cloud.networkmanagement.v1beta1.Step.State.valueOf(state_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.Step.State.UNRECOGNIZED
        : result;
  }

  public static final int CAUSES_DROP_FIELD_NUMBER = 3;
  private boolean causesDrop_;
  /**
   *
   *
   * <pre>
   * This is a step that leads to the final state Drop.
   * </pre>
   *
   * <code>bool causes_drop = 3;</code>
   *
   * @return The causesDrop.
   */
  @java.lang.Override
  public boolean getCausesDrop() {
    return causesDrop_;
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Project ID that contains the configuration this step is validating.
   * </pre>
   *
   * <code>string project_id = 4;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID that contains the configuration this step is validating.
   * </pre>
   *
   * <code>string project_id = 4;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
   *
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  public boolean hasInstance() {
    return stepInfoCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.InstanceInfo getInstance() {
    if (stepInfoCase_ == 5) {
      return (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.InstanceInfoOrBuilder getInstanceOrBuilder() {
    if (stepInfoCase_ == 5) {
      return (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance();
  }

  public static final int FIREWALL_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine firewall rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
   *
   * @return Whether the firewall field is set.
   */
  @java.lang.Override
  public boolean hasFirewall() {
    return stepInfoCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine firewall rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
   *
   * @return The firewall.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.FirewallInfo getFirewall() {
    if (stepInfoCase_ == 6) {
      return (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine firewall rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.FirewallInfoOrBuilder getFirewallOrBuilder() {
    if (stepInfoCase_ == 6) {
      return (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance();
  }

  public static final int ROUTE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
   *
   * @return Whether the route field is set.
   */
  @java.lang.Override
  public boolean hasRoute() {
    return stepInfoCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
   *
   * @return The route.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.RouteInfo getRoute() {
    if (stepInfoCase_ == 7) {
      return (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.RouteInfoOrBuilder getRouteOrBuilder() {
    if (stepInfoCase_ == 7) {
      return (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
  }

  public static final int ENDPOINT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Display information of the source and destination under analysis.
   * The endpoint information in an intermediate state may differ with the
   * initial input, as it might be modified by state like NAT,
   * or Connection Proxy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
   *
   * @return Whether the endpoint field is set.
   */
  @java.lang.Override
  public boolean hasEndpoint() {
    return stepInfoCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Display information of the source and destination under analysis.
   * The endpoint information in an intermediate state may differ with the
   * initial input, as it might be modified by state like NAT,
   * or Connection Proxy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.EndpointInfo getEndpoint() {
    if (stepInfoCase_ == 8) {
      return (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the source and destination under analysis.
   * The endpoint information in an intermediate state may differ with the
   * initial input, as it might be modified by state like NAT,
   * or Connection Proxy.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder getEndpointOrBuilder() {
    if (stepInfoCase_ == 8) {
      return (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance();
  }

  public static final int FORWARDING_RULE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
   *
   * @return Whether the forwardingRule field is set.
   */
  @java.lang.Override
  public boolean hasForwardingRule() {
    return stepInfoCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
   *
   * @return The forwardingRule.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo getForwardingRule() {
    if (stepInfoCase_ == 9) {
      return (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine forwarding rule.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfoOrBuilder
      getForwardingRuleOrBuilder() {
    if (stepInfoCase_ == 9) {
      return (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
  }

  public static final int VPN_GATEWAY_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN gateway.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
   *
   * @return Whether the vpnGateway field is set.
   */
  @java.lang.Override
  public boolean hasVpnGateway() {
    return stepInfoCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN gateway.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
   *
   * @return The vpnGateway.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo getVpnGateway() {
    if (stepInfoCase_ == 10) {
      return (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN gateway.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfoOrBuilder
      getVpnGatewayOrBuilder() {
    if (stepInfoCase_ == 10) {
      return (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance();
  }

  public static final int VPN_TUNNEL_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN tunnel.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
   *
   * @return Whether the vpnTunnel field is set.
   */
  @java.lang.Override
  public boolean hasVpnTunnel() {
    return stepInfoCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN tunnel.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
   *
   * @return The vpnTunnel.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo getVpnTunnel() {
    if (stepInfoCase_ == 11) {
      return (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Compute Engine VPN tunnel.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfoOrBuilder getVpnTunnelOrBuilder() {
    if (stepInfoCase_ == 11) {
      return (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance();
  }

  public static final int VPC_CONNECTOR_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Display information of a VPC connector.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
   *
   * @return Whether the vpcConnector field is set.
   */
  @java.lang.Override
  public boolean hasVpcConnector() {
    return stepInfoCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Display information of a VPC connector.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
   *
   * @return The vpcConnector.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo getVpcConnector() {
    if (stepInfoCase_ == 21) {
      return (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a VPC connector.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfoOrBuilder
      getVpcConnectorOrBuilder() {
    if (stepInfoCase_ == 21) {
      return (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.getDefaultInstance();
  }

  public static final int DELIVER_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Display information of the final state "deliver" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
   *
   * @return Whether the deliver field is set.
   */
  @java.lang.Override
  public boolean hasDeliver() {
    return stepInfoCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "deliver" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
   *
   * @return The deliver.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.DeliverInfo getDeliver() {
    if (stepInfoCase_ == 12) {
      return (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "deliver" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.DeliverInfoOrBuilder getDeliverOrBuilder() {
    if (stepInfoCase_ == 12) {
      return (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance();
  }

  public static final int FORWARD_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Display information of the final state "forward" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
   *
   * @return Whether the forward field is set.
   */
  @java.lang.Override
  public boolean hasForward() {
    return stepInfoCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "forward" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
   *
   * @return The forward.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ForwardInfo getForward() {
    if (stepInfoCase_ == 13) {
      return (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "forward" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ForwardInfoOrBuilder getForwardOrBuilder() {
    if (stepInfoCase_ == 13) {
      return (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance();
  }

  public static final int ABORT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Display information of the final state "abort" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
   *
   * @return Whether the abort field is set.
   */
  @java.lang.Override
  public boolean hasAbort() {
    return stepInfoCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "abort" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
   *
   * @return The abort.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.AbortInfo getAbort() {
    if (stepInfoCase_ == 14) {
      return (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "abort" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.AbortInfoOrBuilder getAbortOrBuilder() {
    if (stepInfoCase_ == 14) {
      return (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance();
  }

  public static final int DROP_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Display information of the final state "drop" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
   *
   * @return Whether the drop field is set.
   */
  @java.lang.Override
  public boolean hasDrop() {
    return stepInfoCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "drop" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
   *
   * @return The drop.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.DropInfo getDrop() {
    if (stepInfoCase_ == 15) {
      return (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the final state "drop" and reason.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.DropInfoOrBuilder getDropOrBuilder() {
    if (stepInfoCase_ == 15) {
      return (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance();
  }

  public static final int LOAD_BALANCER_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Display information of the load balancers.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
   *
   * @return Whether the loadBalancer field is set.
   */
  @java.lang.Override
  public boolean hasLoadBalancer() {
    return stepInfoCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Display information of the load balancers.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
   *
   * @return The loadBalancer.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo getLoadBalancer() {
    if (stepInfoCase_ == 16) {
      return (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of the load balancers.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfoOrBuilder
      getLoadBalancerOrBuilder() {
    if (stepInfoCase_ == 16) {
      return (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
  }

  public static final int NETWORK_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Display information of a Google Cloud network.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return stepInfoCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Cloud network.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.NetworkInfo getNetwork() {
    if (stepInfoCase_ == 17) {
      return (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Cloud network.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.NetworkInfoOrBuilder getNetworkOrBuilder() {
    if (stepInfoCase_ == 17) {
      return (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance();
  }

  public static final int GKE_MASTER_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Display information of a Google Kubernetes Engine cluster master.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
   *
   * @return Whether the gkeMaster field is set.
   */
  @java.lang.Override
  public boolean hasGkeMaster() {
    return stepInfoCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Kubernetes Engine cluster master.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
   *
   * @return The gkeMaster.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo getGkeMaster() {
    if (stepInfoCase_ == 18) {
      return (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Google Kubernetes Engine cluster master.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.GKEMasterInfoOrBuilder getGkeMasterOrBuilder() {
    if (stepInfoCase_ == 18) {
      return (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance();
  }

  public static final int CLOUD_SQL_INSTANCE_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Display information of a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
   * </code>
   *
   * @return Whether the cloudSqlInstance field is set.
   */
  @java.lang.Override
  public boolean hasCloudSqlInstance() {
    return stepInfoCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
   * </code>
   *
   * @return The cloudSqlInstance.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo getCloudSqlInstance() {
    if (stepInfoCase_ == 19) {
      return (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud SQL instance.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfoOrBuilder
      getCloudSqlInstanceOrBuilder() {
    if (stepInfoCase_ == 19) {
      return (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.getDefaultInstance();
  }

  public static final int CLOUD_FUNCTION_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * Display information of a Cloud function.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
   *
   * @return Whether the cloudFunction field is set.
   */
  @java.lang.Override
  public boolean hasCloudFunction() {
    return stepInfoCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud function.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
   *
   * @return The cloudFunction.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo getCloudFunction() {
    if (stepInfoCase_ == 20) {
      return (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Display information of a Cloud function.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfoOrBuilder
      getCloudFunctionOrBuilder() {
    if (stepInfoCase_ == 20) {
      return (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_;
    }
    return com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
    }
    if (state_
        != com.google.cloud.networkmanagement.v1beta1.Step.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (causesDrop_ != false) {
      output.writeBool(3, causesDrop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, projectId_);
    }
    if (stepInfoCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_);
    }
    if (stepInfoCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_);
    }
    if (stepInfoCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_);
    }
    if (stepInfoCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_);
    }
    if (stepInfoCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_);
    }
    if (stepInfoCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_);
    }
    if (stepInfoCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_);
    }
    if (stepInfoCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_);
    }
    if (stepInfoCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_);
    }
    if (stepInfoCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_);
    }
    if (stepInfoCase_ == 16) {
      output.writeMessage(
          16, (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_);
    }
    if (stepInfoCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_);
    }
    if (stepInfoCase_ == 18) {
      output.writeMessage(18, (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_);
    }
    if (stepInfoCase_ == 19) {
      output.writeMessage(
          19, (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 21) {
      output.writeMessage(
          21, (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
    }
    if (state_
        != com.google.cloud.networkmanagement.v1beta1.Step.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (causesDrop_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, causesDrop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, projectId_);
    }
    if (stepInfoCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_);
    }
    if (stepInfoCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_);
    }
    if (stepInfoCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_);
    }
    if (stepInfoCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_);
    }
    if (stepInfoCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_);
    }
    if (stepInfoCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_);
    }
    if (stepInfoCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_);
    }
    if (stepInfoCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_);
    }
    if (stepInfoCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_);
    }
    if (stepInfoCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_);
    }
    if (stepInfoCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_);
    }
    if (stepInfoCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_);
    }
    if (stepInfoCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_);
    }
    if (stepInfoCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_);
    }
    if (stepInfoCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_);
    }
    if (stepInfoCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.Step)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.Step other =
        (com.google.cloud.networkmanagement.v1beta1.Step) obj;

    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (getCausesDrop() != other.getCausesDrop()) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getStepInfoCase().equals(other.getStepInfoCase())) return false;
    switch (stepInfoCase_) {
      case 5:
        if (!getInstance().equals(other.getInstance())) return false;
        break;
      case 6:
        if (!getFirewall().equals(other.getFirewall())) return false;
        break;
      case 7:
        if (!getRoute().equals(other.getRoute())) return false;
        break;
      case 8:
        if (!getEndpoint().equals(other.getEndpoint())) return false;
        break;
      case 9:
        if (!getForwardingRule().equals(other.getForwardingRule())) return false;
        break;
      case 10:
        if (!getVpnGateway().equals(other.getVpnGateway())) return false;
        break;
      case 11:
        if (!getVpnTunnel().equals(other.getVpnTunnel())) return false;
        break;
      case 21:
        if (!getVpcConnector().equals(other.getVpcConnector())) return false;
        break;
      case 12:
        if (!getDeliver().equals(other.getDeliver())) return false;
        break;
      case 13:
        if (!getForward().equals(other.getForward())) return false;
        break;
      case 14:
        if (!getAbort().equals(other.getAbort())) return false;
        break;
      case 15:
        if (!getDrop().equals(other.getDrop())) return false;
        break;
      case 16:
        if (!getLoadBalancer().equals(other.getLoadBalancer())) return false;
        break;
      case 17:
        if (!getNetwork().equals(other.getNetwork())) return false;
        break;
      case 18:
        if (!getGkeMaster().equals(other.getGkeMaster())) return false;
        break;
      case 19:
        if (!getCloudSqlInstance().equals(other.getCloudSqlInstance())) return false;
        break;
      case 20:
        if (!getCloudFunction().equals(other.getCloudFunction())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CAUSES_DROP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCausesDrop());
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    switch (stepInfoCase_) {
      case 5:
        hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getInstance().hashCode();
        break;
      case 6:
        hash = (37 * hash) + FIREWALL_FIELD_NUMBER;
        hash = (53 * hash) + getFirewall().hashCode();
        break;
      case 7:
        hash = (37 * hash) + ROUTE_FIELD_NUMBER;
        hash = (53 * hash) + getRoute().hashCode();
        break;
      case 8:
        hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getEndpoint().hashCode();
        break;
      case 9:
        hash = (37 * hash) + FORWARDING_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getForwardingRule().hashCode();
        break;
      case 10:
        hash = (37 * hash) + VPN_GATEWAY_FIELD_NUMBER;
        hash = (53 * hash) + getVpnGateway().hashCode();
        break;
      case 11:
        hash = (37 * hash) + VPN_TUNNEL_FIELD_NUMBER;
        hash = (53 * hash) + getVpnTunnel().hashCode();
        break;
      case 21:
        hash = (37 * hash) + VPC_CONNECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getVpcConnector().hashCode();
        break;
      case 12:
        hash = (37 * hash) + DELIVER_FIELD_NUMBER;
        hash = (53 * hash) + getDeliver().hashCode();
        break;
      case 13:
        hash = (37 * hash) + FORWARD_FIELD_NUMBER;
        hash = (53 * hash) + getForward().hashCode();
        break;
      case 14:
        hash = (37 * hash) + ABORT_FIELD_NUMBER;
        hash = (53 * hash) + getAbort().hashCode();
        break;
      case 15:
        hash = (37 * hash) + DROP_FIELD_NUMBER;
        hash = (53 * hash) + getDrop().hashCode();
        break;
      case 16:
        hash = (37 * hash) + LOAD_BALANCER_FIELD_NUMBER;
        hash = (53 * hash) + getLoadBalancer().hashCode();
        break;
      case 17:
        hash = (37 * hash) + NETWORK_FIELD_NUMBER;
        hash = (53 * hash) + getNetwork().hashCode();
        break;
      case 18:
        hash = (37 * hash) + GKE_MASTER_FIELD_NUMBER;
        hash = (53 * hash) + getGkeMaster().hashCode();
        break;
      case 19:
        hash = (37 * hash) + CLOUD_SQL_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudSqlInstance().hashCode();
        break;
      case 20:
        hash = (37 * hash) + CLOUD_FUNCTION_FIELD_NUMBER;
        hash = (53 * hash) + getCloudFunction().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1beta1.Step prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A simulated forwarding path is composed of multiple steps.
   * Each step has a well-defined state and an associated configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.Step}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.Step)
      com.google.cloud.networkmanagement.v1beta1.StepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_Step_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_Step_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.Step.class,
              com.google.cloud.networkmanagement.v1beta1.Step.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.Step.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      description_ = "";

      state_ = 0;

      causesDrop_ = false;

      projectId_ = "";

      if (instanceBuilder_ != null) {
        instanceBuilder_.clear();
      }
      if (firewallBuilder_ != null) {
        firewallBuilder_.clear();
      }
      if (routeBuilder_ != null) {
        routeBuilder_.clear();
      }
      if (endpointBuilder_ != null) {
        endpointBuilder_.clear();
      }
      if (forwardingRuleBuilder_ != null) {
        forwardingRuleBuilder_.clear();
      }
      if (vpnGatewayBuilder_ != null) {
        vpnGatewayBuilder_.clear();
      }
      if (vpnTunnelBuilder_ != null) {
        vpnTunnelBuilder_.clear();
      }
      if (vpcConnectorBuilder_ != null) {
        vpcConnectorBuilder_.clear();
      }
      if (deliverBuilder_ != null) {
        deliverBuilder_.clear();
      }
      if (forwardBuilder_ != null) {
        forwardBuilder_.clear();
      }
      if (abortBuilder_ != null) {
        abortBuilder_.clear();
      }
      if (dropBuilder_ != null) {
        dropBuilder_.clear();
      }
      if (loadBalancerBuilder_ != null) {
        loadBalancerBuilder_.clear();
      }
      if (networkBuilder_ != null) {
        networkBuilder_.clear();
      }
      if (gkeMasterBuilder_ != null) {
        gkeMasterBuilder_.clear();
      }
      if (cloudSqlInstanceBuilder_ != null) {
        cloudSqlInstanceBuilder_.clear();
      }
      if (cloudFunctionBuilder_ != null) {
        cloudFunctionBuilder_.clear();
      }
      stepInfoCase_ = 0;
      stepInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_Step_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Step getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.Step.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Step build() {
      com.google.cloud.networkmanagement.v1beta1.Step result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Step buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.Step result =
          new com.google.cloud.networkmanagement.v1beta1.Step(this);
      result.description_ = description_;
      result.state_ = state_;
      result.causesDrop_ = causesDrop_;
      result.projectId_ = projectId_;
      if (stepInfoCase_ == 5) {
        if (instanceBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = instanceBuilder_.build();
        }
      }
      if (stepInfoCase_ == 6) {
        if (firewallBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = firewallBuilder_.build();
        }
      }
      if (stepInfoCase_ == 7) {
        if (routeBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = routeBuilder_.build();
        }
      }
      if (stepInfoCase_ == 8) {
        if (endpointBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = endpointBuilder_.build();
        }
      }
      if (stepInfoCase_ == 9) {
        if (forwardingRuleBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = forwardingRuleBuilder_.build();
        }
      }
      if (stepInfoCase_ == 10) {
        if (vpnGatewayBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = vpnGatewayBuilder_.build();
        }
      }
      if (stepInfoCase_ == 11) {
        if (vpnTunnelBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = vpnTunnelBuilder_.build();
        }
      }
      if (stepInfoCase_ == 21) {
        if (vpcConnectorBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = vpcConnectorBuilder_.build();
        }
      }
      if (stepInfoCase_ == 12) {
        if (deliverBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = deliverBuilder_.build();
        }
      }
      if (stepInfoCase_ == 13) {
        if (forwardBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = forwardBuilder_.build();
        }
      }
      if (stepInfoCase_ == 14) {
        if (abortBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = abortBuilder_.build();
        }
      }
      if (stepInfoCase_ == 15) {
        if (dropBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = dropBuilder_.build();
        }
      }
      if (stepInfoCase_ == 16) {
        if (loadBalancerBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = loadBalancerBuilder_.build();
        }
      }
      if (stepInfoCase_ == 17) {
        if (networkBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = networkBuilder_.build();
        }
      }
      if (stepInfoCase_ == 18) {
        if (gkeMasterBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = gkeMasterBuilder_.build();
        }
      }
      if (stepInfoCase_ == 19) {
        if (cloudSqlInstanceBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = cloudSqlInstanceBuilder_.build();
        }
      }
      if (stepInfoCase_ == 20) {
        if (cloudFunctionBuilder_ == null) {
          result.stepInfo_ = stepInfo_;
        } else {
          result.stepInfo_ = cloudFunctionBuilder_.build();
        }
      }
      result.stepInfoCase_ = stepInfoCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.Step) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.Step) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.Step other) {
      if (other == com.google.cloud.networkmanagement.v1beta1.Step.getDefaultInstance())
        return this;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getCausesDrop() != false) {
        setCausesDrop(other.getCausesDrop());
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      switch (other.getStepInfoCase()) {
        case INSTANCE:
          {
            mergeInstance(other.getInstance());
            break;
          }
        case FIREWALL:
          {
            mergeFirewall(other.getFirewall());
            break;
          }
        case ROUTE:
          {
            mergeRoute(other.getRoute());
            break;
          }
        case ENDPOINT:
          {
            mergeEndpoint(other.getEndpoint());
            break;
          }
        case FORWARDING_RULE:
          {
            mergeForwardingRule(other.getForwardingRule());
            break;
          }
        case VPN_GATEWAY:
          {
            mergeVpnGateway(other.getVpnGateway());
            break;
          }
        case VPN_TUNNEL:
          {
            mergeVpnTunnel(other.getVpnTunnel());
            break;
          }
        case VPC_CONNECTOR:
          {
            mergeVpcConnector(other.getVpcConnector());
            break;
          }
        case DELIVER:
          {
            mergeDeliver(other.getDeliver());
            break;
          }
        case FORWARD:
          {
            mergeForward(other.getForward());
            break;
          }
        case ABORT:
          {
            mergeAbort(other.getAbort());
            break;
          }
        case DROP:
          {
            mergeDrop(other.getDrop());
            break;
          }
        case LOAD_BALANCER:
          {
            mergeLoadBalancer(other.getLoadBalancer());
            break;
          }
        case NETWORK:
          {
            mergeNetwork(other.getNetwork());
            break;
          }
        case GKE_MASTER:
          {
            mergeGkeMaster(other.getGkeMaster());
            break;
          }
        case CLOUD_SQL_INSTANCE:
          {
            mergeCloudSqlInstance(other.getCloudSqlInstance());
            break;
          }
        case CLOUD_FUNCTION:
          {
            mergeCloudFunction(other.getCloudFunction());
            break;
          }
        case STEPINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();

                break;
              } // case 16
            case 24:
              {
                causesDrop_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                projectId_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getInstanceFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getFirewallFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getRouteFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndpointFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getForwardingRuleFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getVpnGatewayFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getVpnTunnelFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDeliverFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getForwardFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getAbortFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getDropFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getLoadBalancerFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getNetworkFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getGkeMasterFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getCloudSqlInstanceFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getCloudFunctionFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getVpcConnectorFieldBuilder().getBuilder(), extensionRegistry);
                stepInfoCase_ = 21;
                break;
              } // case 170
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int stepInfoCase_ = 0;
    private java.lang.Object stepInfo_;

    public StepInfoCase getStepInfoCase() {
      return StepInfoCase.forNumber(stepInfoCase_);
    }

    public Builder clearStepInfo() {
      stepInfoCase_ = 0;
      stepInfo_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the step. Usually this is a summary of the state.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.Step.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.Step.State result =
          com.google.cloud.networkmanagement.v1beta1.Step.State.valueOf(state_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.Step.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.networkmanagement.v1beta1.Step.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Each step is in one of the pre-defined states.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.Step.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private boolean causesDrop_;
    /**
     *
     *
     * <pre>
     * This is a step that leads to the final state Drop.
     * </pre>
     *
     * <code>bool causes_drop = 3;</code>
     *
     * @return The causesDrop.
     */
    @java.lang.Override
    public boolean getCausesDrop() {
      return causesDrop_;
    }
    /**
     *
     *
     * <pre>
     * This is a step that leads to the final state Drop.
     * </pre>
     *
     * <code>bool causes_drop = 3;</code>
     *
     * @param value The causesDrop to set.
     * @return This builder for chaining.
     */
    public Builder setCausesDrop(boolean value) {

      causesDrop_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is a step that leads to the final state Drop.
     * </pre>
     *
     * <code>bool causes_drop = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCausesDrop() {

      causesDrop_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID that contains the configuration this step is validating.
     * </pre>
     *
     * <code>string project_id = 4;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.InstanceInfo,
            com.google.cloud.networkmanagement.v1beta1.InstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.InstanceInfoOrBuilder>
        instanceBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     *
     * @return Whether the instance field is set.
     */
    @java.lang.Override
    public boolean hasInstance() {
      return stepInfoCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     *
     * @return The instance.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.InstanceInfo getInstance() {
      if (instanceBuilder_ == null) {
        if (stepInfoCase_ == 5) {
          return (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 5) {
          return instanceBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    public Builder setInstance(com.google.cloud.networkmanagement.v1beta1.InstanceInfo value) {
      if (instanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        instanceBuilder_.setMessage(value);
      }
      stepInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    public Builder setInstance(
        com.google.cloud.networkmanagement.v1beta1.InstanceInfo.Builder builderForValue) {
      if (instanceBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        instanceBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    public Builder mergeInstance(com.google.cloud.networkmanagement.v1beta1.InstanceInfo value) {
      if (instanceBuilder_ == null) {
        if (stepInfoCase_ == 5
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.InstanceInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 5) {
          instanceBuilder_.mergeFrom(value);
        } else {
          instanceBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    public Builder clearInstance() {
      if (instanceBuilder_ == null) {
        if (stepInfoCase_ == 5) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 5) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        instanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.InstanceInfo.Builder getInstanceBuilder() {
      return getInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.InstanceInfoOrBuilder getInstanceOrBuilder() {
      if ((stepInfoCase_ == 5) && (instanceBuilder_ != null)) {
        return instanceBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 5) {
          return (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.InstanceInfo instance = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.InstanceInfo,
            com.google.cloud.networkmanagement.v1beta1.InstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.InstanceInfoOrBuilder>
        getInstanceFieldBuilder() {
      if (instanceBuilder_ == null) {
        if (!(stepInfoCase_ == 5)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.InstanceInfo.getDefaultInstance();
        }
        instanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.InstanceInfo,
                com.google.cloud.networkmanagement.v1beta1.InstanceInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.InstanceInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.InstanceInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 5;
      onChanged();
      ;
      return instanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.FirewallInfo,
            com.google.cloud.networkmanagement.v1beta1.FirewallInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.FirewallInfoOrBuilder>
        firewallBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     *
     * @return Whether the firewall field is set.
     */
    @java.lang.Override
    public boolean hasFirewall() {
      return stepInfoCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     *
     * @return The firewall.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.FirewallInfo getFirewall() {
      if (firewallBuilder_ == null) {
        if (stepInfoCase_ == 6) {
          return (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 6) {
          return firewallBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    public Builder setFirewall(com.google.cloud.networkmanagement.v1beta1.FirewallInfo value) {
      if (firewallBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        firewallBuilder_.setMessage(value);
      }
      stepInfoCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    public Builder setFirewall(
        com.google.cloud.networkmanagement.v1beta1.FirewallInfo.Builder builderForValue) {
      if (firewallBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        firewallBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    public Builder mergeFirewall(com.google.cloud.networkmanagement.v1beta1.FirewallInfo value) {
      if (firewallBuilder_ == null) {
        if (stepInfoCase_ == 6
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.FirewallInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 6) {
          firewallBuilder_.mergeFrom(value);
        } else {
          firewallBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    public Builder clearFirewall() {
      if (firewallBuilder_ == null) {
        if (stepInfoCase_ == 6) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 6) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        firewallBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.FirewallInfo.Builder getFirewallBuilder() {
      return getFirewallFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.FirewallInfoOrBuilder getFirewallOrBuilder() {
      if ((stepInfoCase_ == 6) && (firewallBuilder_ != null)) {
        return firewallBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 6) {
          return (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine firewall rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.FirewallInfo firewall = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.FirewallInfo,
            com.google.cloud.networkmanagement.v1beta1.FirewallInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.FirewallInfoOrBuilder>
        getFirewallFieldBuilder() {
      if (firewallBuilder_ == null) {
        if (!(stepInfoCase_ == 6)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.FirewallInfo.getDefaultInstance();
        }
        firewallBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.FirewallInfo,
                com.google.cloud.networkmanagement.v1beta1.FirewallInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.FirewallInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.FirewallInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 6;
      onChanged();
      ;
      return firewallBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.RouteInfo,
            com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.RouteInfoOrBuilder>
        routeBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     *
     * @return Whether the route field is set.
     */
    @java.lang.Override
    public boolean hasRoute() {
      return stepInfoCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     *
     * @return The route.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo getRoute() {
      if (routeBuilder_ == null) {
        if (stepInfoCase_ == 7) {
          return (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 7) {
          return routeBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    public Builder setRoute(com.google.cloud.networkmanagement.v1beta1.RouteInfo value) {
      if (routeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        routeBuilder_.setMessage(value);
      }
      stepInfoCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    public Builder setRoute(
        com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder builderForValue) {
      if (routeBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        routeBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    public Builder mergeRoute(com.google.cloud.networkmanagement.v1beta1.RouteInfo value) {
      if (routeBuilder_ == null) {
        if (stepInfoCase_ == 7
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.RouteInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 7) {
          routeBuilder_.mergeFrom(value);
        } else {
          routeBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    public Builder clearRoute() {
      if (routeBuilder_ == null) {
        if (stepInfoCase_ == 7) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 7) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        routeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder getRouteBuilder() {
      return getRouteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfoOrBuilder getRouteOrBuilder() {
      if ((stepInfoCase_ == 7) && (routeBuilder_ != null)) {
        return routeBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 7) {
          return (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo route = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.RouteInfo,
            com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.RouteInfoOrBuilder>
        getRouteFieldBuilder() {
      if (routeBuilder_ == null) {
        if (!(stepInfoCase_ == 7)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
        }
        routeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.RouteInfo,
                com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.RouteInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.RouteInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 7;
      onChanged();
      ;
      return routeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder>
        endpointBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     *
     * @return Whether the endpoint field is set.
     */
    @java.lang.Override
    public boolean hasEndpoint() {
      return stepInfoCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.EndpointInfo getEndpoint() {
      if (endpointBuilder_ == null) {
        if (stepInfoCase_ == 8) {
          return (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 8) {
          return endpointBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    public Builder setEndpoint(com.google.cloud.networkmanagement.v1beta1.EndpointInfo value) {
      if (endpointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        endpointBuilder_.setMessage(value);
      }
      stepInfoCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    public Builder setEndpoint(
        com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder builderForValue) {
      if (endpointBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        endpointBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    public Builder mergeEndpoint(com.google.cloud.networkmanagement.v1beta1.EndpointInfo value) {
      if (endpointBuilder_ == null) {
        if (stepInfoCase_ == 8
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.EndpointInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 8) {
          endpointBuilder_.mergeFrom(value);
        } else {
          endpointBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    public Builder clearEndpoint() {
      if (endpointBuilder_ == null) {
        if (stepInfoCase_ == 8) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 8) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        endpointBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder getEndpointBuilder() {
      return getEndpointFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder getEndpointOrBuilder() {
      if ((stepInfoCase_ == 8) && (endpointBuilder_ != null)) {
        return endpointBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 8) {
          return (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the source and destination under analysis.
     * The endpoint information in an intermediate state may differ with the
     * initial input, as it might be modified by state like NAT,
     * or Connection Proxy.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder>
        getEndpointFieldBuilder() {
      if (endpointBuilder_ == null) {
        if (!(stepInfoCase_ == 8)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance();
        }
        endpointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.EndpointInfo,
                com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.EndpointInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 8;
      onChanged();
      ;
      return endpointBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo,
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfoOrBuilder>
        forwardingRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     *
     * @return Whether the forwardingRule field is set.
     */
    @java.lang.Override
    public boolean hasForwardingRule() {
      return stepInfoCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     *
     * @return The forwardingRule.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo getForwardingRule() {
      if (forwardingRuleBuilder_ == null) {
        if (stepInfoCase_ == 9) {
          return (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 9) {
          return forwardingRuleBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder setForwardingRule(
        com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo value) {
      if (forwardingRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        forwardingRuleBuilder_.setMessage(value);
      }
      stepInfoCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder setForwardingRule(
        com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder builderForValue) {
      if (forwardingRuleBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        forwardingRuleBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder mergeForwardingRule(
        com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo value) {
      if (forwardingRuleBuilder_ == null) {
        if (stepInfoCase_ == 9
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 9) {
          forwardingRuleBuilder_.mergeFrom(value);
        } else {
          forwardingRuleBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public Builder clearForwardingRule() {
      if (forwardingRuleBuilder_ == null) {
        if (stepInfoCase_ == 9) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 9) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        forwardingRuleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder
        getForwardingRuleBuilder() {
      return getForwardingRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfoOrBuilder
        getForwardingRuleOrBuilder() {
      if ((stepInfoCase_ == 9) && (forwardingRuleBuilder_ != null)) {
        return forwardingRuleBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 9) {
          return (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine forwarding rule.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo forwarding_rule = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo,
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfoOrBuilder>
        getForwardingRuleFieldBuilder() {
      if (forwardingRuleBuilder_ == null) {
        if (!(stepInfoCase_ == 9)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.getDefaultInstance();
        }
        forwardingRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo,
                com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.ForwardingRuleInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 9;
      onChanged();
      ;
      return forwardingRuleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo,
            com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfoOrBuilder>
        vpnGatewayBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     *
     * @return Whether the vpnGateway field is set.
     */
    @java.lang.Override
    public boolean hasVpnGateway() {
      return stepInfoCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     *
     * @return The vpnGateway.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo getVpnGateway() {
      if (vpnGatewayBuilder_ == null) {
        if (stepInfoCase_ == 10) {
          return (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 10) {
          return vpnGatewayBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder setVpnGateway(com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo value) {
      if (vpnGatewayBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        vpnGatewayBuilder_.setMessage(value);
      }
      stepInfoCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder setVpnGateway(
        com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.Builder builderForValue) {
      if (vpnGatewayBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        vpnGatewayBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder mergeVpnGateway(
        com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo value) {
      if (vpnGatewayBuilder_ == null) {
        if (stepInfoCase_ == 10
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 10) {
          vpnGatewayBuilder_.mergeFrom(value);
        } else {
          vpnGatewayBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public Builder clearVpnGateway() {
      if (vpnGatewayBuilder_ == null) {
        if (stepInfoCase_ == 10) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 10) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        vpnGatewayBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.Builder
        getVpnGatewayBuilder() {
      return getVpnGatewayFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfoOrBuilder
        getVpnGatewayOrBuilder() {
      if ((stepInfoCase_ == 10) && (vpnGatewayBuilder_ != null)) {
        return vpnGatewayBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 10) {
          return (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN gateway.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo vpn_gateway = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo,
            com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfoOrBuilder>
        getVpnGatewayFieldBuilder() {
      if (vpnGatewayBuilder_ == null) {
        if (!(stepInfoCase_ == 10)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.getDefaultInstance();
        }
        vpnGatewayBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo,
                com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.VpnGatewayInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 10;
      onChanged();
      ;
      return vpnGatewayBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo,
            com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfoOrBuilder>
        vpnTunnelBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     *
     * @return Whether the vpnTunnel field is set.
     */
    @java.lang.Override
    public boolean hasVpnTunnel() {
      return stepInfoCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     *
     * @return The vpnTunnel.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo getVpnTunnel() {
      if (vpnTunnelBuilder_ == null) {
        if (stepInfoCase_ == 11) {
          return (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 11) {
          return vpnTunnelBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder setVpnTunnel(com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo value) {
      if (vpnTunnelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        vpnTunnelBuilder_.setMessage(value);
      }
      stepInfoCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder setVpnTunnel(
        com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.Builder builderForValue) {
      if (vpnTunnelBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        vpnTunnelBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder mergeVpnTunnel(com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo value) {
      if (vpnTunnelBuilder_ == null) {
        if (stepInfoCase_ == 11
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 11) {
          vpnTunnelBuilder_.mergeFrom(value);
        } else {
          vpnTunnelBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public Builder clearVpnTunnel() {
      if (vpnTunnelBuilder_ == null) {
        if (stepInfoCase_ == 11) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 11) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        vpnTunnelBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.Builder getVpnTunnelBuilder() {
      return getVpnTunnelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfoOrBuilder
        getVpnTunnelOrBuilder() {
      if ((stepInfoCase_ == 11) && (vpnTunnelBuilder_ != null)) {
        return vpnTunnelBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 11) {
          return (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Compute Engine VPN tunnel.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo vpn_tunnel = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo,
            com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfoOrBuilder>
        getVpnTunnelFieldBuilder() {
      if (vpnTunnelBuilder_ == null) {
        if (!(stepInfoCase_ == 11)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.getDefaultInstance();
        }
        vpnTunnelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo,
                com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.VpnTunnelInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 11;
      onChanged();
      ;
      return vpnTunnelBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo,
            com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfoOrBuilder>
        vpcConnectorBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     *
     * @return Whether the vpcConnector field is set.
     */
    @java.lang.Override
    public boolean hasVpcConnector() {
      return stepInfoCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     *
     * @return The vpcConnector.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo getVpcConnector() {
      if (vpcConnectorBuilder_ == null) {
        if (stepInfoCase_ == 21) {
          return (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 21) {
          return vpcConnectorBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder setVpcConnector(
        com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo value) {
      if (vpcConnectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        vpcConnectorBuilder_.setMessage(value);
      }
      stepInfoCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder setVpcConnector(
        com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.Builder builderForValue) {
      if (vpcConnectorBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        vpcConnectorBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder mergeVpcConnector(
        com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo value) {
      if (vpcConnectorBuilder_ == null) {
        if (stepInfoCase_ == 21
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 21) {
          vpcConnectorBuilder_.mergeFrom(value);
        } else {
          vpcConnectorBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public Builder clearVpcConnector() {
      if (vpcConnectorBuilder_ == null) {
        if (stepInfoCase_ == 21) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 21) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        vpcConnectorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.Builder
        getVpcConnectorBuilder() {
      return getVpcConnectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfoOrBuilder
        getVpcConnectorOrBuilder() {
      if ((stepInfoCase_ == 21) && (vpcConnectorBuilder_ != null)) {
        return vpcConnectorBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 21) {
          return (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a VPC connector.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo vpc_connector = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo,
            com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfoOrBuilder>
        getVpcConnectorFieldBuilder() {
      if (vpcConnectorBuilder_ == null) {
        if (!(stepInfoCase_ == 21)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.getDefaultInstance();
        }
        vpcConnectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo,
                com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.VpcConnectorInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 21;
      onChanged();
      ;
      return vpcConnectorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.DeliverInfo,
            com.google.cloud.networkmanagement.v1beta1.DeliverInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.DeliverInfoOrBuilder>
        deliverBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     *
     * @return Whether the deliver field is set.
     */
    @java.lang.Override
    public boolean hasDeliver() {
      return stepInfoCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     *
     * @return The deliver.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.DeliverInfo getDeliver() {
      if (deliverBuilder_ == null) {
        if (stepInfoCase_ == 12) {
          return (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 12) {
          return deliverBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    public Builder setDeliver(com.google.cloud.networkmanagement.v1beta1.DeliverInfo value) {
      if (deliverBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        deliverBuilder_.setMessage(value);
      }
      stepInfoCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    public Builder setDeliver(
        com.google.cloud.networkmanagement.v1beta1.DeliverInfo.Builder builderForValue) {
      if (deliverBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        deliverBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    public Builder mergeDeliver(com.google.cloud.networkmanagement.v1beta1.DeliverInfo value) {
      if (deliverBuilder_ == null) {
        if (stepInfoCase_ == 12
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.DeliverInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 12) {
          deliverBuilder_.mergeFrom(value);
        } else {
          deliverBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    public Builder clearDeliver() {
      if (deliverBuilder_ == null) {
        if (stepInfoCase_ == 12) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 12) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        deliverBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.DeliverInfo.Builder getDeliverBuilder() {
      return getDeliverFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.DeliverInfoOrBuilder getDeliverOrBuilder() {
      if ((stepInfoCase_ == 12) && (deliverBuilder_ != null)) {
        return deliverBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 12) {
          return (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "deliver" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DeliverInfo deliver = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.DeliverInfo,
            com.google.cloud.networkmanagement.v1beta1.DeliverInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.DeliverInfoOrBuilder>
        getDeliverFieldBuilder() {
      if (deliverBuilder_ == null) {
        if (!(stepInfoCase_ == 12)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.DeliverInfo.getDefaultInstance();
        }
        deliverBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.DeliverInfo,
                com.google.cloud.networkmanagement.v1beta1.DeliverInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.DeliverInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.DeliverInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 12;
      onChanged();
      ;
      return deliverBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ForwardInfo,
            com.google.cloud.networkmanagement.v1beta1.ForwardInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.ForwardInfoOrBuilder>
        forwardBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     *
     * @return Whether the forward field is set.
     */
    @java.lang.Override
    public boolean hasForward() {
      return stepInfoCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     *
     * @return The forward.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardInfo getForward() {
      if (forwardBuilder_ == null) {
        if (stepInfoCase_ == 13) {
          return (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 13) {
          return forwardBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    public Builder setForward(com.google.cloud.networkmanagement.v1beta1.ForwardInfo value) {
      if (forwardBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        forwardBuilder_.setMessage(value);
      }
      stepInfoCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    public Builder setForward(
        com.google.cloud.networkmanagement.v1beta1.ForwardInfo.Builder builderForValue) {
      if (forwardBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        forwardBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    public Builder mergeForward(com.google.cloud.networkmanagement.v1beta1.ForwardInfo value) {
      if (forwardBuilder_ == null) {
        if (stepInfoCase_ == 13
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.ForwardInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 13) {
          forwardBuilder_.mergeFrom(value);
        } else {
          forwardBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    public Builder clearForward() {
      if (forwardBuilder_ == null) {
        if (stepInfoCase_ == 13) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 13) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        forwardBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ForwardInfo.Builder getForwardBuilder() {
      return getForwardFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ForwardInfoOrBuilder getForwardOrBuilder() {
      if ((stepInfoCase_ == 13) && (forwardBuilder_ != null)) {
        return forwardBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 13) {
          return (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "forward" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ForwardInfo forward = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ForwardInfo,
            com.google.cloud.networkmanagement.v1beta1.ForwardInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.ForwardInfoOrBuilder>
        getForwardFieldBuilder() {
      if (forwardBuilder_ == null) {
        if (!(stepInfoCase_ == 13)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.ForwardInfo.getDefaultInstance();
        }
        forwardBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.ForwardInfo,
                com.google.cloud.networkmanagement.v1beta1.ForwardInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.ForwardInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.ForwardInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 13;
      onChanged();
      ;
      return forwardBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.AbortInfo,
            com.google.cloud.networkmanagement.v1beta1.AbortInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.AbortInfoOrBuilder>
        abortBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     *
     * @return Whether the abort field is set.
     */
    @java.lang.Override
    public boolean hasAbort() {
      return stepInfoCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     *
     * @return The abort.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.AbortInfo getAbort() {
      if (abortBuilder_ == null) {
        if (stepInfoCase_ == 14) {
          return (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 14) {
          return abortBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    public Builder setAbort(com.google.cloud.networkmanagement.v1beta1.AbortInfo value) {
      if (abortBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        abortBuilder_.setMessage(value);
      }
      stepInfoCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    public Builder setAbort(
        com.google.cloud.networkmanagement.v1beta1.AbortInfo.Builder builderForValue) {
      if (abortBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        abortBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    public Builder mergeAbort(com.google.cloud.networkmanagement.v1beta1.AbortInfo value) {
      if (abortBuilder_ == null) {
        if (stepInfoCase_ == 14
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.AbortInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 14) {
          abortBuilder_.mergeFrom(value);
        } else {
          abortBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    public Builder clearAbort() {
      if (abortBuilder_ == null) {
        if (stepInfoCase_ == 14) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 14) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        abortBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.AbortInfo.Builder getAbortBuilder() {
      return getAbortFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.AbortInfoOrBuilder getAbortOrBuilder() {
      if ((stepInfoCase_ == 14) && (abortBuilder_ != null)) {
        return abortBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 14) {
          return (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "abort" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.AbortInfo abort = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.AbortInfo,
            com.google.cloud.networkmanagement.v1beta1.AbortInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.AbortInfoOrBuilder>
        getAbortFieldBuilder() {
      if (abortBuilder_ == null) {
        if (!(stepInfoCase_ == 14)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.AbortInfo.getDefaultInstance();
        }
        abortBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.AbortInfo,
                com.google.cloud.networkmanagement.v1beta1.AbortInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.AbortInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.AbortInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 14;
      onChanged();
      ;
      return abortBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.DropInfo,
            com.google.cloud.networkmanagement.v1beta1.DropInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.DropInfoOrBuilder>
        dropBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     *
     * @return Whether the drop field is set.
     */
    @java.lang.Override
    public boolean hasDrop() {
      return stepInfoCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     *
     * @return The drop.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.DropInfo getDrop() {
      if (dropBuilder_ == null) {
        if (stepInfoCase_ == 15) {
          return (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 15) {
          return dropBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    public Builder setDrop(com.google.cloud.networkmanagement.v1beta1.DropInfo value) {
      if (dropBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        dropBuilder_.setMessage(value);
      }
      stepInfoCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    public Builder setDrop(
        com.google.cloud.networkmanagement.v1beta1.DropInfo.Builder builderForValue) {
      if (dropBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        dropBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    public Builder mergeDrop(com.google.cloud.networkmanagement.v1beta1.DropInfo value) {
      if (dropBuilder_ == null) {
        if (stepInfoCase_ == 15
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.DropInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 15) {
          dropBuilder_.mergeFrom(value);
        } else {
          dropBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    public Builder clearDrop() {
      if (dropBuilder_ == null) {
        if (stepInfoCase_ == 15) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 15) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        dropBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.DropInfo.Builder getDropBuilder() {
      return getDropFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.DropInfoOrBuilder getDropOrBuilder() {
      if ((stepInfoCase_ == 15) && (dropBuilder_ != null)) {
        return dropBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 15) {
          return (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the final state "drop" and reason.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.DropInfo drop = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.DropInfo,
            com.google.cloud.networkmanagement.v1beta1.DropInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.DropInfoOrBuilder>
        getDropFieldBuilder() {
      if (dropBuilder_ == null) {
        if (!(stepInfoCase_ == 15)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.DropInfo.getDefaultInstance();
        }
        dropBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.DropInfo,
                com.google.cloud.networkmanagement.v1beta1.DropInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.DropInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.DropInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 15;
      onChanged();
      ;
      return dropBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfoOrBuilder>
        loadBalancerBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     *
     * @return Whether the loadBalancer field is set.
     */
    @java.lang.Override
    public boolean hasLoadBalancer() {
      return stepInfoCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     *
     * @return The loadBalancer.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo getLoadBalancer() {
      if (loadBalancerBuilder_ == null) {
        if (stepInfoCase_ == 16) {
          return (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 16) {
          return loadBalancerBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    public Builder setLoadBalancer(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo value) {
      if (loadBalancerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        loadBalancerBuilder_.setMessage(value);
      }
      stepInfoCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    public Builder setLoadBalancer(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder builderForValue) {
      if (loadBalancerBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        loadBalancerBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    public Builder mergeLoadBalancer(
        com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo value) {
      if (loadBalancerBuilder_ == null) {
        if (stepInfoCase_ == 16
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 16) {
          loadBalancerBuilder_.mergeFrom(value);
        } else {
          loadBalancerBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    public Builder clearLoadBalancer() {
      if (loadBalancerBuilder_ == null) {
        if (stepInfoCase_ == 16) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 16) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        loadBalancerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder
        getLoadBalancerBuilder() {
      return getLoadBalancerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfoOrBuilder
        getLoadBalancerOrBuilder() {
      if ((stepInfoCase_ == 16) && (loadBalancerBuilder_ != null)) {
        return loadBalancerBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 16) {
          return (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of the load balancers.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo load_balancer = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfoOrBuilder>
        getLoadBalancerFieldBuilder() {
      if (loadBalancerBuilder_ == null) {
        if (!(stepInfoCase_ == 16)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.getDefaultInstance();
        }
        loadBalancerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo,
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.LoadBalancerInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 16;
      onChanged();
      ;
      return loadBalancerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.NetworkInfo,
            com.google.cloud.networkmanagement.v1beta1.NetworkInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.NetworkInfoOrBuilder>
        networkBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     *
     * @return Whether the network field is set.
     */
    @java.lang.Override
    public boolean hasNetwork() {
      return stepInfoCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     *
     * @return The network.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.NetworkInfo getNetwork() {
      if (networkBuilder_ == null) {
        if (stepInfoCase_ == 17) {
          return (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 17) {
          return networkBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    public Builder setNetwork(com.google.cloud.networkmanagement.v1beta1.NetworkInfo value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        networkBuilder_.setMessage(value);
      }
      stepInfoCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    public Builder setNetwork(
        com.google.cloud.networkmanagement.v1beta1.NetworkInfo.Builder builderForValue) {
      if (networkBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    public Builder mergeNetwork(com.google.cloud.networkmanagement.v1beta1.NetworkInfo value) {
      if (networkBuilder_ == null) {
        if (stepInfoCase_ == 17
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.NetworkInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 17) {
          networkBuilder_.mergeFrom(value);
        } else {
          networkBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    public Builder clearNetwork() {
      if (networkBuilder_ == null) {
        if (stepInfoCase_ == 17) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 17) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        networkBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.NetworkInfo.Builder getNetworkBuilder() {
      return getNetworkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.NetworkInfoOrBuilder getNetworkOrBuilder() {
      if ((stepInfoCase_ == 17) && (networkBuilder_ != null)) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 17) {
          return (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Cloud network.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.NetworkInfo network = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.NetworkInfo,
            com.google.cloud.networkmanagement.v1beta1.NetworkInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.NetworkInfoOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        if (!(stepInfoCase_ == 17)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.NetworkInfo.getDefaultInstance();
        }
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.NetworkInfo,
                com.google.cloud.networkmanagement.v1beta1.NetworkInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.NetworkInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.NetworkInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 17;
      onChanged();
      ;
      return networkBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo,
            com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.GKEMasterInfoOrBuilder>
        gkeMasterBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     *
     * @return Whether the gkeMaster field is set.
     */
    @java.lang.Override
    public boolean hasGkeMaster() {
      return stepInfoCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     *
     * @return The gkeMaster.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo getGkeMaster() {
      if (gkeMasterBuilder_ == null) {
        if (stepInfoCase_ == 18) {
          return (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 18) {
          return gkeMasterBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder setGkeMaster(com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo value) {
      if (gkeMasterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        gkeMasterBuilder_.setMessage(value);
      }
      stepInfoCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder setGkeMaster(
        com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.Builder builderForValue) {
      if (gkeMasterBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        gkeMasterBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder mergeGkeMaster(com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo value) {
      if (gkeMasterBuilder_ == null) {
        if (stepInfoCase_ == 18
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 18) {
          gkeMasterBuilder_.mergeFrom(value);
        } else {
          gkeMasterBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    public Builder clearGkeMaster() {
      if (gkeMasterBuilder_ == null) {
        if (stepInfoCase_ == 18) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 18) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        gkeMasterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.Builder getGkeMasterBuilder() {
      return getGkeMasterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.GKEMasterInfoOrBuilder
        getGkeMasterOrBuilder() {
      if ((stepInfoCase_ == 18) && (gkeMasterBuilder_ != null)) {
        return gkeMasterBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 18) {
          return (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Google Kubernetes Engine cluster master.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.GKEMasterInfo gke_master = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo,
            com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.GKEMasterInfoOrBuilder>
        getGkeMasterFieldBuilder() {
      if (gkeMasterBuilder_ == null) {
        if (!(stepInfoCase_ == 18)) {
          stepInfo_ = com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.getDefaultInstance();
        }
        gkeMasterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo,
                com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.GKEMasterInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.GKEMasterInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 18;
      onChanged();
      ;
      return gkeMasterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo,
            com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfoOrBuilder>
        cloudSqlInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     *
     * @return Whether the cloudSqlInstance field is set.
     */
    @java.lang.Override
    public boolean hasCloudSqlInstance() {
      return stepInfoCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     *
     * @return The cloudSqlInstance.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo getCloudSqlInstance() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (stepInfoCase_ == 19) {
          return (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 19) {
          return cloudSqlInstanceBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    public Builder setCloudSqlInstance(
        com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo value) {
      if (cloudSqlInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        cloudSqlInstanceBuilder_.setMessage(value);
      }
      stepInfoCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    public Builder setCloudSqlInstance(
        com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.Builder builderForValue) {
      if (cloudSqlInstanceBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        cloudSqlInstanceBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    public Builder mergeCloudSqlInstance(
        com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo value) {
      if (cloudSqlInstanceBuilder_ == null) {
        if (stepInfoCase_ == 19
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 19) {
          cloudSqlInstanceBuilder_.mergeFrom(value);
        } else {
          cloudSqlInstanceBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    public Builder clearCloudSqlInstance() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (stepInfoCase_ == 19) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 19) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        cloudSqlInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.Builder
        getCloudSqlInstanceBuilder() {
      return getCloudSqlInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfoOrBuilder
        getCloudSqlInstanceOrBuilder() {
      if ((stepInfoCase_ == 19) && (cloudSqlInstanceBuilder_ != null)) {
        return cloudSqlInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 19) {
          return (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud SQL instance.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo cloud_sql_instance = 19;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo,
            com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfoOrBuilder>
        getCloudSqlInstanceFieldBuilder() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (!(stepInfoCase_ == 19)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.getDefaultInstance();
        }
        cloudSqlInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo,
                com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.CloudSQLInstanceInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 19;
      onChanged();
      ;
      return cloudSqlInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo,
            com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfoOrBuilder>
        cloudFunctionBuilder_;
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     *
     * @return Whether the cloudFunction field is set.
     */
    @java.lang.Override
    public boolean hasCloudFunction() {
      return stepInfoCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     *
     * @return The cloudFunction.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo getCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        if (stepInfoCase_ == 20) {
          return (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.getDefaultInstance();
      } else {
        if (stepInfoCase_ == 20) {
          return cloudFunctionBuilder_.getMessage();
        }
        return com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder setCloudFunction(
        com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo value) {
      if (cloudFunctionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepInfo_ = value;
        onChanged();
      } else {
        cloudFunctionBuilder_.setMessage(value);
      }
      stepInfoCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder setCloudFunction(
        com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.Builder builderForValue) {
      if (cloudFunctionBuilder_ == null) {
        stepInfo_ = builderForValue.build();
        onChanged();
      } else {
        cloudFunctionBuilder_.setMessage(builderForValue.build());
      }
      stepInfoCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder mergeCloudFunction(
        com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo value) {
      if (cloudFunctionBuilder_ == null) {
        if (stepInfoCase_ == 20
            && stepInfo_
                != com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo
                    .getDefaultInstance()) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.newBuilder(
                      (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepInfo_ = value;
        }
        onChanged();
      } else {
        if (stepInfoCase_ == 20) {
          cloudFunctionBuilder_.mergeFrom(value);
        } else {
          cloudFunctionBuilder_.setMessage(value);
        }
      }
      stepInfoCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public Builder clearCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        if (stepInfoCase_ == 20) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
          onChanged();
        }
      } else {
        if (stepInfoCase_ == 20) {
          stepInfoCase_ = 0;
          stepInfo_ = null;
        }
        cloudFunctionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.Builder
        getCloudFunctionBuilder() {
      return getCloudFunctionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfoOrBuilder
        getCloudFunctionOrBuilder() {
      if ((stepInfoCase_ == 20) && (cloudFunctionBuilder_ != null)) {
        return cloudFunctionBuilder_.getMessageOrBuilder();
      } else {
        if (stepInfoCase_ == 20) {
          return (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_;
        }
        return com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Display information of a Cloud function.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo cloud_function = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo,
            com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfoOrBuilder>
        getCloudFunctionFieldBuilder() {
      if (cloudFunctionBuilder_ == null) {
        if (!(stepInfoCase_ == 20)) {
          stepInfo_ =
              com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.getDefaultInstance();
        }
        cloudFunctionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo,
                com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfoOrBuilder>(
                (com.google.cloud.networkmanagement.v1beta1.CloudFunctionInfo) stepInfo_,
                getParentForChildren(),
                isClean());
        stepInfo_ = null;
      }
      stepInfoCase_ = 20;
      onChanged();
      ;
      return cloudFunctionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.Step)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.Step)
  private static final com.google.cloud.networkmanagement.v1beta1.Step DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.Step();
  }

  public static com.google.cloud.networkmanagement.v1beta1.Step getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Step> PARSER =
      new com.google.protobuf.AbstractParser<Step>() {
        @java.lang.Override
        public Step parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Step> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Step> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Step getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
