/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/trace.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * For display only. Metadata associated with a Compute Engine route.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.RouteInfo}
 */
public final class RouteInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.RouteInfo)
    RouteInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouteInfo.newBuilder() to construct.
  private RouteInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouteInfo() {
    routeType_ = 0;
    nextHopType_ = 0;
    displayName_ = "";
    uri_ = "";
    destIpRange_ = "";
    nextHop_ = "";
    networkUri_ = "";
    instanceTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouteInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_RouteInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TraceProto
        .internal_static_google_cloud_networkmanagement_v1beta1_RouteInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.RouteInfo.class,
            com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of route:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType}
   */
  public enum RouteType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>ROUTE_TYPE_UNSPECIFIED = 0;</code>
     */
    ROUTE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Route is a subnet route automatically created by the system.
     * </pre>
     *
     * <code>SUBNET = 1;</code>
     */
    SUBNET(1),
    /**
     *
     *
     * <pre>
     * Static route created by the user, including the default route to the
     * internet.
     * </pre>
     *
     * <code>STATIC = 2;</code>
     */
    STATIC(2),
    /**
     *
     *
     * <pre>
     * Dynamic route exchanged between BGP peers.
     * </pre>
     *
     * <code>DYNAMIC = 3;</code>
     */
    DYNAMIC(3),
    /**
     *
     *
     * <pre>
     * A subnet route received from peering network.
     * </pre>
     *
     * <code>PEERING_SUBNET = 4;</code>
     */
    PEERING_SUBNET(4),
    /**
     *
     *
     * <pre>
     * A static route received from peering network.
     * </pre>
     *
     * <code>PEERING_STATIC = 5;</code>
     */
    PEERING_STATIC(5),
    /**
     *
     *
     * <pre>
     * A dynamic route received from peering network.
     * </pre>
     *
     * <code>PEERING_DYNAMIC = 6;</code>
     */
    PEERING_DYNAMIC(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>ROUTE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ROUTE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Route is a subnet route automatically created by the system.
     * </pre>
     *
     * <code>SUBNET = 1;</code>
     */
    public static final int SUBNET_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Static route created by the user, including the default route to the
     * internet.
     * </pre>
     *
     * <code>STATIC = 2;</code>
     */
    public static final int STATIC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Dynamic route exchanged between BGP peers.
     * </pre>
     *
     * <code>DYNAMIC = 3;</code>
     */
    public static final int DYNAMIC_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A subnet route received from peering network.
     * </pre>
     *
     * <code>PEERING_SUBNET = 4;</code>
     */
    public static final int PEERING_SUBNET_VALUE = 4;
    /**
     *
     *
     * <pre>
     * A static route received from peering network.
     * </pre>
     *
     * <code>PEERING_STATIC = 5;</code>
     */
    public static final int PEERING_STATIC_VALUE = 5;
    /**
     *
     *
     * <pre>
     * A dynamic route received from peering network.
     * </pre>
     *
     * <code>PEERING_DYNAMIC = 6;</code>
     */
    public static final int PEERING_DYNAMIC_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RouteType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RouteType forNumber(int value) {
      switch (value) {
        case 0:
          return ROUTE_TYPE_UNSPECIFIED;
        case 1:
          return SUBNET;
        case 2:
          return STATIC;
        case 3:
          return DYNAMIC;
        case 4:
          return PEERING_SUBNET;
        case 5:
          return PEERING_STATIC;
        case 6:
          return PEERING_DYNAMIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RouteType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RouteType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RouteType>() {
          public RouteType findValueByNumber(int number) {
            return RouteType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RouteType[] VALUES = values();

    public static RouteType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RouteType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType)
  }

  /**
   *
   *
   * <pre>
   * Type of next hop:
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType}
   */
  public enum NextHopType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>NEXT_HOP_TYPE_UNSPECIFIED = 0;</code>
     */
    NEXT_HOP_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Next hop is an IP address.
     * </pre>
     *
     * <code>NEXT_HOP_IP = 1;</code>
     */
    NEXT_HOP_IP(1),
    /**
     *
     *
     * <pre>
     * Next hop is a Compute Engine instance.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE = 2;</code>
     */
    NEXT_HOP_INSTANCE(2),
    /**
     *
     *
     * <pre>
     * Next hop is a VPC network gateway.
     * </pre>
     *
     * <code>NEXT_HOP_NETWORK = 3;</code>
     */
    NEXT_HOP_NETWORK(3),
    /**
     *
     *
     * <pre>
     * Next hop is a peering VPC.
     * </pre>
     *
     * <code>NEXT_HOP_PEERING = 4;</code>
     */
    NEXT_HOP_PEERING(4),
    /**
     *
     *
     * <pre>
     * Next hop is an interconnect.
     * </pre>
     *
     * <code>NEXT_HOP_INTERCONNECT = 5;</code>
     */
    NEXT_HOP_INTERCONNECT(5),
    /**
     *
     *
     * <pre>
     * Next hop is a VPN tunnel.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_TUNNEL = 6;</code>
     */
    NEXT_HOP_VPN_TUNNEL(6),
    /**
     *
     *
     * <pre>
     * Next hop is a VPN gateway. This scenario only happens when tracing
     * connectivity from an on-premises network to Google Cloud through a VPN.
     * The analysis simulates a packet departing from the on-premises network
     * through a VPN tunnel and arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_GATEWAY = 7;</code>
     */
    NEXT_HOP_VPN_GATEWAY(7),
    /**
     *
     *
     * <pre>
     * Next hop is an internet gateway.
     * </pre>
     *
     * <code>NEXT_HOP_INTERNET_GATEWAY = 8;</code>
     */
    NEXT_HOP_INTERNET_GATEWAY(8),
    /**
     *
     *
     * <pre>
     * Next hop is blackhole; that is, the next hop either does not exist or is
     * not running.
     * </pre>
     *
     * <code>NEXT_HOP_BLACKHOLE = 9;</code>
     */
    NEXT_HOP_BLACKHOLE(9),
    /**
     *
     *
     * <pre>
     * Next hop is the forwarding rule of an Internal Load Balancer.
     * </pre>
     *
     * <code>NEXT_HOP_ILB = 10;</code>
     */
    NEXT_HOP_ILB(10),
    /**
     *
     *
     * <pre>
     * Next hop is a
     * [router appliance
     * instance](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/ra-overview).
     * </pre>
     *
     * <code>NEXT_HOP_ROUTER_APPLIANCE = 11;</code>
     */
    NEXT_HOP_ROUTER_APPLIANCE(11),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type. Default value.
     * </pre>
     *
     * <code>NEXT_HOP_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int NEXT_HOP_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Next hop is an IP address.
     * </pre>
     *
     * <code>NEXT_HOP_IP = 1;</code>
     */
    public static final int NEXT_HOP_IP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Next hop is a Compute Engine instance.
     * </pre>
     *
     * <code>NEXT_HOP_INSTANCE = 2;</code>
     */
    public static final int NEXT_HOP_INSTANCE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Next hop is a VPC network gateway.
     * </pre>
     *
     * <code>NEXT_HOP_NETWORK = 3;</code>
     */
    public static final int NEXT_HOP_NETWORK_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Next hop is a peering VPC.
     * </pre>
     *
     * <code>NEXT_HOP_PEERING = 4;</code>
     */
    public static final int NEXT_HOP_PEERING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Next hop is an interconnect.
     * </pre>
     *
     * <code>NEXT_HOP_INTERCONNECT = 5;</code>
     */
    public static final int NEXT_HOP_INTERCONNECT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Next hop is a VPN tunnel.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_TUNNEL = 6;</code>
     */
    public static final int NEXT_HOP_VPN_TUNNEL_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Next hop is a VPN gateway. This scenario only happens when tracing
     * connectivity from an on-premises network to Google Cloud through a VPN.
     * The analysis simulates a packet departing from the on-premises network
     * through a VPN tunnel and arriving at a Cloud VPN gateway.
     * </pre>
     *
     * <code>NEXT_HOP_VPN_GATEWAY = 7;</code>
     */
    public static final int NEXT_HOP_VPN_GATEWAY_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Next hop is an internet gateway.
     * </pre>
     *
     * <code>NEXT_HOP_INTERNET_GATEWAY = 8;</code>
     */
    public static final int NEXT_HOP_INTERNET_GATEWAY_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Next hop is blackhole; that is, the next hop either does not exist or is
     * not running.
     * </pre>
     *
     * <code>NEXT_HOP_BLACKHOLE = 9;</code>
     */
    public static final int NEXT_HOP_BLACKHOLE_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Next hop is the forwarding rule of an Internal Load Balancer.
     * </pre>
     *
     * <code>NEXT_HOP_ILB = 10;</code>
     */
    public static final int NEXT_HOP_ILB_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Next hop is a
     * [router appliance
     * instance](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/ra-overview).
     * </pre>
     *
     * <code>NEXT_HOP_ROUTER_APPLIANCE = 11;</code>
     */
    public static final int NEXT_HOP_ROUTER_APPLIANCE_VALUE = 11;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NextHopType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NextHopType forNumber(int value) {
      switch (value) {
        case 0:
          return NEXT_HOP_TYPE_UNSPECIFIED;
        case 1:
          return NEXT_HOP_IP;
        case 2:
          return NEXT_HOP_INSTANCE;
        case 3:
          return NEXT_HOP_NETWORK;
        case 4:
          return NEXT_HOP_PEERING;
        case 5:
          return NEXT_HOP_INTERCONNECT;
        case 6:
          return NEXT_HOP_VPN_TUNNEL;
        case 7:
          return NEXT_HOP_VPN_GATEWAY;
        case 8:
          return NEXT_HOP_INTERNET_GATEWAY;
        case 9:
          return NEXT_HOP_BLACKHOLE;
        case 10:
          return NEXT_HOP_ILB;
        case 11:
          return NEXT_HOP_ROUTER_APPLIANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NextHopType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NextHopType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NextHopType>() {
          public NextHopType findValueByNumber(int number) {
            return NextHopType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final NextHopType[] VALUES = values();

    public static NextHopType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NextHopType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType)
  }

  public static final int ROUTE_TYPE_FIELD_NUMBER = 8;
  private int routeType_;
  /**
   *
   *
   * <pre>
   * Type of route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
   *
   * @return The enum numeric value on the wire for routeType.
   */
  @java.lang.Override
  public int getRouteTypeValue() {
    return routeType_;
  }
  /**
   *
   *
   * <pre>
   * Type of route.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
   *
   * @return The routeType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType getRouteType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType result =
        com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType.valueOf(routeType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType.UNRECOGNIZED
        : result;
  }

  public static final int NEXT_HOP_TYPE_FIELD_NUMBER = 9;
  private int nextHopType_;
  /**
   *
   *
   * <pre>
   * Type of next hop.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
   *
   * @return The enum numeric value on the wire for nextHopType.
   */
  @java.lang.Override
  public int getNextHopTypeValue() {
    return nextHopType_;
  }
  /**
   *
   *
   * <pre>
   * Type of next hop.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
   *
   * @return The nextHopType.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType getNextHopType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType result =
        com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType.valueOf(nextHopType_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType.UNRECOGNIZED
        : result;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine route.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of a Compute Engine route.
   * </pre>
   *
   * <code>string display_name = 1;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object uri_;
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine route.
   * Dynamic route from cloud router does not have a URI.
   * Advertised route from Google Cloud VPC to on-premises network also does
   * not have a URI.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine route.
   * Dynamic route from cloud router does not have a URI.
   * Advertised route from Google Cloud VPC to on-premises network also does
   * not have a URI.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEST_IP_RANGE_FIELD_NUMBER = 3;
  private volatile java.lang.Object destIpRange_;
  /**
   *
   *
   * <pre>
   * Destination IP range of the route.
   * </pre>
   *
   * <code>string dest_ip_range = 3;</code>
   *
   * @return The destIpRange.
   */
  @java.lang.Override
  public java.lang.String getDestIpRange() {
    java.lang.Object ref = destIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Destination IP range of the route.
   * </pre>
   *
   * <code>string dest_ip_range = 3;</code>
   *
   * @return The bytes for destIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestIpRangeBytes() {
    java.lang.Object ref = destIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_HOP_FIELD_NUMBER = 4;
  private volatile java.lang.Object nextHop_;
  /**
   *
   *
   * <pre>
   * Next hop of the route.
   * </pre>
   *
   * <code>string next_hop = 4;</code>
   *
   * @return The nextHop.
   */
  @java.lang.Override
  public java.lang.String getNextHop() {
    java.lang.Object ref = nextHop_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextHop_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Next hop of the route.
   * </pre>
   *
   * <code>string next_hop = 4;</code>
   *
   * @return The bytes for nextHop.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextHopBytes() {
    java.lang.Object ref = nextHop_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextHop_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_URI_FIELD_NUMBER = 5;
  private volatile java.lang.Object networkUri_;
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network.
   * </pre>
   *
   * <code>string network_uri = 5;</code>
   *
   * @return The networkUri.
   */
  @java.lang.Override
  public java.lang.String getNetworkUri() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of a Compute Engine network.
   * </pre>
   *
   * <code>string network_uri = 5;</code>
   *
   * @return The bytes for networkUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkUriBytes() {
    java.lang.Object ref = networkUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIORITY_FIELD_NUMBER = 6;
  private int priority_;
  /**
   *
   *
   * <pre>
   * Priority of the route.
   * </pre>
   *
   * <code>int32 priority = 6;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int INSTANCE_TAGS_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList instanceTags_;
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @return A list containing the instanceTags.
   */
  public com.google.protobuf.ProtocolStringList getInstanceTagsList() {
    return instanceTags_;
  }
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @return The count of instanceTags.
   */
  public int getInstanceTagsCount() {
    return instanceTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The instanceTags at the given index.
   */
  public java.lang.String getInstanceTags(int index) {
    return instanceTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Instance tags of the route.
   * </pre>
   *
   * <code>repeated string instance_tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the instanceTags at the given index.
   */
  public com.google.protobuf.ByteString getInstanceTagsBytes(int index) {
    return instanceTags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destIpRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextHop_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, nextHop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, networkUri_);
    }
    if (priority_ != 0) {
      output.writeInt32(6, priority_);
    }
    for (int i = 0; i < instanceTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, instanceTags_.getRaw(i));
    }
    if (routeType_
        != com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType.ROUTE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, routeType_);
    }
    if (nextHopType_
        != com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType
            .NEXT_HOP_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, nextHopType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destIpRange_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextHop_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, nextHop_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, networkUri_);
    }
    if (priority_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, priority_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInstanceTagsList().size();
    }
    if (routeType_
        != com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType.ROUTE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, routeType_);
    }
    if (nextHopType_
        != com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType
            .NEXT_HOP_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, nextHopType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.RouteInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.RouteInfo other =
        (com.google.cloud.networkmanagement.v1beta1.RouteInfo) obj;

    if (routeType_ != other.routeType_) return false;
    if (nextHopType_ != other.nextHopType_) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getDestIpRange().equals(other.getDestIpRange())) return false;
    if (!getNextHop().equals(other.getNextHop())) return false;
    if (!getNetworkUri().equals(other.getNetworkUri())) return false;
    if (getPriority() != other.getPriority()) return false;
    if (!getInstanceTagsList().equals(other.getInstanceTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROUTE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + routeType_;
    hash = (37 * hash) + NEXT_HOP_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + nextHopType_;
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + DEST_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getDestIpRange().hashCode();
    hash = (37 * hash) + NEXT_HOP_FIELD_NUMBER;
    hash = (53 * hash) + getNextHop().hashCode();
    hash = (37 * hash) + NETWORK_URI_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkUri().hashCode();
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + getPriority();
    if (getInstanceTagsCount() > 0) {
      hash = (37 * hash) + INSTANCE_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkmanagement.v1beta1.RouteInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For display only. Metadata associated with a Compute Engine route.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.RouteInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.RouteInfo)
      com.google.cloud.networkmanagement.v1beta1.RouteInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_RouteInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_RouteInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.RouteInfo.class,
              com.google.cloud.networkmanagement.v1beta1.RouteInfo.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.RouteInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      routeType_ = 0;

      nextHopType_ = 0;

      displayName_ = "";

      uri_ = "";

      destIpRange_ = "";

      nextHop_ = "";

      networkUri_ = "";

      priority_ = 0;

      instanceTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TraceProto
          .internal_static_google_cloud_networkmanagement_v1beta1_RouteInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo build() {
      com.google.cloud.networkmanagement.v1beta1.RouteInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.RouteInfo result =
          new com.google.cloud.networkmanagement.v1beta1.RouteInfo(this);
      int from_bitField0_ = bitField0_;
      result.routeType_ = routeType_;
      result.nextHopType_ = nextHopType_;
      result.displayName_ = displayName_;
      result.uri_ = uri_;
      result.destIpRange_ = destIpRange_;
      result.nextHop_ = nextHop_;
      result.networkUri_ = networkUri_;
      result.priority_ = priority_;
      if (((bitField0_ & 0x00000001) != 0)) {
        instanceTags_ = instanceTags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.instanceTags_ = instanceTags_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.RouteInfo) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.RouteInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.RouteInfo other) {
      if (other == com.google.cloud.networkmanagement.v1beta1.RouteInfo.getDefaultInstance())
        return this;
      if (other.routeType_ != 0) {
        setRouteTypeValue(other.getRouteTypeValue());
      }
      if (other.nextHopType_ != 0) {
        setNextHopTypeValue(other.getNextHopTypeValue());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        onChanged();
      }
      if (!other.getDestIpRange().isEmpty()) {
        destIpRange_ = other.destIpRange_;
        onChanged();
      }
      if (!other.getNextHop().isEmpty()) {
        nextHop_ = other.nextHop_;
        onChanged();
      }
      if (!other.getNetworkUri().isEmpty()) {
        networkUri_ = other.networkUri_;
        onChanged();
      }
      if (other.getPriority() != 0) {
        setPriority(other.getPriority());
      }
      if (!other.instanceTags_.isEmpty()) {
        if (instanceTags_.isEmpty()) {
          instanceTags_ = other.instanceTags_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureInstanceTagsIsMutable();
          instanceTags_.addAll(other.instanceTags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                destIpRange_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                nextHop_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                networkUri_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 48:
              {
                priority_ = input.readInt32();

                break;
              } // case 48
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceTagsIsMutable();
                instanceTags_.add(s);
                break;
              } // case 58
            case 64:
              {
                routeType_ = input.readEnum();

                break;
              } // case 64
            case 72:
              {
                nextHopType_ = input.readEnum();

                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int routeType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @return The enum numeric value on the wire for routeType.
     */
    @java.lang.Override
    public int getRouteTypeValue() {
      return routeType_;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @param value The enum numeric value on the wire for routeType to set.
     * @return This builder for chaining.
     */
    public Builder setRouteTypeValue(int value) {

      routeType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @return The routeType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType getRouteType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType result =
          com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType.valueOf(routeType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @param value The routeType to set.
     * @return This builder for chaining.
     */
    public Builder setRouteType(
        com.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      routeType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of route.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.RouteType route_type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteType() {

      routeType_ = 0;
      onChanged();
      return this;
    }

    private int nextHopType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @return The enum numeric value on the wire for nextHopType.
     */
    @java.lang.Override
    public int getNextHopTypeValue() {
      return nextHopType_;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @param value The enum numeric value on the wire for nextHopType to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopTypeValue(int value) {

      nextHopType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @return The nextHopType.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType getNextHopType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType result =
          com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType.valueOf(nextHopType_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @param value The nextHopType to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopType(
        com.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextHopType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of next hop.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.RouteInfo.NextHopType next_hop_type = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopType() {

      nextHopType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of a Compute Engine route.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine route.
     * Dynamic route from cloud router does not have a URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have a URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine route.
     * Dynamic route from cloud router does not have a URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have a URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine route.
     * Dynamic route from cloud router does not have a URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have a URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine route.
     * Dynamic route from cloud router does not have a URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have a URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {

      uri_ = getDefaultInstance().getUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine route.
     * Dynamic route from cloud router does not have a URI.
     * Advertised route from Google Cloud VPC to on-premises network also does
     * not have a URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object destIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @return The destIpRange.
     */
    public java.lang.String getDestIpRange() {
      java.lang.Object ref = destIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @return The bytes for destIpRange.
     */
    public com.google.protobuf.ByteString getDestIpRangeBytes() {
      java.lang.Object ref = destIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @param value The destIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setDestIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      destIpRange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestIpRange() {

      destIpRange_ = getDefaultInstance().getDestIpRange();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination IP range of the route.
     * </pre>
     *
     * <code>string dest_ip_range = 3;</code>
     *
     * @param value The bytes for destIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setDestIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      destIpRange_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object nextHop_ = "";
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @return The nextHop.
     */
    public java.lang.String getNextHop() {
      java.lang.Object ref = nextHop_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextHop_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @return The bytes for nextHop.
     */
    public com.google.protobuf.ByteString getNextHopBytes() {
      java.lang.Object ref = nextHop_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextHop_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @param value The nextHop to set.
     * @return This builder for chaining.
     */
    public Builder setNextHop(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextHop_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHop() {

      nextHop_ = getDefaultInstance().getNextHop();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Next hop of the route.
     * </pre>
     *
     * <code>string next_hop = 4;</code>
     *
     * @param value The bytes for nextHop to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextHop_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object networkUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @return The networkUri.
     */
    public java.lang.String getNetworkUri() {
      java.lang.Object ref = networkUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @return The bytes for networkUri.
     */
    public com.google.protobuf.ByteString getNetworkUriBytes() {
      java.lang.Object ref = networkUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @param value The networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      networkUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkUri() {

      networkUri_ = getDefaultInstance().getNetworkUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of a Compute Engine network.
     * </pre>
     *
     * <code>string network_uri = 5;</code>
     *
     * @param value The bytes for networkUri to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      networkUri_ = value;
      onChanged();
      return this;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * Priority of the route.
     * </pre>
     *
     * <code>int32 priority = 6;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * Priority of the route.
     * </pre>
     *
     * <code>int32 priority = 6;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Priority of the route.
     * </pre>
     *
     * <code>int32 priority = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {

      priority_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList instanceTags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureInstanceTagsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        instanceTags_ = new com.google.protobuf.LazyStringArrayList(instanceTags_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @return A list containing the instanceTags.
     */
    public com.google.protobuf.ProtocolStringList getInstanceTagsList() {
      return instanceTags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @return The count of instanceTags.
     */
    public int getInstanceTagsCount() {
      return instanceTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The instanceTags at the given index.
     */
    public java.lang.String getInstanceTags(int index) {
      return instanceTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the instanceTags at the given index.
     */
    public com.google.protobuf.ByteString getInstanceTagsBytes(int index) {
      return instanceTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The instanceTags to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceTagsIsMutable();
      instanceTags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param value The instanceTags to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceTagsIsMutable();
      instanceTags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param values The instanceTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllInstanceTags(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceTags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceTags() {
      instanceTags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instance tags of the route.
     * </pre>
     *
     * <code>repeated string instance_tags = 7;</code>
     *
     * @param value The bytes of the instanceTags to add.
     * @return This builder for chaining.
     */
    public Builder addInstanceTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceTagsIsMutable();
      instanceTags_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.RouteInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.RouteInfo)
  private static final com.google.cloud.networkmanagement.v1beta1.RouteInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.RouteInfo();
  }

  public static com.google.cloud.networkmanagement.v1beta1.RouteInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouteInfo> PARSER =
      new com.google.protobuf.AbstractParser<RouteInfo>() {
        @java.lang.Override
        public RouteInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouteInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouteInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.RouteInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
