/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/connectivity_test.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * Results of the configuration analysis from the last run of the test.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ReachabilityDetails}
 */
public final class ReachabilityDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.ReachabilityDetails)
    ReachabilityDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReachabilityDetails.newBuilder() to construct.
  private ReachabilityDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReachabilityDetails() {
    result_ = 0;
    traces_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReachabilityDetails();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_ReachabilityDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_ReachabilityDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.class,
            com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The overall result of the test's configuration analysis.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result}
   */
  public enum Result implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No result was specified.
     * </pre>
     *
     * <code>RESULT_UNSPECIFIED = 0;</code>
     */
    RESULT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Possible scenarios are:
     * * The configuration analysis determined that a packet originating from
     *   the source is expected to reach the destination.
     * * The analysis didn't complete because the user lacks permission for
     *   some of the resources in the trace. However, at the time the user's
     *   permission became insufficient, the trace had been successful so far.
     * </pre>
     *
     * <code>REACHABLE = 1;</code>
     */
    REACHABLE(1),
    /**
     *
     *
     * <pre>
     * A packet originating from the source is expected to be dropped before
     * reaching the destination.
     * </pre>
     *
     * <code>UNREACHABLE = 2;</code>
     */
    UNREACHABLE(2),
    /**
     *
     *
     * <pre>
     * The source and destination endpoints do not uniquely identify
     * the test location in the network, and the reachability result contains
     * multiple traces. For some traces, a packet could be delivered, and for
     * others, it would not be.
     * </pre>
     *
     * <code>AMBIGUOUS = 4;</code>
     */
    AMBIGUOUS(4),
    /**
     *
     *
     * <pre>
     * The configuration analysis did not complete. Possible reasons are:
     * * A permissions error occurred--for example, the user might not have
     *   read permission for all of the resources named in the test.
     * * An internal error occurred.
     * * The analyzer received an invalid or unsupported argument or was unable
     *   to identify a known endpoint.
     * </pre>
     *
     * <code>UNDETERMINED = 5;</code>
     */
    UNDETERMINED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No result was specified.
     * </pre>
     *
     * <code>RESULT_UNSPECIFIED = 0;</code>
     */
    public static final int RESULT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Possible scenarios are:
     * * The configuration analysis determined that a packet originating from
     *   the source is expected to reach the destination.
     * * The analysis didn't complete because the user lacks permission for
     *   some of the resources in the trace. However, at the time the user's
     *   permission became insufficient, the trace had been successful so far.
     * </pre>
     *
     * <code>REACHABLE = 1;</code>
     */
    public static final int REACHABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A packet originating from the source is expected to be dropped before
     * reaching the destination.
     * </pre>
     *
     * <code>UNREACHABLE = 2;</code>
     */
    public static final int UNREACHABLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The source and destination endpoints do not uniquely identify
     * the test location in the network, and the reachability result contains
     * multiple traces. For some traces, a packet could be delivered, and for
     * others, it would not be.
     * </pre>
     *
     * <code>AMBIGUOUS = 4;</code>
     */
    public static final int AMBIGUOUS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The configuration analysis did not complete. Possible reasons are:
     * * A permissions error occurred--for example, the user might not have
     *   read permission for all of the resources named in the test.
     * * An internal error occurred.
     * * The analyzer received an invalid or unsupported argument or was unable
     *   to identify a known endpoint.
     * </pre>
     *
     * <code>UNDETERMINED = 5;</code>
     */
    public static final int UNDETERMINED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Result valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Result forNumber(int value) {
      switch (value) {
        case 0:
          return RESULT_UNSPECIFIED;
        case 1:
          return REACHABLE;
        case 2:
          return UNREACHABLE;
        case 4:
          return AMBIGUOUS;
        case 5:
          return UNDETERMINED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Result> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Result> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Result>() {
          public Result findValueByNumber(int number) {
            return Result.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Result[] VALUES = values();

    public static Result valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Result(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result)
  }

  public static final int RESULT_FIELD_NUMBER = 1;
  private int result_;
  /**
   *
   *
   * <pre>
   * The overall result of the test's configuration analysis.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
   *
   * @return The enum numeric value on the wire for result.
   */
  @java.lang.Override
  public int getResultValue() {
    return result_;
  }
  /**
   *
   *
   * <pre>
   * The overall result of the test's configuration analysis.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
   *
   * @return The result.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result getResult() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result =
        com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result.valueOf(result_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result.UNRECOGNIZED
        : result;
  }

  public static final int VERIFY_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp verifyTime_;
  /**
   *
   *
   * <pre>
   * The time of the configuration analysis.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp verify_time = 2;</code>
   *
   * @return Whether the verifyTime field is set.
   */
  @java.lang.Override
  public boolean hasVerifyTime() {
    return verifyTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time of the configuration analysis.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp verify_time = 2;</code>
   *
   * @return The verifyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVerifyTime() {
    return verifyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : verifyTime_;
  }
  /**
   *
   *
   * <pre>
   * The time of the configuration analysis.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp verify_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVerifyTimeOrBuilder() {
    return getVerifyTime();
  }

  public static final int ERROR_FIELD_NUMBER = 3;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * The details of a failure or a cancellation of reachability analysis.
   * </pre>
   *
   * <code>.google.rpc.Status error = 3;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * The details of a failure or a cancellation of reachability analysis.
   * </pre>
   *
   * <code>.google.rpc.Status error = 3;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * The details of a failure or a cancellation of reachability analysis.
   * </pre>
   *
   * <code>.google.rpc.Status error = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int TRACES_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.networkmanagement.v1beta1.Trace> traces_;
  /**
   *
   *
   * <pre>
   * Result may contain a list of traces if a test has multiple possible
   * paths in the network, such as when destination endpoint is a load balancer
   * with multiple backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networkmanagement.v1beta1.Trace> getTracesList() {
    return traces_;
  }
  /**
   *
   *
   * <pre>
   * Result may contain a list of traces if a test has multiple possible
   * paths in the network, such as when destination endpoint is a load balancer
   * with multiple backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder>
      getTracesOrBuilderList() {
    return traces_;
  }
  /**
   *
   *
   * <pre>
   * Result may contain a list of traces if a test has multiple possible
   * paths in the network, such as when destination endpoint is a load balancer
   * with multiple backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
   */
  @java.lang.Override
  public int getTracesCount() {
    return traces_.size();
  }
  /**
   *
   *
   * <pre>
   * Result may contain a list of traces if a test has multiple possible
   * paths in the network, such as when destination endpoint is a load balancer
   * with multiple backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.Trace getTraces(int index) {
    return traces_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Result may contain a list of traces if a test has multiple possible
   * paths in the network, such as when destination endpoint is a load balancer
   * with multiple backends.
   * </pre>
   *
   * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder getTracesOrBuilder(int index) {
    return traces_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (result_
        != com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result.RESULT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, result_);
    }
    if (verifyTime_ != null) {
      output.writeMessage(2, getVerifyTime());
    }
    if (error_ != null) {
      output.writeMessage(3, getError());
    }
    for (int i = 0; i < traces_.size(); i++) {
      output.writeMessage(5, traces_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (result_
        != com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result.RESULT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, result_);
    }
    if (verifyTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getVerifyTime());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getError());
    }
    for (int i = 0; i < traces_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, traces_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails other =
        (com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails) obj;

    if (result_ != other.result_) return false;
    if (hasVerifyTime() != other.hasVerifyTime()) return false;
    if (hasVerifyTime()) {
      if (!getVerifyTime().equals(other.getVerifyTime())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getTracesList().equals(other.getTracesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESULT_FIELD_NUMBER;
    hash = (53 * hash) + result_;
    if (hasVerifyTime()) {
      hash = (37 * hash) + VERIFY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVerifyTime().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (getTracesCount() > 0) {
      hash = (37 * hash) + TRACES_FIELD_NUMBER;
      hash = (53 * hash) + getTracesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Results of the configuration analysis from the last run of the test.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ReachabilityDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.ReachabilityDetails)
      com.google.cloud.networkmanagement.v1beta1.ReachabilityDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ReachabilityDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ReachabilityDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.class,
              com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      result_ = 0;

      if (verifyTimeBuilder_ == null) {
        verifyTime_ = null;
      } else {
        verifyTime_ = null;
        verifyTimeBuilder_ = null;
      }
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      if (tracesBuilder_ == null) {
        traces_ = java.util.Collections.emptyList();
      } else {
        traces_ = null;
        tracesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ReachabilityDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails
        getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails build() {
      com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails result =
          new com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails(this);
      int from_bitField0_ = bitField0_;
      result.result_ = result_;
      if (verifyTimeBuilder_ == null) {
        result.verifyTime_ = verifyTime_;
      } else {
        result.verifyTime_ = verifyTimeBuilder_.build();
      }
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      if (tracesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          traces_ = java.util.Collections.unmodifiableList(traces_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.traces_ = traces_;
      } else {
        result.traces_ = tracesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails other) {
      if (other
          == com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.getDefaultInstance())
        return this;
      if (other.result_ != 0) {
        setResultValue(other.getResultValue());
      }
      if (other.hasVerifyTime()) {
        mergeVerifyTime(other.getVerifyTime());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (tracesBuilder_ == null) {
        if (!other.traces_.isEmpty()) {
          if (traces_.isEmpty()) {
            traces_ = other.traces_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTracesIsMutable();
            traces_.addAll(other.traces_);
          }
          onChanged();
        }
      } else {
        if (!other.traces_.isEmpty()) {
          if (tracesBuilder_.isEmpty()) {
            tracesBuilder_.dispose();
            tracesBuilder_ = null;
            traces_ = other.traces_;
            bitField0_ = (bitField0_ & ~0x00000001);
            tracesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTracesFieldBuilder()
                    : null;
          } else {
            tracesBuilder_.addAllMessages(other.traces_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                result_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                input.readMessage(getVerifyTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 42:
              {
                com.google.cloud.networkmanagement.v1beta1.Trace m =
                    input.readMessage(
                        com.google.cloud.networkmanagement.v1beta1.Trace.parser(),
                        extensionRegistry);
                if (tracesBuilder_ == null) {
                  ensureTracesIsMutable();
                  traces_.add(m);
                } else {
                  tracesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int result_ = 0;
    /**
     *
     *
     * <pre>
     * The overall result of the test's configuration analysis.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
     *
     * @return The enum numeric value on the wire for result.
     */
    @java.lang.Override
    public int getResultValue() {
      return result_;
    }
    /**
     *
     *
     * <pre>
     * The overall result of the test's configuration analysis.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
     *
     * @param value The enum numeric value on the wire for result to set.
     * @return This builder for chaining.
     */
    public Builder setResultValue(int value) {

      result_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall result of the test's configuration analysis.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
     *
     * @return The result.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result getResult() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result =
          com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result.valueOf(result_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The overall result of the test's configuration analysis.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
     *
     * @param value The result to set.
     * @return This builder for chaining.
     */
    public Builder setResult(
        com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result value) {
      if (value == null) {
        throw new NullPointerException();
      }

      result_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall result of the test's configuration analysis.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ReachabilityDetails.Result result = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResult() {

      result_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp verifyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        verifyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     *
     * @return Whether the verifyTime field is set.
     */
    public boolean hasVerifyTime() {
      return verifyTimeBuilder_ != null || verifyTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     *
     * @return The verifyTime.
     */
    public com.google.protobuf.Timestamp getVerifyTime() {
      if (verifyTimeBuilder_ == null) {
        return verifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : verifyTime_;
      } else {
        return verifyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder setVerifyTime(com.google.protobuf.Timestamp value) {
      if (verifyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        verifyTime_ = value;
        onChanged();
      } else {
        verifyTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder setVerifyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (verifyTimeBuilder_ == null) {
        verifyTime_ = builderForValue.build();
        onChanged();
      } else {
        verifyTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder mergeVerifyTime(com.google.protobuf.Timestamp value) {
      if (verifyTimeBuilder_ == null) {
        if (verifyTime_ != null) {
          verifyTime_ =
              com.google.protobuf.Timestamp.newBuilder(verifyTime_).mergeFrom(value).buildPartial();
        } else {
          verifyTime_ = value;
        }
        onChanged();
      } else {
        verifyTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder clearVerifyTime() {
      if (verifyTimeBuilder_ == null) {
        verifyTime_ = null;
        onChanged();
      } else {
        verifyTime_ = null;
        verifyTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getVerifyTimeBuilder() {

      onChanged();
      return getVerifyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getVerifyTimeOrBuilder() {
      if (verifyTimeBuilder_ != null) {
        return verifyTimeBuilder_.getMessageOrBuilder();
      } else {
        return verifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : verifyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time of the configuration analysis.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVerifyTimeFieldBuilder() {
      if (verifyTimeBuilder_ == null) {
        verifyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVerifyTime(), getParentForChildren(), isClean());
        verifyTime_ = null;
      }
      return verifyTimeBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * The details of a failure or a cancellation of reachability analysis.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.util.List<com.google.cloud.networkmanagement.v1beta1.Trace> traces_ =
        java.util.Collections.emptyList();

    private void ensureTracesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        traces_ =
            new java.util.ArrayList<com.google.cloud.networkmanagement.v1beta1.Trace>(traces_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Trace,
            com.google.cloud.networkmanagement.v1beta1.Trace.Builder,
            com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder>
        tracesBuilder_;

    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public java.util.List<com.google.cloud.networkmanagement.v1beta1.Trace> getTracesList() {
      if (tracesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(traces_);
      } else {
        return tracesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public int getTracesCount() {
      if (tracesBuilder_ == null) {
        return traces_.size();
      } else {
        return tracesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Trace getTraces(int index) {
      if (tracesBuilder_ == null) {
        return traces_.get(index);
      } else {
        return tracesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder setTraces(int index, com.google.cloud.networkmanagement.v1beta1.Trace value) {
      if (tracesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTracesIsMutable();
        traces_.set(index, value);
        onChanged();
      } else {
        tracesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder setTraces(
        int index, com.google.cloud.networkmanagement.v1beta1.Trace.Builder builderForValue) {
      if (tracesBuilder_ == null) {
        ensureTracesIsMutable();
        traces_.set(index, builderForValue.build());
        onChanged();
      } else {
        tracesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder addTraces(com.google.cloud.networkmanagement.v1beta1.Trace value) {
      if (tracesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTracesIsMutable();
        traces_.add(value);
        onChanged();
      } else {
        tracesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder addTraces(int index, com.google.cloud.networkmanagement.v1beta1.Trace value) {
      if (tracesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTracesIsMutable();
        traces_.add(index, value);
        onChanged();
      } else {
        tracesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder addTraces(
        com.google.cloud.networkmanagement.v1beta1.Trace.Builder builderForValue) {
      if (tracesBuilder_ == null) {
        ensureTracesIsMutable();
        traces_.add(builderForValue.build());
        onChanged();
      } else {
        tracesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder addTraces(
        int index, com.google.cloud.networkmanagement.v1beta1.Trace.Builder builderForValue) {
      if (tracesBuilder_ == null) {
        ensureTracesIsMutable();
        traces_.add(index, builderForValue.build());
        onChanged();
      } else {
        tracesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder addAllTraces(
        java.lang.Iterable<? extends com.google.cloud.networkmanagement.v1beta1.Trace> values) {
      if (tracesBuilder_ == null) {
        ensureTracesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, traces_);
        onChanged();
      } else {
        tracesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder clearTraces() {
      if (tracesBuilder_ == null) {
        traces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        tracesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public Builder removeTraces(int index) {
      if (tracesBuilder_ == null) {
        ensureTracesIsMutable();
        traces_.remove(index);
        onChanged();
      } else {
        tracesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Trace.Builder getTracesBuilder(int index) {
      return getTracesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder getTracesOrBuilder(int index) {
      if (tracesBuilder_ == null) {
        return traces_.get(index);
      } else {
        return tracesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder>
        getTracesOrBuilderList() {
      if (tracesBuilder_ != null) {
        return tracesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(traces_);
      }
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Trace.Builder addTracesBuilder() {
      return getTracesFieldBuilder()
          .addBuilder(com.google.cloud.networkmanagement.v1beta1.Trace.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.Trace.Builder addTracesBuilder(int index) {
      return getTracesFieldBuilder()
          .addBuilder(index, com.google.cloud.networkmanagement.v1beta1.Trace.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Result may contain a list of traces if a test has multiple possible
     * paths in the network, such as when destination endpoint is a load balancer
     * with multiple backends.
     * </pre>
     *
     * <code>repeated .google.cloud.networkmanagement.v1beta1.Trace traces = 5;</code>
     */
    public java.util.List<com.google.cloud.networkmanagement.v1beta1.Trace.Builder>
        getTracesBuilderList() {
      return getTracesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.Trace,
            com.google.cloud.networkmanagement.v1beta1.Trace.Builder,
            com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder>
        getTracesFieldBuilder() {
      if (tracesBuilder_ == null) {
        tracesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.Trace,
                com.google.cloud.networkmanagement.v1beta1.Trace.Builder,
                com.google.cloud.networkmanagement.v1beta1.TraceOrBuilder>(
                traces_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        traces_ = null;
      }
      return tracesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.ReachabilityDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.ReachabilityDetails)
  private static final com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails();
  }

  public static com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReachabilityDetails> PARSER =
      new com.google.protobuf.AbstractParser<ReachabilityDetails>() {
        @java.lang.Override
        public ReachabilityDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReachabilityDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReachabilityDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ReachabilityDetails
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
