/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkmanagement/v1beta1/connectivity_test.proto

package com.google.cloud.networkmanagement.v1beta1;

/**
 *
 *
 * <pre>
 * Results of active probing from the last run of the test.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ProbingDetails}
 */
public final class ProbingDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.ProbingDetails)
    ProbingDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProbingDetails.newBuilder() to construct.
  private ProbingDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProbingDetails() {
    result_ = 0;
    abortCause_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProbingDetails();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
        .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.class,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Overall probing result of the test.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult}
   */
  public enum ProbingResult implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No result was specified.
     * </pre>
     *
     * <code>PROBING_RESULT_UNSPECIFIED = 0;</code>
     */
    PROBING_RESULT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * At least 95% of packets reached the destination.
     * </pre>
     *
     * <code>REACHABLE = 1;</code>
     */
    REACHABLE(1),
    /**
     *
     *
     * <pre>
     * No packets reached the destination.
     * </pre>
     *
     * <code>UNREACHABLE = 2;</code>
     */
    UNREACHABLE(2),
    /**
     *
     *
     * <pre>
     * Less than 95% of packets reached the destination.
     * </pre>
     *
     * <code>REACHABILITY_INCONSISTENT = 3;</code>
     */
    REACHABILITY_INCONSISTENT(3),
    /**
     *
     *
     * <pre>
     * Reachability could not be determined. Possible reasons are:
     * * The user lacks permission to access some of the network resources
     *   required to run the test.
     * * No valid source endpoint could be derived from the request.
     * * An internal error occurred.
     * </pre>
     *
     * <code>UNDETERMINED = 4;</code>
     */
    UNDETERMINED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No result was specified.
     * </pre>
     *
     * <code>PROBING_RESULT_UNSPECIFIED = 0;</code>
     */
    public static final int PROBING_RESULT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * At least 95% of packets reached the destination.
     * </pre>
     *
     * <code>REACHABLE = 1;</code>
     */
    public static final int REACHABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * No packets reached the destination.
     * </pre>
     *
     * <code>UNREACHABLE = 2;</code>
     */
    public static final int UNREACHABLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Less than 95% of packets reached the destination.
     * </pre>
     *
     * <code>REACHABILITY_INCONSISTENT = 3;</code>
     */
    public static final int REACHABILITY_INCONSISTENT_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Reachability could not be determined. Possible reasons are:
     * * The user lacks permission to access some of the network resources
     *   required to run the test.
     * * No valid source endpoint could be derived from the request.
     * * An internal error occurred.
     * </pre>
     *
     * <code>UNDETERMINED = 4;</code>
     */
    public static final int UNDETERMINED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProbingResult valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProbingResult forNumber(int value) {
      switch (value) {
        case 0:
          return PROBING_RESULT_UNSPECIFIED;
        case 1:
          return REACHABLE;
        case 2:
          return UNREACHABLE;
        case 3:
          return REACHABILITY_INCONSISTENT;
        case 4:
          return UNDETERMINED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProbingResult> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProbingResult> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ProbingResult>() {
          public ProbingResult findValueByNumber(int number) {
            return ProbingResult.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ProbingResult[] VALUES = values();

    public static ProbingResult valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProbingResult(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult)
  }

  /**
   *
   *
   * <pre>
   * Abort cause types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause}
   */
  public enum ProbingAbortCause implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No reason was specified.
     * </pre>
     *
     * <code>PROBING_ABORT_CAUSE_UNSPECIFIED = 0;</code>
     */
    PROBING_ABORT_CAUSE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The user lacks permission to access some of the
     * network resources required to run the test.
     * </pre>
     *
     * <code>PERMISSION_DENIED = 1;</code>
     */
    PERMISSION_DENIED(1),
    /**
     *
     *
     * <pre>
     * No valid source endpoint could be derived from the request.
     * </pre>
     *
     * <code>NO_SOURCE_LOCATION = 2;</code>
     */
    NO_SOURCE_LOCATION(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No reason was specified.
     * </pre>
     *
     * <code>PROBING_ABORT_CAUSE_UNSPECIFIED = 0;</code>
     */
    public static final int PROBING_ABORT_CAUSE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The user lacks permission to access some of the
     * network resources required to run the test.
     * </pre>
     *
     * <code>PERMISSION_DENIED = 1;</code>
     */
    public static final int PERMISSION_DENIED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * No valid source endpoint could be derived from the request.
     * </pre>
     *
     * <code>NO_SOURCE_LOCATION = 2;</code>
     */
    public static final int NO_SOURCE_LOCATION_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProbingAbortCause valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProbingAbortCause forNumber(int value) {
      switch (value) {
        case 0:
          return PROBING_ABORT_CAUSE_UNSPECIFIED;
        case 1:
          return PERMISSION_DENIED;
        case 2:
          return NO_SOURCE_LOCATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProbingAbortCause>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProbingAbortCause>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProbingAbortCause>() {
              public ProbingAbortCause findValueByNumber(int number) {
                return ProbingAbortCause.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ProbingAbortCause[] VALUES = values();

    public static ProbingAbortCause valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProbingAbortCause(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause)
  }

  public interface EdgeLocationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name of the metropolitan area.
     * </pre>
     *
     * <code>string metropolitan_area = 1;</code>
     *
     * @return The metropolitanArea.
     */
    java.lang.String getMetropolitanArea();
    /**
     *
     *
     * <pre>
     * Name of the metropolitan area.
     * </pre>
     *
     * <code>string metropolitan_area = 1;</code>
     *
     * @return The bytes for metropolitanArea.
     */
    com.google.protobuf.ByteString getMetropolitanAreaBytes();
  }
  /**
   *
   *
   * <pre>
   * Representation of a network edge location as per
   * https://cloud.google.com/vpc/docs/edge-locations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation}
   */
  public static final class EdgeLocation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation)
      EdgeLocationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EdgeLocation.newBuilder() to construct.
    private EdgeLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EdgeLocation() {
      metropolitanArea_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EdgeLocation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_EdgeLocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_EdgeLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.class,
              com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder.class);
    }

    public static final int METROPOLITAN_AREA_FIELD_NUMBER = 1;
    private volatile java.lang.Object metropolitanArea_;
    /**
     *
     *
     * <pre>
     * Name of the metropolitan area.
     * </pre>
     *
     * <code>string metropolitan_area = 1;</code>
     *
     * @return The metropolitanArea.
     */
    @java.lang.Override
    public java.lang.String getMetropolitanArea() {
      java.lang.Object ref = metropolitanArea_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metropolitanArea_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the metropolitan area.
     * </pre>
     *
     * <code>string metropolitan_area = 1;</code>
     *
     * @return The bytes for metropolitanArea.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetropolitanAreaBytes() {
      java.lang.Object ref = metropolitanArea_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metropolitanArea_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metropolitanArea_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metropolitanArea_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metropolitanArea_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metropolitanArea_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation)) {
        return super.equals(obj);
      }
      com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation other =
          (com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation) obj;

      if (!getMetropolitanArea().equals(other.getMetropolitanArea())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METROPOLITAN_AREA_FIELD_NUMBER;
      hash = (53 * hash) + getMetropolitanArea().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Representation of a network edge location as per
     * https://cloud.google.com/vpc/docs/edge-locations.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation)
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
            .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_EdgeLocation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
            .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_EdgeLocation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.class,
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        metropolitanArea_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
            .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_EdgeLocation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
          getDefaultInstanceForType() {
        return com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation build() {
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation buildPartial() {
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation result =
            new com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation(this);
        result.metropolitanArea_ = metropolitanArea_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation) {
          return mergeFrom(
              (com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation other) {
        if (other
            == com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
                .getDefaultInstance()) return this;
        if (!other.getMetropolitanArea().isEmpty()) {
          metropolitanArea_ = other.metropolitanArea_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  metropolitanArea_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object metropolitanArea_ = "";
      /**
       *
       *
       * <pre>
       * Name of the metropolitan area.
       * </pre>
       *
       * <code>string metropolitan_area = 1;</code>
       *
       * @return The metropolitanArea.
       */
      public java.lang.String getMetropolitanArea() {
        java.lang.Object ref = metropolitanArea_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metropolitanArea_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the metropolitan area.
       * </pre>
       *
       * <code>string metropolitan_area = 1;</code>
       *
       * @return The bytes for metropolitanArea.
       */
      public com.google.protobuf.ByteString getMetropolitanAreaBytes() {
        java.lang.Object ref = metropolitanArea_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metropolitanArea_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the metropolitan area.
       * </pre>
       *
       * <code>string metropolitan_area = 1;</code>
       *
       * @param value The metropolitanArea to set.
       * @return This builder for chaining.
       */
      public Builder setMetropolitanArea(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        metropolitanArea_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the metropolitan area.
       * </pre>
       *
       * <code>string metropolitan_area = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetropolitanArea() {

        metropolitanArea_ = getDefaultInstance().getMetropolitanArea();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the metropolitan area.
       * </pre>
       *
       * <code>string metropolitan_area = 1;</code>
       *
       * @param value The bytes for metropolitanArea to set.
       * @return This builder for chaining.
       */
      public Builder setMetropolitanAreaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        metropolitanArea_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation)
    private static final com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation();
    }

    public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EdgeLocation> PARSER =
        new com.google.protobuf.AbstractParser<EdgeLocation>() {
          @java.lang.Override
          public EdgeLocation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EdgeLocation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EdgeLocation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RESULT_FIELD_NUMBER = 1;
  private int result_;
  /**
   *
   *
   * <pre>
   * The overall result of active probing.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
   *
   * @return The enum numeric value on the wire for result.
   */
  @java.lang.Override
  public int getResultValue() {
    return result_;
  }
  /**
   *
   *
   * <pre>
   * The overall result of active probing.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
   *
   * @return The result.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult getResult() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result =
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult.valueOf(result_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult.UNRECOGNIZED
        : result;
  }

  public static final int VERIFY_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp verifyTime_;
  /**
   *
   *
   * <pre>
   * The time that reachability was assessed through active probing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp verify_time = 2;</code>
   *
   * @return Whether the verifyTime field is set.
   */
  @java.lang.Override
  public boolean hasVerifyTime() {
    return verifyTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time that reachability was assessed through active probing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp verify_time = 2;</code>
   *
   * @return The verifyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVerifyTime() {
    return verifyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : verifyTime_;
  }
  /**
   *
   *
   * <pre>
   * The time that reachability was assessed through active probing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp verify_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVerifyTimeOrBuilder() {
    return getVerifyTime();
  }

  public static final int ERROR_FIELD_NUMBER = 3;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Details about an internal failure or the cancellation of active probing.
   * </pre>
   *
   * <code>.google.rpc.Status error = 3;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Details about an internal failure or the cancellation of active probing.
   * </pre>
   *
   * <code>.google.rpc.Status error = 3;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Details about an internal failure or the cancellation of active probing.
   * </pre>
   *
   * <code>.google.rpc.Status error = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int ABORT_CAUSE_FIELD_NUMBER = 4;
  private int abortCause_;
  /**
   *
   *
   * <pre>
   * The reason probing was aborted.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for abortCause.
   */
  @java.lang.Override
  public int getAbortCauseValue() {
    return abortCause_;
  }
  /**
   *
   *
   * <pre>
   * The reason probing was aborted.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
   * </code>
   *
   * @return The abortCause.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause
      getAbortCause() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause result =
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause.valueOf(
            abortCause_);
    return result == null
        ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause.UNRECOGNIZED
        : result;
  }

  public static final int SENT_PROBE_COUNT_FIELD_NUMBER = 5;
  private int sentProbeCount_;
  /**
   *
   *
   * <pre>
   * Number of probes sent.
   * </pre>
   *
   * <code>int32 sent_probe_count = 5;</code>
   *
   * @return The sentProbeCount.
   */
  @java.lang.Override
  public int getSentProbeCount() {
    return sentProbeCount_;
  }

  public static final int SUCCESSFUL_PROBE_COUNT_FIELD_NUMBER = 6;
  private int successfulProbeCount_;
  /**
   *
   *
   * <pre>
   * Number of probes that reached the destination.
   * </pre>
   *
   * <code>int32 successful_probe_count = 6;</code>
   *
   * @return The successfulProbeCount.
   */
  @java.lang.Override
  public int getSuccessfulProbeCount() {
    return successfulProbeCount_;
  }

  public static final int ENDPOINT_INFO_FIELD_NUMBER = 7;
  private com.google.cloud.networkmanagement.v1beta1.EndpointInfo endpointInfo_;
  /**
   *
   *
   * <pre>
   * The source and destination endpoints derived from the test input and used
   * for active probing.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
   *
   * @return Whether the endpointInfo field is set.
   */
  @java.lang.Override
  public boolean hasEndpointInfo() {
    return endpointInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * The source and destination endpoints derived from the test input and used
   * for active probing.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
   *
   * @return The endpointInfo.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.EndpointInfo getEndpointInfo() {
    return endpointInfo_ == null
        ? com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance()
        : endpointInfo_;
  }
  /**
   *
   *
   * <pre>
   * The source and destination endpoints derived from the test input and used
   * for active probing.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder
      getEndpointInfoOrBuilder() {
    return getEndpointInfo();
  }

  public static final int PROBING_LATENCY_FIELD_NUMBER = 8;
  private com.google.cloud.networkmanagement.v1beta1.LatencyDistribution probingLatency_;
  /**
   *
   *
   * <pre>
   * Latency as measured by active probing in one direction:
   * from the source to the destination endpoint.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
   *
   * @return Whether the probingLatency field is set.
   */
  @java.lang.Override
  public boolean hasProbingLatency() {
    return probingLatency_ != null;
  }
  /**
   *
   *
   * <pre>
   * Latency as measured by active probing in one direction:
   * from the source to the destination endpoint.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
   *
   * @return The probingLatency.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LatencyDistribution getProbingLatency() {
    return probingLatency_ == null
        ? com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.getDefaultInstance()
        : probingLatency_;
  }
  /**
   *
   *
   * <pre>
   * Latency as measured by active probing in one direction:
   * from the source to the destination endpoint.
   * </pre>
   *
   * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.LatencyDistributionOrBuilder
      getProbingLatencyOrBuilder() {
    return getProbingLatency();
  }

  public static final int DESTINATION_EGRESS_LOCATION_FIELD_NUMBER = 9;
  private com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
      destinationEgressLocation_;
  /**
   *
   *
   * <pre>
   * The EdgeLocation from which a packet destined for/originating from the
   * internet will egress/ingress the Google network.
   * This will only be populated for a connectivity test which has an internet
   * destination/source address.
   * The absence of this field *must not* be used as an indication that the
   * destination/source is part of the Google network.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
   * </code>
   *
   * @return Whether the destinationEgressLocation field is set.
   */
  @java.lang.Override
  public boolean hasDestinationEgressLocation() {
    return destinationEgressLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * The EdgeLocation from which a packet destined for/originating from the
   * internet will egress/ingress the Google network.
   * This will only be populated for a connectivity test which has an internet
   * destination/source address.
   * The absence of this field *must not* be used as an indication that the
   * destination/source is part of the Google network.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
   * </code>
   *
   * @return The destinationEgressLocation.
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
      getDestinationEgressLocation() {
    return destinationEgressLocation_ == null
        ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
            .getDefaultInstance()
        : destinationEgressLocation_;
  }
  /**
   *
   *
   * <pre>
   * The EdgeLocation from which a packet destined for/originating from the
   * internet will egress/ingress the Google network.
   * This will only be populated for a connectivity test which has an internet
   * destination/source address.
   * The absence of this field *must not* be used as an indication that the
   * destination/source is part of the Google network.
   * </pre>
   *
   * <code>
   * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocationOrBuilder
      getDestinationEgressLocationOrBuilder() {
    return getDestinationEgressLocation();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (result_
        != com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult
            .PROBING_RESULT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, result_);
    }
    if (verifyTime_ != null) {
      output.writeMessage(2, getVerifyTime());
    }
    if (error_ != null) {
      output.writeMessage(3, getError());
    }
    if (abortCause_
        != com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause
            .PROBING_ABORT_CAUSE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, abortCause_);
    }
    if (sentProbeCount_ != 0) {
      output.writeInt32(5, sentProbeCount_);
    }
    if (successfulProbeCount_ != 0) {
      output.writeInt32(6, successfulProbeCount_);
    }
    if (endpointInfo_ != null) {
      output.writeMessage(7, getEndpointInfo());
    }
    if (probingLatency_ != null) {
      output.writeMessage(8, getProbingLatency());
    }
    if (destinationEgressLocation_ != null) {
      output.writeMessage(9, getDestinationEgressLocation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (result_
        != com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult
            .PROBING_RESULT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, result_);
    }
    if (verifyTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getVerifyTime());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getError());
    }
    if (abortCause_
        != com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause
            .PROBING_ABORT_CAUSE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, abortCause_);
    }
    if (sentProbeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, sentProbeCount_);
    }
    if (successfulProbeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, successfulProbeCount_);
    }
    if (endpointInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEndpointInfo());
    }
    if (probingLatency_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getProbingLatency());
    }
    if (destinationEgressLocation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getDestinationEgressLocation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkmanagement.v1beta1.ProbingDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.networkmanagement.v1beta1.ProbingDetails other =
        (com.google.cloud.networkmanagement.v1beta1.ProbingDetails) obj;

    if (result_ != other.result_) return false;
    if (hasVerifyTime() != other.hasVerifyTime()) return false;
    if (hasVerifyTime()) {
      if (!getVerifyTime().equals(other.getVerifyTime())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (abortCause_ != other.abortCause_) return false;
    if (getSentProbeCount() != other.getSentProbeCount()) return false;
    if (getSuccessfulProbeCount() != other.getSuccessfulProbeCount()) return false;
    if (hasEndpointInfo() != other.hasEndpointInfo()) return false;
    if (hasEndpointInfo()) {
      if (!getEndpointInfo().equals(other.getEndpointInfo())) return false;
    }
    if (hasProbingLatency() != other.hasProbingLatency()) return false;
    if (hasProbingLatency()) {
      if (!getProbingLatency().equals(other.getProbingLatency())) return false;
    }
    if (hasDestinationEgressLocation() != other.hasDestinationEgressLocation()) return false;
    if (hasDestinationEgressLocation()) {
      if (!getDestinationEgressLocation().equals(other.getDestinationEgressLocation()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESULT_FIELD_NUMBER;
    hash = (53 * hash) + result_;
    if (hasVerifyTime()) {
      hash = (37 * hash) + VERIFY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVerifyTime().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (37 * hash) + ABORT_CAUSE_FIELD_NUMBER;
    hash = (53 * hash) + abortCause_;
    hash = (37 * hash) + SENT_PROBE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSentProbeCount();
    hash = (37 * hash) + SUCCESSFUL_PROBE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSuccessfulProbeCount();
    if (hasEndpointInfo()) {
      hash = (37 * hash) + ENDPOINT_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointInfo().hashCode();
    }
    if (hasProbingLatency()) {
      hash = (37 * hash) + PROBING_LATENCY_FIELD_NUMBER;
      hash = (53 * hash) + getProbingLatency().hashCode();
    }
    if (hasDestinationEgressLocation()) {
      hash = (37 * hash) + DESTINATION_EGRESS_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationEgressLocation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkmanagement.v1beta1.ProbingDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Results of active probing from the last run of the test.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkmanagement.v1beta1.ProbingDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkmanagement.v1beta1.ProbingDetails)
      com.google.cloud.networkmanagement.v1beta1.ProbingDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkmanagement.v1beta1.ProbingDetails.class,
              com.google.cloud.networkmanagement.v1beta1.ProbingDetails.Builder.class);
    }

    // Construct using com.google.cloud.networkmanagement.v1beta1.ProbingDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      result_ = 0;

      if (verifyTimeBuilder_ == null) {
        verifyTime_ = null;
      } else {
        verifyTime_ = null;
        verifyTimeBuilder_ = null;
      }
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      abortCause_ = 0;

      sentProbeCount_ = 0;

      successfulProbeCount_ = 0;

      if (endpointInfoBuilder_ == null) {
        endpointInfo_ = null;
      } else {
        endpointInfo_ = null;
        endpointInfoBuilder_ = null;
      }
      if (probingLatencyBuilder_ == null) {
        probingLatency_ = null;
      } else {
        probingLatency_ = null;
        probingLatencyBuilder_ = null;
      }
      if (destinationEgressLocationBuilder_ == null) {
        destinationEgressLocation_ = null;
      } else {
        destinationEgressLocation_ = null;
        destinationEgressLocationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkmanagement.v1beta1.TestOuterClass
          .internal_static_google_cloud_networkmanagement_v1beta1_ProbingDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails getDefaultInstanceForType() {
      return com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails build() {
      com.google.cloud.networkmanagement.v1beta1.ProbingDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails buildPartial() {
      com.google.cloud.networkmanagement.v1beta1.ProbingDetails result =
          new com.google.cloud.networkmanagement.v1beta1.ProbingDetails(this);
      result.result_ = result_;
      if (verifyTimeBuilder_ == null) {
        result.verifyTime_ = verifyTime_;
      } else {
        result.verifyTime_ = verifyTimeBuilder_.build();
      }
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      result.abortCause_ = abortCause_;
      result.sentProbeCount_ = sentProbeCount_;
      result.successfulProbeCount_ = successfulProbeCount_;
      if (endpointInfoBuilder_ == null) {
        result.endpointInfo_ = endpointInfo_;
      } else {
        result.endpointInfo_ = endpointInfoBuilder_.build();
      }
      if (probingLatencyBuilder_ == null) {
        result.probingLatency_ = probingLatency_;
      } else {
        result.probingLatency_ = probingLatencyBuilder_.build();
      }
      if (destinationEgressLocationBuilder_ == null) {
        result.destinationEgressLocation_ = destinationEgressLocation_;
      } else {
        result.destinationEgressLocation_ = destinationEgressLocationBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkmanagement.v1beta1.ProbingDetails) {
        return mergeFrom((com.google.cloud.networkmanagement.v1beta1.ProbingDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkmanagement.v1beta1.ProbingDetails other) {
      if (other == com.google.cloud.networkmanagement.v1beta1.ProbingDetails.getDefaultInstance())
        return this;
      if (other.result_ != 0) {
        setResultValue(other.getResultValue());
      }
      if (other.hasVerifyTime()) {
        mergeVerifyTime(other.getVerifyTime());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.abortCause_ != 0) {
        setAbortCauseValue(other.getAbortCauseValue());
      }
      if (other.getSentProbeCount() != 0) {
        setSentProbeCount(other.getSentProbeCount());
      }
      if (other.getSuccessfulProbeCount() != 0) {
        setSuccessfulProbeCount(other.getSuccessfulProbeCount());
      }
      if (other.hasEndpointInfo()) {
        mergeEndpointInfo(other.getEndpointInfo());
      }
      if (other.hasProbingLatency()) {
        mergeProbingLatency(other.getProbingLatency());
      }
      if (other.hasDestinationEgressLocation()) {
        mergeDestinationEgressLocation(other.getDestinationEgressLocation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                result_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                input.readMessage(getVerifyTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 32:
              {
                abortCause_ = input.readEnum();

                break;
              } // case 32
            case 40:
              {
                sentProbeCount_ = input.readInt32();

                break;
              } // case 40
            case 48:
              {
                successfulProbeCount_ = input.readInt32();

                break;
              } // case 48
            case 58:
              {
                input.readMessage(getEndpointInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getProbingLatencyFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getDestinationEgressLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int result_ = 0;
    /**
     *
     *
     * <pre>
     * The overall result of active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
     *
     * @return The enum numeric value on the wire for result.
     */
    @java.lang.Override
    public int getResultValue() {
      return result_;
    }
    /**
     *
     *
     * <pre>
     * The overall result of active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
     *
     * @param value The enum numeric value on the wire for result to set.
     * @return This builder for chaining.
     */
    public Builder setResultValue(int value) {

      result_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall result of active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
     *
     * @return The result.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult getResult() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result =
          com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult.valueOf(result_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The overall result of active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
     *
     * @param value The result to set.
     * @return This builder for chaining.
     */
    public Builder setResult(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult value) {
      if (value == null) {
        throw new NullPointerException();
      }

      result_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall result of active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingResult result = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResult() {

      result_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp verifyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        verifyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     *
     * @return Whether the verifyTime field is set.
     */
    public boolean hasVerifyTime() {
      return verifyTimeBuilder_ != null || verifyTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     *
     * @return The verifyTime.
     */
    public com.google.protobuf.Timestamp getVerifyTime() {
      if (verifyTimeBuilder_ == null) {
        return verifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : verifyTime_;
      } else {
        return verifyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder setVerifyTime(com.google.protobuf.Timestamp value) {
      if (verifyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        verifyTime_ = value;
        onChanged();
      } else {
        verifyTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder setVerifyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (verifyTimeBuilder_ == null) {
        verifyTime_ = builderForValue.build();
        onChanged();
      } else {
        verifyTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder mergeVerifyTime(com.google.protobuf.Timestamp value) {
      if (verifyTimeBuilder_ == null) {
        if (verifyTime_ != null) {
          verifyTime_ =
              com.google.protobuf.Timestamp.newBuilder(verifyTime_).mergeFrom(value).buildPartial();
        } else {
          verifyTime_ = value;
        }
        onChanged();
      } else {
        verifyTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public Builder clearVerifyTime() {
      if (verifyTimeBuilder_ == null) {
        verifyTime_ = null;
        onChanged();
      } else {
        verifyTime_ = null;
        verifyTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getVerifyTimeBuilder() {

      onChanged();
      return getVerifyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getVerifyTimeOrBuilder() {
      if (verifyTimeBuilder_ != null) {
        return verifyTimeBuilder_.getMessageOrBuilder();
      } else {
        return verifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : verifyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time that reachability was assessed through active probing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp verify_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVerifyTimeFieldBuilder() {
      if (verifyTimeBuilder_ == null) {
        verifyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVerifyTime(), getParentForChildren(), isClean());
        verifyTime_ = null;
      }
      return verifyTimeBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Details about an internal failure or the cancellation of active probing.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private int abortCause_ = 0;
    /**
     *
     *
     * <pre>
     * The reason probing was aborted.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for abortCause.
     */
    @java.lang.Override
    public int getAbortCauseValue() {
      return abortCause_;
    }
    /**
     *
     *
     * <pre>
     * The reason probing was aborted.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for abortCause to set.
     * @return This builder for chaining.
     */
    public Builder setAbortCauseValue(int value) {

      abortCause_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The reason probing was aborted.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
     * </code>
     *
     * @return The abortCause.
     */
    @java.lang.Override
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause
        getAbortCause() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause result =
          com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause.valueOf(
              abortCause_);
      return result == null
          ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The reason probing was aborted.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
     * </code>
     *
     * @param value The abortCause to set.
     * @return This builder for chaining.
     */
    public Builder setAbortCause(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause value) {
      if (value == null) {
        throw new NullPointerException();
      }

      abortCause_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The reason probing was aborted.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.ProbingAbortCause abort_cause = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAbortCause() {

      abortCause_ = 0;
      onChanged();
      return this;
    }

    private int sentProbeCount_;
    /**
     *
     *
     * <pre>
     * Number of probes sent.
     * </pre>
     *
     * <code>int32 sent_probe_count = 5;</code>
     *
     * @return The sentProbeCount.
     */
    @java.lang.Override
    public int getSentProbeCount() {
      return sentProbeCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of probes sent.
     * </pre>
     *
     * <code>int32 sent_probe_count = 5;</code>
     *
     * @param value The sentProbeCount to set.
     * @return This builder for chaining.
     */
    public Builder setSentProbeCount(int value) {

      sentProbeCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of probes sent.
     * </pre>
     *
     * <code>int32 sent_probe_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSentProbeCount() {

      sentProbeCount_ = 0;
      onChanged();
      return this;
    }

    private int successfulProbeCount_;
    /**
     *
     *
     * <pre>
     * Number of probes that reached the destination.
     * </pre>
     *
     * <code>int32 successful_probe_count = 6;</code>
     *
     * @return The successfulProbeCount.
     */
    @java.lang.Override
    public int getSuccessfulProbeCount() {
      return successfulProbeCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of probes that reached the destination.
     * </pre>
     *
     * <code>int32 successful_probe_count = 6;</code>
     *
     * @param value The successfulProbeCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessfulProbeCount(int value) {

      successfulProbeCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of probes that reached the destination.
     * </pre>
     *
     * <code>int32 successful_probe_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessfulProbeCount() {

      successfulProbeCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.networkmanagement.v1beta1.EndpointInfo endpointInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder>
        endpointInfoBuilder_;
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     *
     * @return Whether the endpointInfo field is set.
     */
    public boolean hasEndpointInfo() {
      return endpointInfoBuilder_ != null || endpointInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     *
     * @return The endpointInfo.
     */
    public com.google.cloud.networkmanagement.v1beta1.EndpointInfo getEndpointInfo() {
      if (endpointInfoBuilder_ == null) {
        return endpointInfo_ == null
            ? com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance()
            : endpointInfo_;
      } else {
        return endpointInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    public Builder setEndpointInfo(com.google.cloud.networkmanagement.v1beta1.EndpointInfo value) {
      if (endpointInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointInfo_ = value;
        onChanged();
      } else {
        endpointInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    public Builder setEndpointInfo(
        com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder builderForValue) {
      if (endpointInfoBuilder_ == null) {
        endpointInfo_ = builderForValue.build();
        onChanged();
      } else {
        endpointInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    public Builder mergeEndpointInfo(
        com.google.cloud.networkmanagement.v1beta1.EndpointInfo value) {
      if (endpointInfoBuilder_ == null) {
        if (endpointInfo_ != null) {
          endpointInfo_ =
              com.google.cloud.networkmanagement.v1beta1.EndpointInfo.newBuilder(endpointInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          endpointInfo_ = value;
        }
        onChanged();
      } else {
        endpointInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    public Builder clearEndpointInfo() {
      if (endpointInfoBuilder_ == null) {
        endpointInfo_ = null;
        onChanged();
      } else {
        endpointInfo_ = null;
        endpointInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder
        getEndpointInfoBuilder() {

      onChanged();
      return getEndpointInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder
        getEndpointInfoOrBuilder() {
      if (endpointInfoBuilder_ != null) {
        return endpointInfoBuilder_.getMessageOrBuilder();
      } else {
        return endpointInfo_ == null
            ? com.google.cloud.networkmanagement.v1beta1.EndpointInfo.getDefaultInstance()
            : endpointInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The source and destination endpoints derived from the test input and used
     * for active probing.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.EndpointInfo endpoint_info = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder,
            com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder>
        getEndpointInfoFieldBuilder() {
      if (endpointInfoBuilder_ == null) {
        endpointInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.EndpointInfo,
                com.google.cloud.networkmanagement.v1beta1.EndpointInfo.Builder,
                com.google.cloud.networkmanagement.v1beta1.EndpointInfoOrBuilder>(
                getEndpointInfo(), getParentForChildren(), isClean());
        endpointInfo_ = null;
      }
      return endpointInfoBuilder_;
    }

    private com.google.cloud.networkmanagement.v1beta1.LatencyDistribution probingLatency_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.LatencyDistribution,
            com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.Builder,
            com.google.cloud.networkmanagement.v1beta1.LatencyDistributionOrBuilder>
        probingLatencyBuilder_;
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     *
     * @return Whether the probingLatency field is set.
     */
    public boolean hasProbingLatency() {
      return probingLatencyBuilder_ != null || probingLatency_ != null;
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     *
     * @return The probingLatency.
     */
    public com.google.cloud.networkmanagement.v1beta1.LatencyDistribution getProbingLatency() {
      if (probingLatencyBuilder_ == null) {
        return probingLatency_ == null
            ? com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.getDefaultInstance()
            : probingLatency_;
      } else {
        return probingLatencyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    public Builder setProbingLatency(
        com.google.cloud.networkmanagement.v1beta1.LatencyDistribution value) {
      if (probingLatencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        probingLatency_ = value;
        onChanged();
      } else {
        probingLatencyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    public Builder setProbingLatency(
        com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.Builder builderForValue) {
      if (probingLatencyBuilder_ == null) {
        probingLatency_ = builderForValue.build();
        onChanged();
      } else {
        probingLatencyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    public Builder mergeProbingLatency(
        com.google.cloud.networkmanagement.v1beta1.LatencyDistribution value) {
      if (probingLatencyBuilder_ == null) {
        if (probingLatency_ != null) {
          probingLatency_ =
              com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.newBuilder(
                      probingLatency_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          probingLatency_ = value;
        }
        onChanged();
      } else {
        probingLatencyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    public Builder clearProbingLatency() {
      if (probingLatencyBuilder_ == null) {
        probingLatency_ = null;
        onChanged();
      } else {
        probingLatency_ = null;
        probingLatencyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.Builder
        getProbingLatencyBuilder() {

      onChanged();
      return getProbingLatencyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    public com.google.cloud.networkmanagement.v1beta1.LatencyDistributionOrBuilder
        getProbingLatencyOrBuilder() {
      if (probingLatencyBuilder_ != null) {
        return probingLatencyBuilder_.getMessageOrBuilder();
      } else {
        return probingLatency_ == null
            ? com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.getDefaultInstance()
            : probingLatency_;
      }
    }
    /**
     *
     *
     * <pre>
     * Latency as measured by active probing in one direction:
     * from the source to the destination endpoint.
     * </pre>
     *
     * <code>.google.cloud.networkmanagement.v1beta1.LatencyDistribution probing_latency = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.LatencyDistribution,
            com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.Builder,
            com.google.cloud.networkmanagement.v1beta1.LatencyDistributionOrBuilder>
        getProbingLatencyFieldBuilder() {
      if (probingLatencyBuilder_ == null) {
        probingLatencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.LatencyDistribution,
                com.google.cloud.networkmanagement.v1beta1.LatencyDistribution.Builder,
                com.google.cloud.networkmanagement.v1beta1.LatencyDistributionOrBuilder>(
                getProbingLatency(), getParentForChildren(), isClean());
        probingLatency_ = null;
      }
      return probingLatencyBuilder_;
    }

    private com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        destinationEgressLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocationOrBuilder>
        destinationEgressLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     *
     * @return Whether the destinationEgressLocation field is set.
     */
    public boolean hasDestinationEgressLocation() {
      return destinationEgressLocationBuilder_ != null || destinationEgressLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     *
     * @return The destinationEgressLocation.
     */
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
        getDestinationEgressLocation() {
      if (destinationEgressLocationBuilder_ == null) {
        return destinationEgressLocation_ == null
            ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
                .getDefaultInstance()
            : destinationEgressLocation_;
      } else {
        return destinationEgressLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    public Builder setDestinationEgressLocation(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation value) {
      if (destinationEgressLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationEgressLocation_ = value;
        onChanged();
      } else {
        destinationEgressLocationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    public Builder setDestinationEgressLocation(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder
            builderForValue) {
      if (destinationEgressLocationBuilder_ == null) {
        destinationEgressLocation_ = builderForValue.build();
        onChanged();
      } else {
        destinationEgressLocationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    public Builder mergeDestinationEgressLocation(
        com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation value) {
      if (destinationEgressLocationBuilder_ == null) {
        if (destinationEgressLocation_ != null) {
          destinationEgressLocation_ =
              com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.newBuilder(
                      destinationEgressLocation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destinationEgressLocation_ = value;
        }
        onChanged();
      } else {
        destinationEgressLocationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    public Builder clearDestinationEgressLocation() {
      if (destinationEgressLocationBuilder_ == null) {
        destinationEgressLocation_ = null;
        onChanged();
      } else {
        destinationEgressLocation_ = null;
        destinationEgressLocationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder
        getDestinationEgressLocationBuilder() {

      onChanged();
      return getDestinationEgressLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    public com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocationOrBuilder
        getDestinationEgressLocationOrBuilder() {
      if (destinationEgressLocationBuilder_ != null) {
        return destinationEgressLocationBuilder_.getMessageOrBuilder();
      } else {
        return destinationEgressLocation_ == null
            ? com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation
                .getDefaultInstance()
            : destinationEgressLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The EdgeLocation from which a packet destined for/originating from the
     * internet will egress/ingress the Google network.
     * This will only be populated for a connectivity test which has an internet
     * destination/source address.
     * The absence of this field *must not* be used as an indication that the
     * destination/source is part of the Google network.
     * </pre>
     *
     * <code>
     * .google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation destination_egress_location = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder,
            com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocationOrBuilder>
        getDestinationEgressLocationFieldBuilder() {
      if (destinationEgressLocationBuilder_ == null) {
        destinationEgressLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation,
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocation.Builder,
                com.google.cloud.networkmanagement.v1beta1.ProbingDetails.EdgeLocationOrBuilder>(
                getDestinationEgressLocation(), getParentForChildren(), isClean());
        destinationEgressLocation_ = null;
      }
      return destinationEgressLocationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkmanagement.v1beta1.ProbingDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkmanagement.v1beta1.ProbingDetails)
  private static final com.google.cloud.networkmanagement.v1beta1.ProbingDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkmanagement.v1beta1.ProbingDetails();
  }

  public static com.google.cloud.networkmanagement.v1beta1.ProbingDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProbingDetails> PARSER =
      new com.google.protobuf.AbstractParser<ProbingDetails>() {
        @java.lang.Override
        public ProbingDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProbingDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProbingDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkmanagement.v1beta1.ProbingDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
